/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5944;
import net.minecraft.class_757;

public final class ShapeRenderer {
    private static float zLevel = 0.0f;
    private static float red = 1.0f;
    private static float green = 1.0f;
    private static float blue = 1.0f;
    private static float alpha = 1.0f;
    private static Supplier<class_5944> shader = class_757::method_34541;

    private ShapeRenderer() {
    }

    public static void drawRectWithTexture(class_4587 matrixStack, float x, float y, float width, float height, class_1058 sprite) {
        ShapeRenderer.drawRectWithTexture(matrixStack, x, y, sprite.method_4594(), sprite.method_4593(), width, height, sprite.method_4577() - sprite.method_4594(), sprite.method_4575() - sprite.method_4593(), 1.0f, 1.0f);
    }

    public static void drawRectWithTexture(class_4587 matrixStack, float x, float y, float u, float v, float width, float height) {
        ShapeRenderer.drawRectWithTexture(matrixStack, x, y, u, v, width, height, width, height, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(class_4587 matrixStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        ShapeRenderer.drawRectWithTexture(matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(class_4587 matrixStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight, float sourceWidth, float sourceHeight) {
        ShapeRenderer.drawRectWithTexture(ShapeRenderer.begin(), matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, sourceWidth, sourceHeight);
        ShapeRenderer.end();
    }

    public static class_4588 begin() {
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        return buffer;
    }

    public static void end() {
        RenderSystem.setShader(shader);
        class_289.method_1348().method_1350();
        zLevel = 0.0f;
        ShapeRenderer.resetColor();
        shader = class_757::method_34541;
    }

    public static void drawRectWithTexture(class_4588 buffer, class_4587 matrixStack, float x, float y, float width, float height, class_1058 sprite) {
        ShapeRenderer.drawRectWithTexture(buffer, matrixStack, x, y, sprite.method_4594(), sprite.method_4593(), width, height, sprite.method_4577() - sprite.method_4594(), sprite.method_4575() - sprite.method_4593(), 1.0f, 1.0f);
    }

    public static void drawRectWithTexture(class_4588 buffer, class_4587 matrixStack, float x, float y, float u, float v, float width, float height) {
        ShapeRenderer.drawRectWithTexture(buffer, matrixStack, x, y, u, v, width, height, width, height, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(class_4588 buffer, class_4587 matrixStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        ShapeRenderer.drawRectWithTexture(buffer, matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, 256.0f, 256.0f);
    }

    public static void drawRectWithTexture(class_4588 buffer, class_4587 matrixStack, float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight, float sourceWidth, float sourceHeight) {
        float scaleWidth = 1.0f / sourceWidth;
        float scaleHeight = 1.0f / sourceHeight;
        class_1159 matrix4f = matrixStack.method_23760().method_23761();
        buffer.method_22918(matrix4f, x, y + height, zLevel).method_22915(red, green, blue, alpha).method_22913(u * scaleWidth, (v + textureHeight) * scaleHeight).method_1344();
        buffer.method_22918(matrix4f, x + width, y + height, zLevel).method_22915(red, green, blue, alpha).method_22913((u + textureWidth) * scaleWidth, (v + textureHeight) * scaleHeight).method_1344();
        buffer.method_22918(matrix4f, x + width, y, zLevel).method_22915(red, green, blue, alpha).method_22913((u + textureWidth) * scaleWidth, v * scaleHeight).method_1344();
        buffer.method_22918(matrix4f, x, y, zLevel).method_22915(red, green, blue, alpha).method_22913(u * scaleWidth, v * scaleHeight).method_1344();
    }

    public static void drawSunburst(class_4587 matrixStack, float x, float y, float width, float height, int segments) {
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        class_1159 matrix4f = matrixStack.method_23760().method_23761();
        float burstAngleOffset = (float)(Math.PI * (double)(1.0f / (float)segments / 2.0f));
        for (int i = 0; i < segments; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)segments + 1.5707963267948966);
            builder.method_22918(matrix4f, x, y, zLevel).method_22915(red, green, blue, alpha).method_1344();
            builder.method_22918(matrix4f, x + class_3532.method_15362((float)(angle + burstAngleOffset)) * width / 2.0f, y + class_3532.method_15374((float)(angle + burstAngleOffset)) * height / 2.0f, zLevel).method_22915(red, green, blue, alpha).method_1344();
            builder.method_22918(matrix4f, x + class_3532.method_15362((float)(angle - burstAngleOffset)) * width / 2.0f, y + class_3532.method_15374((float)(angle - burstAngleOffset)) * height / 2.0f, zLevel).method_22915(red, green, blue, alpha).method_1344();
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        ShapeRenderer.end();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void resetColor() {
        red = 1.0f;
        green = 1.0f;
        blue = 1.0f;
        alpha = 1.0f;
    }

    public static void setZLevel(float zLevel) {
        ShapeRenderer.zLevel = zLevel;
    }

    public static void setColor(float red, float green, float blue, float alpha) {
        ShapeRenderer.red = red;
        ShapeRenderer.green = green;
        ShapeRenderer.blue = blue;
        ShapeRenderer.alpha = alpha;
    }

    public static void setColor(int color) {
        red = (float)(color >> 16 & 0xFF) / 255.0f;
        green = (float)(color >> 8 & 0xFF) / 255.0f;
        blue = (float)(color & 0xFF) / 255.0f;
        alpha = (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void setShader(Supplier<class_5944> shader) {
        ShapeRenderer.shader = shader;
    }
}

