/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.block;

import com.google.common.base.Suppliers;
import gg.moonflower.pollen.api.fluid.PollinatedFluid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_47;
import net.minecraft.class_4970;

public class PollinatedLiquidBlock
extends class_2248
implements class_2263 {
    public static final class_2758 LEVEL = class_2741.field_12538;
    public static final class_265 STABLE_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private final Supplier<class_3609> fluid;
    private final Supplier<List<class_3610>> stateCache;

    public PollinatedLiquidBlock(Supplier<class_3609> fluid, class_4970.class_2251 properties) {
        super(properties);
        this.fluid = fluid;
        this.stateCache = Suppliers.memoize(() -> {
            class_3609 flowingFluid = (class_3609)fluid.get();
            ArrayList<class_3610> list = new ArrayList<class_3610>();
            list.add(flowingFluid.method_15729(false));
            for (int i = 1; i < 8; ++i) {
                list.add(flowingFluid.method_15728(8 - i, false));
            }
            list.add(flowingFluid.method_15728(8, true));
            return list;
        });
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public PollinatedLiquidBlock(class_3609 fluid, class_4970.class_2251 properties) {
        this(() -> fluid, properties);
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return context.method_16192(STABLE_SHAPE, pos, true) && (Integer)state.method_11654((class_2769)LEVEL) == 0 && context.method_27866(level.method_8316(pos.method_10084()), this.getFluid()) ? STABLE_SHAPE : class_259.method_1073();
    }

    public boolean method_9542(class_2680 state) {
        return state.method_26227().method_15773();
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, Random random) {
        state.method_26227().method_15757((class_1937)level, pos, random);
    }

    public boolean method_9579(class_2680 state, class_1922 level, class_2338 pos) {
        return false;
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        return !this.getFluid().method_15791((class_3494)class_3486.field_15518);
    }

    public class_3610 method_9545(class_2680 state) {
        return this.stateCache.get().get(Math.min((Integer)state.method_11654((class_2769)LEVEL), 8));
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_9522(class_2680 state, class_2680 adjacentBlockState, class_2350 direction) {
        return adjacentBlockState.method_26227().method_15772().method_15780((class_3611)this.getFluid());
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    public List<class_1799> method_9560(class_2680 state, class_47.class_48 builder) {
        return Collections.emptyList();
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return class_259.method_1073();
    }

    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (this.shouldSpreadLiquid(level, pos)) {
            level.method_39281(pos, state.method_26227().method_15772(), this.getFluid().method_15789((class_4538)level));
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        if (state.method_26227().method_15771() || neighborState.method_26227().method_15771()) {
            level.method_39281(currentPos, state.method_26227().method_15772(), this.getFluid().method_15789((class_4538)level));
        }
        return super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        if (this.shouldSpreadLiquid(level, pos)) {
            level.method_39281(pos, state.method_26227().method_15772(), this.getFluid().method_15789((class_4538)level));
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LEVEL});
    }

    public class_1799 method_9700(class_1936 level, class_2338 pos, class_2680 state) {
        if ((Integer)state.method_11654((class_2769)LEVEL) == 0) {
            level.method_8652(pos, class_2246.field_10124.method_9564(), 11);
            return new class_1799((class_1935)this.getFluid().method_15774());
        }
        return class_1799.field_8037;
    }

    public Optional<class_3414> method_32351() {
        return this.getFluid().method_32359();
    }

    public class_3609 getFluid() {
        return this.fluid.get();
    }

    protected boolean shouldSpreadLiquid(class_1937 level, class_2338 pos) {
        class_2350[] directions;
        if (!(this.fluid instanceof PollinatedFluid)) {
            return true;
        }
        PollinatedFluid behavior = (PollinatedFluid)((Object)this.fluid);
        class_3610 fluidState = level.method_8316(pos);
        for (class_2350 direction : directions = behavior.getInteractionDirections()) {
            class_2338 blockPos = pos.method_10093(direction);
            class_2680 interactionState = behavior.getInteractionState(level, fluidState, pos, blockPos);
            if (interactionState == null) continue;
            level.method_8501(pos, interactionState);
            behavior.playInteractionEffect(level, fluidState, pos);
            return false;
        }
        return true;
    }
}

