/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.someforgepatchesported.mixin;

import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.someforgepatchesported.mixin.RegistryReadOpsAccessor;
import net.minecraft.class_1208;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5382;
import net.minecraft.class_5455;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_32.class})
public class MixinLevelStorageSource {
    @Unique
    private static final Logger LOGGER = LogManager.getLogger((String)"Some Forge Patches Ported");
    @Unique
    private static final Set<String> VANILLA_DIMS = Sets.newHashSet((Object[])new String[]{"minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"});
    @Unique
    private static final String DIMENSIONS_KEY = "dimensions";
    @Unique
    private static final String SEED_KEY = "seed";
    @Unique
    private static final Supplier<Codec<class_2370<class_5363>>> CODEC = Suppliers.memoize(() -> class_2370.method_29721((class_5321)class_2378.field_25490, (Lifecycle)Lifecycle.stable(), (Codec)class_5363.field_25411).xmap(class_5363::method_29569, Function.identity()));

    @Redirect(method={"readWorldGenSettings"}, at=@At(value="INVOKE", target="Lcom/mojang/datafixers/DataFixer;update(Lcom/mojang/datafixers/DSL$TypeReference;Lcom/mojang/serialization/Dynamic;II)Lcom/mojang/serialization/Dynamic;"))
    private static <T> Dynamic<T> updateDfu(DataFixer dataFixer, DSL.TypeReference type, Dynamic<T> input, int version, int newVersion) {
        return MixinLevelStorageSource.fixUpDimensionsData(dataFixer.update(class_1208.field_23067, input, version, newVersion));
    }

    @Unique
    private static <T> Dynamic<T> fixUpDimensionsData(Dynamic<T> data) {
        DynamicOps dynamicOps = data.getOps();
        if (!(dynamicOps instanceof class_5382)) {
            return data;
        }
        class_5382 ops = (class_5382)dynamicOps;
        Dynamic dymData = data.get(DIMENSIONS_KEY).orElseEmptyMap();
        Dynamic withInjected = dymData.asMapOpt().map(current -> {
            List currentList = current.map(p -> p.mapFirst(dyn -> dyn.asString().result().orElse("")).mapSecond(Dynamic::getValue)).collect(Collectors.toList());
            Set currentDimNames = currentList.stream().map(Pair::getFirst).collect(Collectors.toSet());
            if (!currentDimNames.containsAll(VANILLA_DIMS)) {
                LOGGER.warn("Detected missing vanilla dimensions from the world!");
                class_5455 regs = ((RegistryReadOpsAccessor)ops).getRegistryAccess();
                long seed = data.get(SEED_KEY).get().result().map(d -> d.asLong(0L)).orElse(0L);
                class_2378 typeReg = regs.method_30530(class_2378.field_25095);
                class_2370 dimReg = class_2874.method_39540((class_5455)regs, (long)seed);
                dimReg = class_5285.method_28608((class_2378)typeReg, (class_2370)dimReg, (class_2794)class_5285.method_28604((class_5455)regs, (long)seed));
                dimReg = CODEC.get().encodeStart((DynamicOps)ops, (Object)dimReg).flatMap(t -> CODEC.get().parse((DynamicOps)ops, t)).result().orElse(dimReg);
                for (String name : VANILLA_DIMS) {
                    if (currentDimNames.contains(name)) continue;
                    class_5363 dim = (class_5363)dimReg.method_10223(new class_2960(name));
                    if (dim == null) {
                        LOGGER.error("The world is missing dimension: " + name + ", but the attempt to re-inject it failed.");
                        continue;
                    }
                    LOGGER.info("Fixing world: re-injected dimension: " + name);
                    currentList.add(Pair.of((Object)name, (Object)class_5363.field_25411.encodeStart((DynamicOps)ops, (Object)dim).resultOrPartial(s -> {}).orElse(ops.empty())));
                }
            } else {
                return dymData;
            }
            return new Dynamic((DynamicOps)ops, ops.createMap(currentList.stream().map(p -> p.mapFirst(arg_0 -> ((class_5382)ops).createString(arg_0)))));
        }).result().orElse(dymData);
        return data.set(DIMENSIONS_KEY, withInjected);
    }
}

