/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.impersonate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Pair;
import io.github.ladysnake.impersonate.Impersonate;
import io.github.ladysnake.impersonate.Impersonator;
import io.github.ladysnake.impersonate.impl.mixin.EntityTrackerAccessor;
import io.github.ladysnake.impersonate.impl.mixin.ThreadedAnvilChunkStorageAccessor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_2724;
import net.minecraft.class_2748;
import net.minecraft.class_2749;
import net.minecraft.class_2752;
import net.minecraft.class_2783;
import net.minecraft.class_2802;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_3898;
import net.minecraft.class_4543;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServerPlayerSkins {
    public static final class_2960 RELOAD_SKIN_PACKET = new class_2960("impersonate", "impersonation");
    private static final boolean FORCE_VANILLA_RELOADING = Boolean.getBoolean("impersonate.force_vanilla_reloading");
    private static final ExecutorService THREADPOOL = Executors.newCachedThreadPool();
    private static CompletableFuture<Pair<String, String>> currentSkinTask = CompletableFuture.completedFuture(null);

    public static synchronized void setSkin(@NotNull class_3222 player, GameProfile profile) {
        CompletableFuture<Pair<String, String>> previousSkinTask = currentSkinTask;
        currentSkinTask = CompletableFuture.supplyAsync(() -> {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + profile.getId().toString().replace("-", "") + "?unsigned=false").openConnection();
                if (connection.getResponseCode() == 200) {
                    String reply = IOUtils.toString((Reader)new InputStreamReader(connection.getInputStream()));
                    JsonObject json = class_3518.method_15285((String)reply);
                    for (JsonElement prop : class_3518.method_15261((JsonObject)json, (String)"properties")) {
                        JsonObject property = class_3518.method_15295((JsonElement)prop, (String)"property");
                        if (!class_3518.method_15265((JsonObject)property, (String)"name").equals("textures")) continue;
                        return Pair.of((Object)class_3518.method_15265((JsonObject)property, (String)"value"), (Object)class_3518.method_15265((JsonObject)property, (String)"signature"));
                    }
                    throw new JsonSyntaxException("No skin texture data in response for " + profile.getName());
                }
                return Pair.of(null, null);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, THREADPOOL).exceptionally(e -> {
            Impersonate.LOGGER.error("Failed to retrieve skin for " + profile.getName(), e);
            return Pair.of(null, null);
        });
        currentSkinTask.thenAcceptBothAsync(previousSkinTask, (pair, o) -> ServerPlayerSkins.setPlayerSkin(player, (String)pair.getFirst(), (String)pair.getSecond()), (Executor)player.field_6002.method_8503());
    }

    private static void setPlayerSkin(class_3222 player, @Nullable String value, @Nullable String signature) {
        PropertyMap realProperties = Impersonator.get((class_1657)player).getActualProfile().getProperties();
        PropertyMap editedProperties = Impersonator.get((class_1657)player).getEditedProfile().getProperties();
        realProperties.removeAll((Object)"textures");
        editedProperties.removeAll((Object)"textures");
        if (value != null && signature != null) {
            realProperties.put((Object)"textures", (Object)new Property("textures", value, signature));
            editedProperties.put((Object)"textures", (Object)new Property("textures", value, signature));
        }
        ServerPlayerSkins.reloadSkin(player);
    }

    private static void reloadSkin(class_3222 player) {
        for (class_3222 other : Objects.requireNonNull(player.method_5682()).method_3760().method_14571()) {
            other.field_13987.method_14364((class_2596)new class_2703(class_2703.class_5893.field_29140, new class_3222[]{player}));
            other.field_13987.method_14364((class_2596)new class_2703(class_2703.class_5893.field_29136, new class_3222[]{player}));
        }
        class_2802 manager = player.field_6002.method_8398();
        assert (manager instanceof class_3215);
        class_3898 storage = ((class_3215)manager).field_17254;
        EntityTrackerAccessor trackerEntry = (EntityTrackerAccessor)((ThreadedAnvilChunkStorageAccessor)storage).getEntityTrackers().get(player.method_5628());
        for (class_3222 tracking : PlayerLookup.tracking((class_1297)player)) {
            trackerEntry.getEntry().method_18760(tracking);
        }
        if (FORCE_VANILLA_RELOADING || !ServerPlayNetworking.canSend((class_3222)player, (class_2960)RELOAD_SKIN_PACKET)) {
            ServerPlayerSkins.reloadSkinVanilla(player);
        } else {
            ServerPlayNetworking.send((class_3222)player, (class_2960)RELOAD_SKIN_PACKET, (class_2540)PacketByteBufs.empty());
        }
    }

    private static void reloadSkinVanilla(class_3222 player) {
        class_3218 targetWorld = (class_3218)player.field_6002;
        player.field_13987.method_14364((class_2596)new class_2724(targetWorld.method_8597(), targetWorld.method_27983(), class_4543.method_27984((long)targetWorld.method_8412()), player.field_13974.method_14257(), player.field_13974.method_30119(), targetWorld.method_27982(), targetWorld.method_28125(), true));
        player.field_13987.method_14363(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        player.field_13995.method_3760().method_14576(player);
        player.field_13987.method_14364((class_2596)new class_2748(player.field_7510, player.field_7495, player.field_7520));
        player.field_13987.method_14364((class_2596)new class_2749(player.method_6032(), player.method_7344().method_7586(), player.method_7344().method_7589()));
        for (class_1293 statusEffect : player.method_6026()) {
            player.field_13987.method_14364((class_2596)new class_2783(player.method_5628(), statusEffect));
        }
        player.method_7355();
        player.field_13995.method_3760().method_14606(player, targetWorld);
        class_1297 vehicle = player.method_5854();
        if (vehicle != null) {
            player.field_13987.method_14364((class_2596)new class_2752(vehicle));
        }
        player.field_13995.method_3760().method_14594(player);
    }
}

