/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.impersonate.impl;

import com.mojang.authlib.GameProfile;
import dev.onyxstudios.cca.api.v3.component.CopyableComponent;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import io.github.ladysnake.impersonate.Impersonate;
import io.github.ladysnake.impersonate.Impersonator;
import io.github.ladysnake.impersonate.impl.ImpersonateGamerules;
import io.github.ladysnake.impersonate.impl.PlayerEntityExtensions;
import io.github.ladysnake.impersonate.impl.ServerPlayerSkins;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerImpersonator
implements Impersonator,
AutoSyncedComponent,
CopyableComponent<PlayerImpersonator> {
    @NotNull
    private final class_1657 player;
    private final Map<@NotNull class_2960, @NotNull GameProfile> stackedImpersonations = new LinkedHashMap<class_2960, GameProfile>();
    @Nullable
    private GameProfile impersonatedProfile;
    @Nullable
    private GameProfile editedProfile;
    private static final int ID_PRESENT = 1;
    private static final int NAME_PRESENT = 2;

    public PlayerImpersonator(@NotNull class_1657 player) {
        this.player = player;
    }

    @Override
    public void impersonate(@NotNull class_2960 key, @NotNull GameProfile profile) {
        this.stackedImpersonations.put(key, profile);
        this.setImpersonatedProfile(profile);
    }

    @Override
    public void stopImpersonations() {
        this.stackedImpersonations.clear();
        this.resetImpersonation();
    }

    @Override
    public GameProfile stopImpersonation(@NotNull class_2960 key) {
        if (this.isImpersonating()) {
            GameProfile ret = this.stackedImpersonations.remove(key);
            this.resetImpersonation();
            return ret;
        }
        return null;
    }

    private void resetImpersonation() {
        this.setImpersonatedProfile(this.getActiveImpersonation());
    }

    private GameProfile getActiveImpersonation() {
        GameProfile active = null;
        Iterator<GameProfile> iterator = this.stackedImpersonations.values().iterator();
        while (iterator.hasNext()) {
            GameProfile gameProfile;
            active = gameProfile = iterator.next();
        }
        return active;
    }

    private void setImpersonatedProfile(@Nullable GameProfile profile) {
        if (this.getImpersonatedProfile() != profile) {
            this.updatePlayerLists(class_2703.class_5893.field_29140);
            this.impersonatedProfile = profile;
            this.editedProfile = profile == null ? null : new GameProfile(this.getActualProfile().getId(), this.impersonatedProfile.getName());
            class_1657 class_16572 = this.player;
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                this.applyCapeGamerule(serverPlayer, profile);
                ServerPlayerSkins.setSkin(serverPlayer, profile == null ? this.getActualProfile() : profile);
            }
            this.updatePlayerLists(class_2703.class_5893.field_29136);
            Impersonate.IMPERSONATION.sync((Object)this.player);
        }
    }

    private void applyCapeGamerule(class_3222 player, GameProfile impersonatedProfile) {
        if (!player.method_14220().method_8450().method_8355(ImpersonateGamerules.FAKE_CAPES)) {
            if (impersonatedProfile == null) {
                ((PlayerEntityExtensions)player).impersonate_resetCape();
            } else {
                ((PlayerEntityExtensions)player).impersonate_disableCape();
            }
        }
    }

    private void updatePlayerLists(class_2703.class_5893 action) {
        class_3324 playerManager;
        if (!this.player.field_6002.field_9236 && this.isAloneOnServer(playerManager = ((class_3222)this.player).field_13995.method_3760())) {
            playerManager.method_14581((class_2596)new class_2703(action, new class_3222[]{(class_3222)this.player}));
        }
    }

    private boolean isAloneOnServer(class_3324 playerManager) {
        for (class_3222 otherPlayer : playerManager.method_14571()) {
            if (!this.isSamePersonAs(otherPlayer)) continue;
            return false;
        }
        return true;
    }

    private boolean isSamePersonAs(class_3222 otherPlayer) {
        return otherPlayer != this.player && (Objects.equals(this.impersonatedProfile, Impersonator.get((class_1657)otherPlayer).getImpersonatedProfile()) || Objects.equals(this.impersonatedProfile, otherPlayer.method_7334()));
    }

    @Override
    public boolean isImpersonating() {
        return this.impersonatedProfile != null;
    }

    @Override
    @Nullable
    public GameProfile getImpersonatedProfile() {
        return this.impersonatedProfile;
    }

    @Override
    @NotNull
    public GameProfile getActualProfile() {
        return ((PlayerEntityExtensions)this.player).impersonate_getActualGameProfile();
    }

    @Override
    @NotNull
    public GameProfile getEditedProfile() {
        return this.editedProfile == null ? this.getActualProfile() : this.editedProfile;
    }

    public void copyFrom(PlayerImpersonator other) {
        this.stopImpersonations();
        this.stackedImpersonations.putAll(other.stackedImpersonations);
        this.resetImpersonation();
    }

    public boolean shouldSyncWith(class_3222 player) {
        return player == this.player || player.field_13995.method_3760().method_14569(player.method_7334());
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        GameProfile profile = this.getImpersonatedProfile();
        UUID id = profile == null ? null : profile.getId();
        String name = profile == null ? null : profile.getName();
        buf.writeByte((id != null ? 1 : 0) | (name != null ? 2 : 0));
        if (id != null) {
            buf.method_10797(id);
        }
        if (name != null) {
            buf.method_10814(name);
        }
    }

    public void applySyncPacket(class_2540 buf) {
        byte flags = buf.readByte();
        UUID id = null;
        String name = null;
        if ((flags & 1) != 0) {
            id = buf.method_10790();
        }
        if ((flags & 2) != 0) {
            name = buf.method_19772();
        }
        this.setImpersonatedProfile((GameProfile)(id == null && name == null ? null : new GameProfile(id, name)));
    }

    public void readFromNbt(@NotNull class_2487 tag) {
        if (tag.method_10573("impersonations", 9)) {
            this.stopImpersonations();
            class_2499 impersonations = tag.method_10554("impersonations", 10);
            for (int i = 0; i < impersonations.size(); ++i) {
                class_2487 nbtEntry = impersonations.method_10602(i);
                class_2960 key = class_2960.method_12829((String)nbtEntry.method_10558("impersonation_key"));
                GameProfile profile = class_2512.method_10683((class_2487)nbtEntry);
                if (key == null || profile == null) continue;
                this.stackedImpersonations.put(key, profile);
            }
            this.resetImpersonation();
        }
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        if (this.isImpersonating()) {
            class_2499 profiles = new class_2499();
            for (Map.Entry<class_2960, GameProfile> entry : this.stackedImpersonations.entrySet()) {
                class_2487 nbtEntry = new class_2487();
                nbtEntry.method_10582("impersonation_key", entry.getKey().toString());
                profiles.add((Object)class_2512.method_10684((class_2487)nbtEntry, (GameProfile)entry.getValue()));
            }
            tag.method_10566("impersonations", (class_2520)profiles);
        }
    }
}

