/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.impersonate.impl;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.ladysnake.impersonate.Impersonator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2191;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class ImpersonateCommand {
    public static final class_2960 DEFAULT_IMPERSONATION_KEY = new class_2960("impersonate:command");

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"impersonate").requires(Permissions.require((String)"impersonate.command.disguise.self", (int)2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"disguise").requires(Permissions.require((String)"impersonate.command.disguise.self", (int)2))).then(class_2170.method_9247((String)"as").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"disguise", (ArgumentType)class_2191.method_9329()).executes(context -> ImpersonateCommand.startImpersonation((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)"disguise"), Collections.singleton(((class_2168)context.getSource()).method_9207()), DEFAULT_IMPERSONATION_KEY))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(Permissions.require((String)"impersonate.command.disguise", (int)2))).executes(context -> ImpersonateCommand.startImpersonation((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)"disguise"), class_2186.method_9312((CommandContext)context, (String)"targets"), DEFAULT_IMPERSONATION_KEY))).then(class_2170.method_9244((String)"key", (ArgumentType)class_2232.method_9441()).executes(context -> ImpersonateCommand.startImpersonation((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)"disguise"), class_2186.method_9312((CommandContext)context, (String)"targets"), class_2232.method_9443((CommandContext)context, (String)"key")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").executes(context -> ImpersonateCommand.stopImpersonation((class_2168)context.getSource(), Collections.singleton(((class_2168)context.getSource()).method_9207()), null))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(Permissions.require((String)"impersonate.command.disguise", (int)2))).executes(context -> ImpersonateCommand.stopImpersonation((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets"), null))).then(class_2170.method_9244((String)"key", (ArgumentType)class_2232.method_9441()).executes(context -> ImpersonateCommand.stopImpersonation((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets"), class_2232.method_9443((CommandContext)context, (String)"key"))))))));
    }

    private static int stopImpersonation(class_2168 source, Collection<class_3222> players, @Nullable class_2960 key) {
        int count = 0;
        for (class_3222 player : players) {
            GameProfile impersonated;
            Impersonator impersonator = Impersonator.get((class_1657)player);
            if (key == null) {
                impersonated = impersonator.getImpersonatedProfile();
                impersonator.stopImpersonations();
            } else {
                impersonated = impersonator.stopImpersonation(key);
            }
            if (impersonated == null) continue;
            ImpersonateCommand.sendImpersonationFeedback(source, player, impersonated, "clear");
            ++count;
        }
        return count;
    }

    private static void sendImpersonationFeedback(class_2168 source, class_3222 player, GameProfile impersonated, String message) {
        String name = impersonated.getName();
        if (source.method_9228() == player) {
            source.method_9226((class_2561)new class_2588("impersonate:commands.disguise." + message + ".success.self", new Object[]{name}), true);
        } else {
            source.method_9226((class_2561)new class_2588("impersonate:commands.disguise." + message + ".success.other", new Object[]{player.method_5476(), name}), true);
        }
    }

    private static int startImpersonation(class_2168 source, Collection<GameProfile> profiles, Collection<class_3222> players, class_2960 impersonationKey) throws CommandSyntaxException {
        assert (!profiles.isEmpty());
        Iterator<GameProfile> it = profiles.iterator();
        GameProfile disguise = it.next();
        if (it.hasNext()) {
            throw class_2186.field_9864.create();
        }
        int count = 0;
        ImpersonateCommand.stopImpersonation(source, players, impersonationKey);
        for (class_3222 player : players) {
            Impersonator.get((class_1657)player).impersonate(impersonationKey, disguise);
            ImpersonateCommand.sendImpersonationFeedback(source, player, disguise, "start");
            ++count;
        }
        return count;
    }
}

