/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import reborncore.api.IListInfoProvider;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.util.StringUtils;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;
import team.reborn.energy.api.base.SimpleSidedEnergyContainer;

public abstract class PowerAcceptorBlockEntity
extends MachineBaseBlockEntity
implements IListInfoProvider {
    private final SimpleSidedEnergyContainer energyContainer = new SimpleSidedEnergyContainer(){

        public long getCapacity() {
            return PowerAcceptorBlockEntity.this.getMaxStoredPower();
        }

        public long getMaxInsert(@Nullable class_2350 side) {
            return PowerAcceptorBlockEntity.this.getMaxInput(side);
        }

        public long getMaxExtract(@Nullable class_2350 side) {
            if (PowerAcceptorBlockEntity.this.canProvideEnergy(side)) {
                return PowerAcceptorBlockEntity.this.getMaxOutput(side);
            }
            return 0L;
        }
    };
    private RcEnergyTier blockEntityPowerTier;
    public long extraPowerStorage;
    public long extraPowerInput;
    public int extraTier;
    public long powerChange;
    public long powerLastTick;
    public boolean checkOverfill = true;

    public PowerAcceptorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.checkTier();
    }

    public EnergyStorage getSideEnergyStorage(@Nullable class_2350 side) {
        return this.energyContainer.getSideStorage(side);
    }

    public void checkTier() {
        this.blockEntityPowerTier = this.getMaxInput(null) == 0L ? RcEnergyTier.getTier(this.getBaseMaxOutput()) : RcEnergyTier.getTier(this.getBaseMaxInput());
    }

    public long getFreeSpace() {
        return this.getMaxStoredPower() - this.getStored();
    }

    public void addEnergy(long amount) {
        this.setStored(this.getEnergy() + amount);
    }

    public void addEnergyProbabilistic(double amount) {
        long integerPart = (long)Math.floor(amount);
        this.addEnergy(integerPart);
        double fractionalPart = amount - (double)integerPart;
        if (ThreadLocalRandom.current().nextDouble() <= fractionalPart) {
            this.addEnergy(1L);
        }
    }

    public void useEnergy(long amount) {
        if (this.getEnergy() > amount) {
            this.setStored(this.getEnergy() - amount);
        } else {
            this.setStored(0L);
        }
    }

    public void charge(int slot) {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        long chargeEnergy = Math.min(this.getFreeSpace(), this.getMaxInput(null));
        if (chargeEnergy <= 0L) {
            return;
        }
        if (this.getOptionalInventory().isEmpty()) {
            return;
        }
        class_1263 inventory = this.getOptionalInventory().get();
        EnergyStorageUtil.move((EnergyStorage)((EnergyStorage)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)inventory, null).getSlots().get(slot))).find(EnergyStorage.ITEM)), (EnergyStorage)this.getSideEnergyStorage(null), (long)Long.MAX_VALUE, null);
    }

    public void discharge(int slot) {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.getOptionalInventory().isEmpty()) {
            return;
        }
        class_1263 inventory = this.getOptionalInventory().get();
        EnergyStorageUtil.move((EnergyStorage)this.getSideEnergyStorage(null), (EnergyStorage)((EnergyStorage)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)inventory, null).getSlots().get(slot))).find(EnergyStorage.ITEM)), (long)Long.MAX_VALUE, null);
    }

    public static int calculateComparatorOutputFromEnergy(@Nullable class_2586 blockEntity) {
        if (blockEntity instanceof PowerAcceptorBlockEntity) {
            PowerAcceptorBlockEntity storage = (PowerAcceptorBlockEntity)blockEntity;
            return class_3532.method_15384((double)((double)storage.getStored() * 15.0 / (double)storage.getMaxStoredPower()));
        }
        return 0;
    }

    protected boolean shouldHandleEnergyNBT() {
        return true;
    }

    protected boolean canAcceptEnergy(@Nullable class_2350 side) {
        return true;
    }

    protected boolean canProvideEnergy(@Nullable class_2350 side) {
        return true;
    }

    public long getExtraPowerStorage() {
        return this.extraPowerStorage;
    }

    public void setExtraPowerStorage(long extraPowerStorage) {
        this.extraPowerStorage = extraPowerStorage;
    }

    public long getPowerChange() {
        return this.powerChange;
    }

    public void setPowerChange(long powerChange) {
        this.powerChange = powerChange;
    }

    public long getEnergy() {
        return this.getStored();
    }

    public void setEnergy(long energy) {
        this.setStored(energy);
    }

    public abstract long getBaseMaxPower();

    public abstract long getBaseMaxOutput();

    public abstract long getBaseMaxInput();

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity2) {
        super.tick(world, pos, state, blockEntity2);
        if (world == null || world.field_9236) {
            return;
        }
        if (this.getStored() <= 0L) {
            return;
        }
        if (!this.isActive(RedstoneConfiguration.POWER_IO)) {
            return;
        }
        for (class_2350 side : class_2350.values()) {
            EnergyStorageUtil.move((EnergyStorage)this.getSideEnergyStorage(side), (EnergyStorage)((EnergyStorage)EnergyStorage.SIDED.find(world, pos.method_10093(side), (Object)side.method_10153())), (long)Long.MAX_VALUE, null);
        }
        this.powerChange = this.getStored() - this.powerLastTick;
        this.powerLastTick = this.getStored();
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        class_2487 data = tag.method_10562("PowerAcceptor");
        if (this.shouldHandleEnergyNBT()) {
            this.energyContainer.amount = data.method_10537("energy");
        }
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2487 data = new class_2487();
        data.method_10544("energy", this.getStored());
        tag.method_10566("PowerAcceptor", (class_2520)data);
    }

    @Override
    public void resetUpgrades() {
        super.resetUpgrades();
        this.extraPowerStorage = 0L;
        this.extraTier = 0;
        this.extraPowerInput = 0L;
    }

    @Override
    protected void afterUpgradesApplication() {
        if (this.checkOverfill && this.getStored() > this.getMaxStoredPower()) {
            this.setStored(this.getStored());
        }
    }

    public long getStored() {
        return this.energyContainer.amount;
    }

    public void setStored(long amount) {
        this.energyContainer.amount = amount;
        if (this.checkOverfill) {
            this.energyContainer.amount = Math.max(Math.min(this.energyContainer.amount, this.getMaxStoredPower()), 0L);
        }
        this.method_5431();
    }

    public long getMaxStoredPower() {
        return this.getBaseMaxPower() + this.extraPowerStorage;
    }

    public long getMaxOutput(@Nullable class_2350 face) {
        if (!this.isActive(RedstoneConfiguration.POWER_IO)) {
            return 0L;
        }
        if (!this.canProvideEnergy(face)) {
            return 0L;
        }
        if (this.extraTier > 0) {
            return this.getTier().getMaxOutput();
        }
        return this.getBaseMaxOutput();
    }

    public long getMaxInput(@Nullable class_2350 face) {
        if (!this.isActive(RedstoneConfiguration.POWER_IO)) {
            return 0L;
        }
        if (!this.canAcceptEnergy(face)) {
            return 0L;
        }
        if (this.extraTier > 0) {
            return this.getTier().getMaxInput();
        }
        return this.getBaseMaxInput() + this.extraPowerInput;
    }

    public RcEnergyTier getTier() {
        if (this.blockEntityPowerTier == null) {
            this.checkTier();
        }
        if (this.extraTier > 0) {
            for (RcEnergyTier enumTier : RcEnergyTier.values()) {
                if (enumTier.ordinal() != this.blockEntityPowerTier.ordinal() + this.extraTier) continue;
                return enumTier;
            }
            return RcEnergyTier.INFINITE;
        }
        return this.blockEntityPowerTier;
    }

    public boolean tryUseExact(long energy) {
        if (this.getStored() >= energy) {
            this.addEnergy(-energy);
            return true;
        }
        return false;
    }

    @Override
    public void addInfo(List<class_2561> info, boolean isReal, boolean hasData) {
        if (!isReal && hasData) {
            info.add((class_2561)new class_2588("reborncore.tooltip.energy").method_27692(class_124.field_1080).method_27693(": ").method_27693(PowerSystem.getLocalizedPower(this.getStored())).method_27692(class_124.field_1065));
        }
        info.add((class_2561)new class_2588("reborncore.tooltip.energy.maxEnergy").method_27692(class_124.field_1080).method_27693(": ").method_27693(PowerSystem.getLocalizedPower(this.getMaxStoredPower())).method_27692(class_124.field_1065));
        if (this.getMaxInput(null) != 0L) {
            info.add((class_2561)new class_2588("reborncore.tooltip.energy.inputRate").method_27692(class_124.field_1080).method_27693(": ").method_27693(PowerSystem.getLocalizedPower(this.getMaxInput(null))).method_27692(class_124.field_1065));
        }
        if (this.getMaxOutput(null) > 0L) {
            info.add((class_2561)new class_2588("reborncore.tooltip.energy.outputRate").method_27692(class_124.field_1080).method_27693(": ").method_27693(PowerSystem.getLocalizedPower(this.getMaxOutput(null))).method_27692(class_124.field_1065));
        }
        info.add((class_2561)new class_2588("reborncore.tooltip.energy.tier").method_27692(class_124.field_1080).method_27693(": ").method_27693(StringUtils.toFirstCapitalAllLowercase(this.getTier().toString())).method_27692(class_124.field_1065));
        if (isReal) {
            info.add((class_2561)new class_2588("reborncore.tooltip.energy.change").method_27692(class_124.field_1080).method_27693(": ").method_27693(PowerSystem.getLocalizedPower(this.powerChange)).method_27693("/t").method_27692(class_124.field_1065));
        }
        super.addInfo(info, isReal, hasData);
    }
}

