/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_638;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reborncore.RebornCore;
import reborncore.client.ClientChunkManager;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.common.blockentity.FluidConfiguration;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.blockentity.SlotConfiguration;
import reborncore.common.chunkloading.ChunkLoaderManager;
import reborncore.common.network.ExtendedPacketBuffer;
import reborncore.common.network.NetworkManager;

@Environment(value=EnvType.CLIENT)
public class ClientBoundPacketHandlers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientBoundPacketHandlers.class);

    public static void init() {
        NetworkManager.registerClientBoundHandler(new class_2960("reborncore", "custom_description"), (client, handler, packetBuffer, responseSender) -> {
            class_2338 pos = packetBuffer.method_10811();
            class_2487 tagCompound = packetBuffer.method_10798();
            client.execute(() -> {
                class_2586 blockentity;
                class_638 world = class_310.method_1551().field_1687;
                if (world.method_22340(pos) && (blockentity = world.method_8321(pos)) != null && tagCompound != null) {
                    blockentity.method_11014(tagCompound);
                }
            });
        });
        NetworkManager.registerClientBoundHandler(new class_2960("reborncore", "fluid_config_sync"), (client, handler, packetBuffer, responseSender) -> {
            class_2338 pos = packetBuffer.method_10811();
            class_2487 compoundTag = packetBuffer.method_10798();
            client.execute(() -> {
                FluidConfiguration fluidConfiguration = new FluidConfiguration(compoundTag);
                if (!class_310.method_1551().field_1687.method_22340(pos)) {
                    return;
                }
                MachineBaseBlockEntity machineBase = (MachineBaseBlockEntity)class_310.method_1551().field_1687.method_8321(pos);
                if (machineBase == null || machineBase.fluidConfiguration == null || fluidConfiguration == null) {
                    RebornCore.LOGGER.error("Failed to sync fluid config data to " + pos);
                    return;
                }
                fluidConfiguration.getAllSides().forEach(fluidConfig -> machineBase.fluidConfiguration.updateFluidConfig((FluidConfiguration.FluidConfig)fluidConfig));
                machineBase.fluidConfiguration.setInput(fluidConfiguration.autoInput());
                machineBase.fluidConfiguration.setOutput(fluidConfiguration.autoOutput());
            });
        });
        NetworkManager.registerClientBoundHandler(new class_2960("reborncore", "slot_sync"), (client, handler, packetBuffer, responseSender) -> {
            class_2338 pos = packetBuffer.method_10811();
            class_2487 compoundTag = packetBuffer.method_10798();
            client.execute(() -> {
                SlotConfiguration slotConfig = new SlotConfiguration(compoundTag);
                if (!class_310.method_1551().field_1687.method_22340(pos)) {
                    return;
                }
                MachineBaseBlockEntity machineBase = (MachineBaseBlockEntity)class_310.method_1551().field_1687.method_8321(pos);
                if (machineBase == null || machineBase.getSlotConfiguration() == null || slotConfig == null || slotConfig.getSlotDetails() == null) {
                    RebornCore.LOGGER.error("Failed to sync slot data to " + pos);
                    return;
                }
                class_310.method_1551().execute(() -> slotConfig.getSlotDetails().forEach(slotConfigHolder -> machineBase.getSlotConfiguration().updateSlotDetails((SlotConfiguration.SlotConfigHolder)slotConfigHolder)));
            });
        });
        NetworkManager.registerClientBoundHandler(new class_2960("reborncore", "send_object"), (client, handler, packetBuffer, responseSender) -> {
            int size = packetBuffer.readInt();
            ExtendedPacketBuffer epb = new ExtendedPacketBuffer((ByteBuf)packetBuffer);
            Int2ObjectOpenHashMap updatedValues = new Int2ObjectOpenHashMap();
            for (int i = 0; i < size; ++i) {
                int id = packetBuffer.readInt();
                Object value = epb.readObject();
                updatedValues.put(id, value);
            }
            String name = packetBuffer.method_10800(packetBuffer.readInt());
            client.execute(() -> ClientBoundPacketHandlers.lambda$init$9(name, (Int2ObjectMap)updatedValues));
        });
        NetworkManager.registerClientBoundHandler(new class_2960("reborncore", "sync_chunks"), ChunkLoaderManager.CODEC, ClientChunkManager::setLoadedChunks);
    }

    private static /* synthetic */ void lambda$init$9(String name, Int2ObjectMap updatedValues) {
        class_465 handledScreen;
        class_1703 screenHandler;
        class_437 gui = class_310.method_1551().field_1755;
        if (gui instanceof class_465 && (screenHandler = (handledScreen = (class_465)gui).method_17577()) instanceof BuiltScreenHandler) {
            BuiltScreenHandler builtScreenHandler = (BuiltScreenHandler)screenHandler;
            String shName = screenHandler.getClass().getName();
            if (!shName.equals(name)) {
                LOGGER.warn("Received packet for {} but screen handler {} is open!", (Object)name, (Object)shName);
                return;
            }
            builtScreenHandler.handleUpdateValues((Int2ObjectMap<Object>)updatedValues);
        }
    }
}

