/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting.serde;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import reborncore.common.crafting.RebornFluidRecipe;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.crafting.serde.RebornRecipeSerde;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;

public abstract class RebornFluidRecipeSerde<R extends RebornFluidRecipe>
extends RebornRecipeSerde<R> {
    protected abstract R fromJson(JsonObject var1, RebornRecipeType<R> var2, class_2960 var3, List<RebornIngredient> var4, List<class_1799> var5, int var6, int var7, @NotNull FluidInstance var8);

    @Override
    protected final R fromJson(JsonObject jsonObject, RebornRecipeType<R> type, class_2960 name, List<RebornIngredient> ingredients, List<class_1799> outputs, int power, int time) {
        JsonObject tank = class_3518.method_15296((JsonObject)jsonObject, (String)"tank");
        class_2960 identifier = new class_2960(class_3518.method_15265((JsonObject)tank, (String)"fluid"));
        class_3611 fluid = (class_3611)class_2378.field_11154.method_10223(identifier);
        FluidValue value = FluidValue.BUCKET;
        if (tank.has("amount")) {
            value = FluidValue.parseFluidValue(tank.get("amount"));
        }
        FluidInstance fluidInstance = new FluidInstance(fluid, value);
        return this.fromJson(jsonObject, type, name, ingredients, outputs, power, time, fluidInstance);
    }

    @Override
    public void collectJsonData(R recipe, JsonObject jsonObject, boolean networkSync) {
        JsonObject tankObject = new JsonObject();
        tankObject.addProperty("fluid", class_2378.field_11154.method_10221((Object)((RebornFluidRecipe)recipe).getFluidInstance().getFluid()).toString());
        JsonObject amountObject = new JsonObject();
        amountObject.addProperty("droplets", (Number)((RebornFluidRecipe)recipe).getFluidInstance().getAmount().getRawValue());
        tankObject.add("amount", (JsonElement)amountObject);
        jsonObject.add("tank", (JsonElement)tankObject);
    }

    public static <R extends RebornFluidRecipe> RebornFluidRecipeSerde<R> create(final SimpleFluidRecipeFactory<R> factory) {
        return new RebornFluidRecipeSerde<R>(){

            @Override
            protected R fromJson(JsonObject jsonObject, RebornRecipeType<R> type, class_2960 name, List<RebornIngredient> ingredients, List<class_1799> outputs, int power, int time, @NotNull FluidInstance fluidInstance) {
                return factory.create(type, name, ingredients, outputs, power, time, fluidInstance);
            }
        };
    }

    public static interface SimpleFluidRecipeFactory<R extends RebornFluidRecipe> {
        public R create(RebornRecipeType<R> var1, class_2960 var2, List<RebornIngredient> var3, List<class_1799> var4, int var5, int var6, @NotNull FluidInstance var7);
    }
}

