/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting.serde;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2509;
import net.minecraft.class_3518;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RecipeUtils;
import reborncore.common.crafting.ingredient.IngredientFactory;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.crafting.serde.RecipeSerde;
import reborncore.common.util.DefaultedListCollector;
import reborncore.common.util.serialization.SerializationUtil;

public abstract class AbstractRecipeSerde<R extends RebornRecipe>
implements RecipeSerde<R> {
    protected int getPower(JsonObject jsonObject) {
        return class_3518.method_15260((JsonObject)jsonObject, (String)"power");
    }

    protected int getTime(JsonObject jsonObject) {
        return class_3518.method_15260((JsonObject)jsonObject, (String)"time");
    }

    protected List<RebornIngredient> getIngredients(JsonObject jsonObject) {
        return (List)SerializationUtil.stream(class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients")).map(IngredientFactory::deserialize).collect(DefaultedListCollector.toList());
    }

    protected List<class_1799> getOutputs(JsonObject jsonObject) {
        JsonArray resultsJson = class_3518.method_15261((JsonObject)jsonObject, (String)"results");
        return RecipeUtils.deserializeItems((JsonElement)resultsJson);
    }

    protected void writeIngredients(R recipe, JsonObject jsonObject, boolean networkSync) {
        JsonArray ingredientsArray = new JsonArray();
        ((RebornRecipe)recipe).getRebornIngredients().stream().map(ingredient -> ingredient.toJson(networkSync)).forEach(arg_0 -> ((JsonArray)ingredientsArray).add(arg_0));
        jsonObject.add("ingredients", (JsonElement)ingredientsArray);
    }

    protected void writeOutputs(R recipe, JsonObject jsonObject) {
        JsonArray resultsArray = new JsonArray();
        for (class_1799 stack : ((RebornRecipe)recipe).getOutputs()) {
            JsonObject stackObject = new JsonObject();
            stackObject.addProperty("item", class_2378.field_11142.method_10221((Object)stack.method_7909()).toString());
            if (stack.method_7947() > 1) {
                stackObject.addProperty("count", (Number)stack.method_7947());
            }
            if (stack.method_7985()) {
                stackObject.add("nbt", (JsonElement)Dynamic.convert((DynamicOps)class_2509.field_11560, (DynamicOps)JsonOps.INSTANCE, (Object)stack.method_7969()));
            }
            resultsArray.add((JsonElement)stackObject);
        }
        jsonObject.add("results", (JsonElement)resultsArray);
    }

    protected void writePower(R recipe, JsonObject jsonObject) {
        jsonObject.addProperty("power", (Number)((RebornRecipe)recipe).getPower());
    }

    protected void writeTime(R recipe, JsonObject jsonObject) {
        jsonObject.addProperty("time", (Number)((RebornRecipe)recipe).getTime());
    }
}

