/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.crafting.serde.RebornRecipeSerde;
import reborncore.common.crafting.serde.RecipeSerde;

public class RecipeManager {
    private static final Map<class_2960, RebornRecipeType<?>> recipeTypes = new HashMap();

    public static RebornRecipeType<RebornRecipe> newRecipeType(class_2960 name) {
        return RecipeManager.newRecipeType(RebornRecipeSerde.BASIC, name);
    }

    public static <R extends RebornRecipe> RebornRecipeType<R> newRecipeType(RecipeSerde<R> recipeSerde, class_2960 name) {
        if (recipeTypes.containsKey(name)) {
            throw new RuntimeException("RebornRecipe type with this name already registered");
        }
        RebornRecipeType<R> type = new RebornRecipeType<R>(recipeSerde, name);
        recipeTypes.put(name, type);
        class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)name, type);
        return type;
    }

    public static RebornRecipeType<?> getRecipeType(class_2960 name) {
        if (!recipeTypes.containsKey(name)) {
            throw new RuntimeException("RebornRecipe type " + name + " not found");
        }
        return recipeTypes.get(name);
    }

    public static List<RebornRecipeType<?>> getRecipeTypes(String namespace) {
        return recipeTypes.values().stream().filter(rebornRecipeType -> rebornRecipeType.name().method_12836().equals(namespace)).collect(Collectors.toList());
    }
}

