/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.screen.builder;

import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1738;
import net.minecraft.class_2960;
import org.apache.commons.lang3.Range;
import reborncore.client.IconSupplier;
import reborncore.client.screen.builder.ScreenHandlerBuilder;
import reborncore.client.screen.builder.slot.PlayerInventorySlot;
import reborncore.client.screen.builder.slot.SpriteSlot;

public final class PlayerScreenHandlerBuilder {
    private final class_1661 player;
    private final ScreenHandlerBuilder parent;
    private Range<Integer> main;
    private Range<Integer> hotbar;
    private Range<Integer> armor;

    PlayerScreenHandlerBuilder(ScreenHandlerBuilder parent, class_1661 player) {
        this.player = player;
        this.parent = parent;
    }

    public PlayerScreenHandlerBuilder inventory(int xStart, int yStart) {
        int startIndex = this.parent.slots.size();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.parent.slots.add(new PlayerInventorySlot((class_1263)this.player, j + i * 9 + 9, xStart + j * 18, yStart + i * 18));
            }
        }
        this.main = Range.between((Comparable)Integer.valueOf(startIndex), (Comparable)Integer.valueOf(this.parent.slots.size() - 1));
        return this;
    }

    public PlayerScreenHandlerBuilder hotbar(int xStart, int yStart) {
        int startIndex = this.parent.slots.size();
        for (int i = 0; i < 9; ++i) {
            this.parent.slots.add(new PlayerInventorySlot((class_1263)this.player, i, xStart + i * 18, yStart));
        }
        this.hotbar = Range.between((Comparable)Integer.valueOf(startIndex), (Comparable)Integer.valueOf(this.parent.slots.size() - 1));
        return this;
    }

    public PlayerScreenHandlerBuilder inventory() {
        return this.inventory(8, 94);
    }

    public PlayerScreenHandlerBuilder hotbar() {
        return this.hotbar(8, 152);
    }

    public PlayerArmorScreenHandlerBuilder armor() {
        return new PlayerArmorScreenHandlerBuilder(this);
    }

    public ScreenHandlerBuilder addInventory() {
        if (this.hotbar != null) {
            this.parent.addPlayerInventoryRange(this.hotbar);
        }
        if (this.main != null) {
            this.parent.addPlayerInventoryRange(this.main);
        }
        if (this.armor != null) {
            this.parent.addBlockEntityInventoryRange(this.armor);
        }
        return this.parent;
    }

    public static final class PlayerArmorScreenHandlerBuilder {
        private final PlayerScreenHandlerBuilder parent;
        private final int startIndex;

        public PlayerArmorScreenHandlerBuilder(PlayerScreenHandlerBuilder parent) {
            this.parent = parent;
            this.startIndex = parent.parent.slots.size();
        }

        private PlayerArmorScreenHandlerBuilder armor(int index, int xStart, int yStart, class_1304 slotType, class_2960 sprite) {
            this.parent.parent.slots.add(new SpriteSlot((class_1263)this.parent.player, index, xStart, yStart, sprite, 1).setFilter(stack -> {
                if (stack.method_7909() instanceof class_1738) {
                    return ((class_1738)stack.method_7909()).method_7685() == slotType;
                }
                return false;
            }));
            return this;
        }

        public PlayerArmorScreenHandlerBuilder helmet(int xStart, int yStart) {
            return this.armor(this.parent.player.method_5439() - 2, xStart, yStart, class_1304.field_6169, IconSupplier.armour_head_id);
        }

        public PlayerArmorScreenHandlerBuilder chestplate(int xStart, int yStart) {
            return this.armor(this.parent.player.method_5439() - 3, xStart, yStart, class_1304.field_6174, IconSupplier.armour_chest_id);
        }

        public PlayerArmorScreenHandlerBuilder leggings(int xStart, int yStart) {
            return this.armor(this.parent.player.method_5439() - 4, xStart, yStart, class_1304.field_6172, IconSupplier.armour_legs_id);
        }

        public PlayerArmorScreenHandlerBuilder boots(int xStart, int yStart) {
            return this.armor(this.parent.player.method_5439() - 5, xStart, yStart, class_1304.field_6166, IconSupplier.armour_feet_id);
        }

        public PlayerArmorScreenHandlerBuilder complete(int xStart, int yStart) {
            return this.helmet(xStart, yStart).chestplate(xStart, yStart + 18).leggings(xStart, yStart + 18 + 18).boots(xStart, yStart + 18 + 18 + 18);
        }

        public PlayerScreenHandlerBuilder addArmor() {
            this.parent.armor = Range.between((Comparable)Integer.valueOf(this.startIndex - 1), (Comparable)Integer.valueOf(this.parent.parent.slots.size() - 2));
            return this.parent;
        }
    }
}

