/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.registry;

import java.util.List;
import java.util.function.Predicate;
import moriyashiine.bewitchment.common.Bewitchment;
import moriyashiine.bewitchment.common.entity.living.GhostEntity;
import moriyashiine.bewitchment.common.entity.living.HellhoundEntity;
import moriyashiine.bewitchment.common.entity.living.VampireEntity;
import moriyashiine.bewitchment.common.entity.living.WerewolfEntity;
import moriyashiine.bewitchment.common.registry.BWEntityTypes;
import moriyashiine.bewitchment.common.registry.BWObjects;
import moriyashiine.bewitchment.common.registry.BWProperties;
import moriyashiine.bewitchment.mixin.OrePlacedFeaturesAccessor;
import moriyashiine.bewitchment.mixin.SimpleBlockStateProviderAccessor;
import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.fabricmc.fabric.mixin.object.builder.SpawnRestrictionAccessor;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1429;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_3825;
import net.minecraft.class_39;
import net.minecraft.class_4643;
import net.minecraft.class_4645;
import net.minecraft.class_4647;
import net.minecraft.class_4651;
import net.minecraft.class_5139;
import net.minecraft.class_5140;
import net.minecraft.class_5141;
import net.minecraft.class_5201;
import net.minecraft.class_5204;
import net.minecraft.class_5207;
import net.minecraft.class_5210;
import net.minecraft.class_5458;
import net.minecraft.class_55;
import net.minecraft.class_5843;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6793;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6799;
import net.minecraft.class_6806;
import net.minecraft.class_6819;
import net.minecraft.class_79;
import net.minecraft.class_83;

public class BWWorldGenerators {
    private static final class_5201 EMPTY_SIZE = new class_5204(0, 0, 0);
    public static final class_2975<class_4643, ?> JUNIPER_TREE = class_3031.field_24134.method_23397((class_3037)new class_4643.class_4644((class_4651)SimpleBlockStateProviderAccessor.callInit(BWObjects.JUNIPER_LOG.method_9564()), (class_5141)new class_5139(5, 0, 0), (class_4651)SimpleBlockStateProviderAccessor.callInit(BWObjects.JUNIPER_LEAVES.method_9564()), (class_4647)new class_4645((class_6017)class_6016.method_34998((int)2), (class_6017)class_6016.method_34998((int)0)), EMPTY_SIZE).method_27374().method_23445());
    public static final class_6796 JUNIPER_TREE_WITH_CHANCE = JUNIPER_TREE.method_39593(class_6819.method_39741((class_6797)class_6799.method_39659((int)10), (class_2248)BWObjects.JUNIPER_SAPLING));
    public static final class_2975<class_4643, ?> CYPRESS_TREE = class_3031.field_24134.method_23397((class_3037)new class_4643.class_4644((class_4651)SimpleBlockStateProviderAccessor.callInit(BWObjects.CYPRESS_LOG.method_9564()), (class_5141)new class_5140(6, 1, 1), (class_4651)SimpleBlockStateProviderAccessor.callInit(BWObjects.CYPRESS_LEAVES.method_9564()), (class_4647)new class_5207((class_6017)class_6016.method_34998((int)2), (class_6017)class_6016.method_34998((int)0), 4), EMPTY_SIZE).method_27374().method_23445());
    public static final class_6796 CYPRESS_TREE_WITH_CHANCE = CYPRESS_TREE.method_39593(class_6819.method_39741((class_6797)class_6799.method_39659((int)10), (class_2248)BWObjects.CYPRESS_SAPLING));
    public static final class_2975<class_4643, ?> ELDER_TREE = class_3031.field_24134.method_23397((class_3037)new class_4643.class_4644((class_4651)SimpleBlockStateProviderAccessor.callInit(BWObjects.ELDER_LOG.method_9564()), (class_5141)new class_5140(4, 0, 1), (class_4651)SimpleBlockStateProviderAccessor.callInit(BWObjects.ELDER_LEAVES.method_9564()), (class_4647)new class_5207((class_6017)class_6016.method_34998((int)2), (class_6017)class_6016.method_34998((int)0), 4), EMPTY_SIZE).method_27374().method_23445());
    public static final class_6796 ELDER_TREE_WITH_CHANCE = ELDER_TREE.method_39593(class_6819.method_39741((class_6797)class_6799.method_39659((int)10), (class_2248)BWObjects.ELDER_SAPLING));
    public static final class_2975<class_4643, ?> DRAGONS_BLOOD_TREE = class_3031.field_24134.method_23397((class_3037)new class_4643.class_4644((class_4651)SimpleBlockStateProviderAccessor.callInit((class_2680)BWObjects.DRAGONS_BLOOD_LOG.method_9564().method_11657((class_2769)BWProperties.NATURAL, (Comparable)Boolean.valueOf(true))), (class_5141)new class_5140(5, 1, 1), (class_4651)SimpleBlockStateProviderAccessor.callInit(BWObjects.DRAGONS_BLOOD_LEAVES.method_9564()), (class_4647)new class_5210((class_6017)class_6016.method_34998((int)1), (class_6017)class_6016.method_34998((int)0), (class_6017)class_6016.method_34998((int)3)), EMPTY_SIZE).method_27374().method_23445());
    public static final List<class_3124.class_5876> SILVER_ORES = List.of(class_3124.method_33994((class_3825)class_6806.field_35858, (class_2680)BWObjects.SILVER_ORE.method_9564()), class_3124.method_33994((class_3825)class_6806.field_35859, (class_2680)BWObjects.DEEPSLATE_SILVER_ORE.method_9564()));
    public static final List<class_3124.class_5876> SALT_ORES = List.of(class_3124.method_33994((class_3825)class_6806.field_35858, (class_2680)BWObjects.SALT_ORE.method_9564()), class_3124.method_33994((class_3825)class_6806.field_35859, (class_2680)BWObjects.DEEPSLATE_SALT_ORE.method_9564()));
    public static final class_2975<?, ?> SILVER_ORE = class_3031.field_13517.method_23397((class_3037)new class_3124(SILVER_ORES, 10));
    public static final class_2975<?, ?> SILVER_ORE_BURIED = class_3031.field_13517.method_23397((class_3037)new class_3124(SILVER_ORES, 10, 0.5f));
    public static final class_2975<?, ?> SALT_ORE = class_3031.field_13517.method_23397((class_3037)new class_3124(SALT_ORES, 15));
    public static final class_2975<?, ?> SALT_ORE_BURIED = class_3031.field_13517.method_23397((class_3037)new class_3124(SALT_ORES, 15, 0.5f));
    public static final class_6796 SILVER_ORE_UPPER = SILVER_ORE_BURIED.method_39593(OrePlacedFeaturesAccessor.callModifiersWithCount(4, (class_6797)class_6795.method_39637((class_5843)class_5843.method_33841((int)-64), (class_5843)class_5843.method_33841((int)32))));
    public static final class_6796 SILVER_ORE_LOWER = SILVER_ORE_BURIED.method_39593(OrePlacedFeaturesAccessor.callModifiers((class_6797)class_6793.method_39624((class_6017)class_6019.method_35017((int)0, (int)1)), (class_6797)class_6795.method_39634((class_5843)class_5843.method_33841((int)-64), (class_5843)class_5843.method_33841((int)-48))));
    public static final class_6796 SALT_ORE_UPPER = SALT_ORE.method_39593(OrePlacedFeaturesAccessor.callModifiersWithCount(30, (class_6797)class_6795.method_39634((class_5843)class_5843.method_33841((int)136), (class_5843)class_5843.method_33845())));
    public static final class_6796 SALT_ORE_LOWER = SALT_ORE_BURIED.method_39593(OrePlacedFeaturesAccessor.callModifiersWithCount(20, (class_6797)class_6795.method_39637((class_5843)class_5843.method_33841((int)0), (class_5843)class_5843.method_33841((int)192))));

    public static void init() {
        class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)new class_2960("bewitchment", "juniper_tree"), JUNIPER_TREE);
        class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)new class_2960("bewitchment", "juniper_tree"), (Object)JUNIPER_TREE_WITH_CHANCE);
        class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)new class_2960("bewitchment", "cypress_tree"), CYPRESS_TREE);
        class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)new class_2960("bewitchment", "cypress_tree"), (Object)CYPRESS_TREE_WITH_CHANCE);
        class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)new class_2960("bewitchment", "elder_tree"), ELDER_TREE);
        class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)new class_2960("bewitchment", "elder_tree"), (Object)ELDER_TREE_WITH_CHANCE);
        class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)new class_2960("bewitchment", "silver_ore"), SILVER_ORE);
        class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)new class_2960("bewitchment", "silver_ore_buried"), SILVER_ORE_BURIED);
        class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)new class_2960("bewitchment", "salt_ore"), SALT_ORE);
        class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)new class_2960("bewitchment", "salt_ore_buried"), SALT_ORE_BURIED);
        class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)new class_2960("bewitchment", "silver_ore_upper"), (Object)SILVER_ORE_UPPER);
        class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)new class_2960("bewitchment", "silver_ore_lower"), (Object)SILVER_ORE_LOWER);
        class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)new class_2960("bewitchment", "salt_ore_upper"), (Object)SALT_ORE_UPPER);
        class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)new class_2960("bewitchment", "salt_ore_lower"), (Object)SALT_ORE_LOWER);
        BiomeModification worldGen = BiomeModifications.create((class_2960)new class_2960("bewitchment", "world_features"));
        worldGen.add(ModificationPhase.ADDITIONS, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9356}), context -> context.getGenerationSettings().addBuiltInFeature(class_2893.class_2895.field_13178, JUNIPER_TREE_WITH_CHANCE));
        worldGen.add(ModificationPhase.ADDITIONS, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9361, class_1959.class_1961.field_9364}), context -> context.getGenerationSettings().addBuiltInFeature(class_2893.class_2895.field_13178, CYPRESS_TREE_WITH_CHANCE));
        worldGen.add(ModificationPhase.ADDITIONS, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9370}), context -> context.getGenerationSettings().addBuiltInFeature(class_2893.class_2895.field_13178, ELDER_TREE_WITH_CHANCE));
        worldGen.add(ModificationPhase.ADDITIONS, BWWorldGenerators.foundInOverworld(), context -> {
            if (Bewitchment.config.generateSilver) {
                context.getGenerationSettings().addBuiltInFeature(class_2893.class_2895.field_13176, SILVER_ORE_UPPER);
                context.getGenerationSettings().addBuiltInFeature(class_2893.class_2895.field_13176, SILVER_ORE_LOWER);
            }
            if (Bewitchment.config.generateSalt) {
                context.getGenerationSettings().addBuiltInFeature(class_2893.class_2895.field_13176, SALT_ORE_UPPER);
                context.getGenerationSettings().addBuiltInFeature(class_2893.class_2895.field_13176, SALT_ORE_LOWER);
            }
        });
        if (BWWorldGenerators.registerEntitySpawn(BWEntityTypes.OWL, BWWorldGenerators.foundInOverworld().and(context -> Bewitchment.config.owlBiomeCategories.contains(context.getBiome().method_8688().method_8749())), Bewitchment.config.owlWeight, Bewitchment.config.owlMinGroupCount, Bewitchment.config.owlMaxGroupCount)) {
            SpawnRestrictionAccessor.callRegister(BWEntityTypes.OWL, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1429::method_20663);
        }
        if (BWWorldGenerators.registerEntitySpawn(BWEntityTypes.RAVEN, BWWorldGenerators.foundInOverworld().and(context -> Bewitchment.config.ravenBiomeCategories.contains(context.getBiome().method_8688().method_8749())), Bewitchment.config.ravenWeight, Bewitchment.config.ravenMinGroupCount, Bewitchment.config.ravenMaxGroupCount)) {
            SpawnRestrictionAccessor.callRegister(BWEntityTypes.RAVEN, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1429::method_20663);
        }
        if (BWWorldGenerators.registerEntitySpawn(BWEntityTypes.SNAKE, BWWorldGenerators.foundInOverworld().and(context -> Bewitchment.config.snakeBiomeCategories.contains(context.getBiome().method_8688().method_8749())), Bewitchment.config.snakeWeight, Bewitchment.config.snakeMinGroupCount, Bewitchment.config.snakeMaxGroupCount)) {
            SpawnRestrictionAccessor.callRegister(BWEntityTypes.SNAKE, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1429::method_20663);
        }
        if (BWWorldGenerators.registerEntitySpawn(BWEntityTypes.TOAD, BWWorldGenerators.foundInOverworld().and(context -> Bewitchment.config.toadBiomeCategories.contains(context.getBiome().method_8688().method_8749())), Bewitchment.config.toadWeight, Bewitchment.config.toadMinGroupCount, Bewitchment.config.toadMaxGroupCount)) {
            SpawnRestrictionAccessor.callRegister(BWEntityTypes.TOAD, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1429::method_20663);
        }
        if (BWWorldGenerators.registerEntitySpawn(BWEntityTypes.GHOST, BWWorldGenerators.foundInOverworld().and(context -> !context.getBiome().method_30966().method_31004(BWEntityTypes.GHOST.method_5891()).method_34993()), Bewitchment.config.ghostWeight, Bewitchment.config.ghostMinGroupCount, Bewitchment.config.ghostMaxGroupCount)) {
            SpawnRestrictionAccessor.callRegister(BWEntityTypes.GHOST, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, GhostEntity::canSpawn);
        }
        if (BWWorldGenerators.registerEntitySpawn(BWEntityTypes.VAMPIRE, BWWorldGenerators.foundInOverworld().and(context -> !context.getBiome().method_30966().method_31004(BWEntityTypes.VAMPIRE.method_5891()).method_34993()).and(context -> context.getBiome().method_8688() == class_1959.class_1961.field_9361 || context.getBiome().method_8688() == class_1959.class_1961.field_9355), Bewitchment.config.vampireWeight, Bewitchment.config.vampireMinGroupCount, Bewitchment.config.vampireMaxGroupCount)) {
            SpawnRestrictionAccessor.callRegister(BWEntityTypes.VAMPIRE, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, VampireEntity::canSpawn);
        }
        if (BWWorldGenerators.registerEntitySpawn(BWEntityTypes.WEREWOLF, BWWorldGenerators.foundInOverworld().and(context -> !context.getBiome().method_30966().method_31004(BWEntityTypes.WEREWOLF.method_5891()).method_34993()).and(context -> context.getBiome().method_8688() == class_1959.class_1961.field_9361 || context.getBiome().method_8688() == class_1959.class_1961.field_9370), Bewitchment.config.werewolfWeight, Bewitchment.config.werewolfMinGroupCount, Bewitchment.config.werewolfMaxGroupCount)) {
            SpawnRestrictionAccessor.callRegister(BWEntityTypes.WEREWOLF, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, WerewolfEntity::canSpawn);
        }
        if (BWWorldGenerators.registerEntitySpawn(BWEntityTypes.HELLHOUND, BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9366}), Bewitchment.config.hellhoundWeight, Bewitchment.config.hellhoundMinGroupCount, Bewitchment.config.hellhoundMaxGroupCount)) {
            SpawnRestrictionAccessor.callRegister(BWEntityTypes.HELLHOUND, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, HellhoundEntity::canSpawn);
        }
        LootTableLoadingCallback.EVENT.register((resourceManager, lootManager, identifier, fabricLootSupplierBuilder, lootTableSetter) -> {
            class_2960 seeds = new class_2960("bewitchment", "inject/seeds");
            class_2960 nether_fortress = new class_2960("bewitchment", "inject/nether_fortress");
            if (class_2246.field_10479.method_26162().equals((Object)identifier) || class_2246.field_10214.method_26162().equals((Object)identifier) || class_2246.field_10112.method_26162().equals((Object)identifier) || class_2246.field_10313.method_26162().equals((Object)identifier)) {
                fabricLootSupplierBuilder.withPool(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)seeds).method_437(1)).method_355());
            }
            if (class_39.field_615.equals((Object)identifier)) {
                fabricLootSupplierBuilder.withPool(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)nether_fortress).method_437(1)).method_355());
            }
        });
    }

    private static boolean registerEntitySpawn(class_1299<?> type, Predicate<BiomeSelectionContext> predicate, int weight, int minGroupSize, int maxGroupSize) {
        if (weight < 0) {
            throw new UnsupportedOperationException("Could not register entity type " + type.method_5882() + ": weight " + weight + " cannot be negative.");
        }
        if (minGroupSize < 0) {
            throw new UnsupportedOperationException("Could not register entity type " + type.method_5882() + ": minGroupSize " + minGroupSize + " cannot be negative.");
        }
        if (maxGroupSize < 0) {
            throw new UnsupportedOperationException("Could not register entity type " + type.method_5882() + ": maxGroupSize " + maxGroupSize + " cannot be negative.");
        }
        if (minGroupSize > maxGroupSize) {
            throw new UnsupportedOperationException("Could not register entity type " + type.method_5882() + ": minGroupSize " + minGroupSize + " cannot be greater than maxGroupSize " + maxGroupSize + ".");
        }
        if (weight == 0 || minGroupSize == 0) {
            return false;
        }
        BiomeModifications.addSpawn(predicate, (class_1311)type.method_5891(), type, (int)weight, (int)minGroupSize, (int)maxGroupSize);
        return true;
    }

    private static Predicate<BiomeSelectionContext> foundInOverworld() {
        return context -> {
            class_1959.class_1961 category = context.getBiome().method_8688();
            return category != class_1959.class_1961.field_9371 && category != class_1959.class_1961.field_9366 && category != class_1959.class_1961.field_9360;
        };
    }
}

