/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.registry;

import moriyashiine.bewitchment.api.BewitchmentAPI;
import moriyashiine.bewitchment.api.component.BloodComponent;
import moriyashiine.bewitchment.common.registry.BWComponents;
import moriyashiine.bewitchment.common.registry.BWTags;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class BWDamageSources {
    public static final class_1282 MAGIC_COPY = new ArmorPiercingDamageSource("magic");
    public static final class_1282 WEDNESDAY = new UnblockableDamageSource("wednesday");
    public static final class_1282 DEATH = new UnblockableDamageSource("death");
    public static final class_1282 VAMPIRE = new EmptyDamageSource("vampire");
    public static final class_1282 SUN = new SunDamageSource("sun");

    public static float handleDamage(class_1309 entity, class_1282 source, float amount) {
        if (BewitchmentAPI.isWeakToSilver(entity) && BewitchmentAPI.isSourceFromSilver(source)) {
            amount += 4.0f;
        } else if (BewitchmentAPI.isWerewolf((class_1297)entity, false) && !BWDamageSources.isEffective(source, false)) {
            amount *= 0.6666667f;
        } else if (BewitchmentAPI.isVampire((class_1297)entity, true)) {
            amount = BWDamageSources.handleVampireDamage(entity, source, amount);
        }
        return amount;
    }

    public static boolean isEffective(class_1282 source, boolean vampire) {
        if (source.method_5538() || vampire && (source == MAGIC_COPY || source == SUN)) {
            return true;
        }
        class_1297 attacker = source.method_5526();
        if (attacker != null) {
            if (BWTags.TAGLOCK_BLACKLIST.method_15141((Object)attacker.method_5864()) || BewitchmentAPI.isVampire(attacker, true) || BewitchmentAPI.isWerewolf(attacker, true)) {
                return true;
            }
            if (attacker instanceof class_1309 && class_1890.method_8203((class_1887)class_1893.field_9123, (class_1309)((class_1309)attacker)) > 0) {
                return true;
            }
        }
        return BewitchmentAPI.isSourceFromSilver(source);
    }

    private static float handleVampireDamage(class_1309 entity, class_1282 source, float amount) {
        if (!BWDamageSources.isEffective(source, true) && entity.method_6032() - amount < 1.0f) {
            BloodComponent bloodComponent = (BloodComponent)BWComponents.BLOOD_COMPONENT.get((Object)entity);
            while (entity.method_6032() - amount <= 0.0f && bloodComponent.getBlood() > 0) {
                amount -= 1.0f;
                bloodComponent.drainBlood(1, false);
            }
        }
        return amount;
    }

    private static class ArmorPiercingDamageSource
    extends class_1282 {
        protected ArmorPiercingDamageSource(String name) {
            super(name);
            this.method_5508();
            this.method_5509();
        }
    }

    private static class UnblockableDamageSource
    extends class_1282 {
        protected UnblockableDamageSource(String name) {
            super(name);
            this.method_5508();
            this.method_5509();
            this.method_5505();
        }
    }

    private static class EmptyDamageSource
    extends class_1282 {
        public EmptyDamageSource(String name) {
            super(name);
        }
    }

    public static class SunDamageSource
    extends ArmorPiercingDamageSource {
        public SunDamageSource(String name) {
            super(name);
        }

        public class_2561 method_5506(class_1309 entity) {
            return class_1282.field_5854.method_5506(entity);
        }
    }

    public static class MagicPlayer
    extends class_1285 {
        public MagicPlayer(@Nullable class_1297 source) {
            super("player", source);
            this.method_5515();
            this.method_5508();
        }
    }

    public static class MagicMob
    extends class_1285 {
        public MagicMob(@Nullable class_1297 source) {
            super("mob", source);
            this.method_5515();
            this.method_5508();
        }
    }
}

