/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.registry;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import moriyashiine.bewitchment.api.component.ContractsComponent;
import moriyashiine.bewitchment.api.component.CursesComponent;
import moriyashiine.bewitchment.api.component.FortuneComponent;
import moriyashiine.bewitchment.api.component.TransformationComponent;
import moriyashiine.bewitchment.api.registry.Contract;
import moriyashiine.bewitchment.api.registry.Curse;
import moriyashiine.bewitchment.api.registry.Fortune;
import moriyashiine.bewitchment.api.registry.Transformation;
import moriyashiine.bewitchment.common.network.packet.TransformationAbilityPacket;
import moriyashiine.bewitchment.common.registry.BWComponents;
import moriyashiine.bewitchment.common.registry.BWRegistries;
import moriyashiine.bewitchment.common.world.BWUniversalWorldState;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class BWCommands {
    public static void init(CommandDispatcher<class_2168> dispatcher, boolean dedicated) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fortune").requires(serverCommandSource -> serverCommandSource.method_9259(3))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            Fortune.Instance fortune = ((FortuneComponent)BWComponents.FORTUNE_COMPONENT.get((Object)player)).getFortune();
            if (fortune != null) {
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.fortune.get", new Object[]{player.method_5820(), BWRegistries.FORTUNES.method_10221((Object)fortune.fortune)}), false);
                return 1;
            }
            throw FortuneArgumentType.GET_NO_FORTUNE_EXCEPTION.create((Object)player.method_5820());
        })))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"fortune", (ArgumentType)FortuneArgumentType.fortune()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            Fortune fortune = FortuneArgumentType.getFortune((CommandContext<class_2168>)context, "fortune");
            ((FortuneComponent)BWComponents.FORTUNE_COMPONENT.get((Object)player)).setFortune(new Fortune.Instance(fortune, player.method_6051().nextInt(120000)));
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.fortune.set", new Object[]{player.method_5820(), BWRegistries.FORTUNES.method_10221((Object)fortune)}), true);
            return 1;
        }))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            if (((FortuneComponent)BWComponents.FORTUNE_COMPONENT.get((Object)player)).getFortune() != null) {
                ((FortuneComponent)BWComponents.FORTUNE_COMPONENT.get((Object)player)).setFortune(null);
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.fortune.remove", new Object[]{player.method_5820()}), true);
                return 1;
            }
            throw FortuneArgumentType.REMOVE_NO_FORTUNE_EXCEPTION.create((Object)player.method_5820());
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"transformation").requires(serverCommandSource -> serverCommandSource.method_9259(3))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.transformation.get", new Object[]{player.method_5820(), BWRegistries.TRANSFORMATIONS.method_10221((Object)((TransformationComponent)BWComponents.TRANSFORMATION_COMPONENT.get((Object)player)).getTransformation())}), false);
            return 1;
        })))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"transformation", (ArgumentType)TransformationArgumentType.transformation()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            BWComponents.TRANSFORMATION_COMPONENT.maybeGet((Object)player).ifPresent(arg_0 -> BWCommands.lambda$init$6(context, (class_1657)player, arg_0));
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"contract").requires(serverCommandSource -> serverCommandSource.method_9259(3))).then(class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            ContractsComponent contractsComponent = (ContractsComponent)BWComponents.CONTRACTS_COMPONENT.get((Object)player);
            if (!contractsComponent.getContracts().isEmpty()) {
                StringBuilder contracts = new StringBuilder();
                for (Contract.Instance instance : contractsComponent.getContracts()) {
                    contracts.append(BWRegistries.CONTRACTS.method_10221((Object)instance.contract).toString()).append(", ");
                }
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.contract.get.multiple", new Object[]{player.method_5820(), contracts.delete(contracts.lastIndexOf(","), contracts.capacity())}), false);
                return 1;
            }
            throw ContractArgumentType.GET_NO_CONTRACTS_EXCEPTION.create((Object)player.method_5820());
        })).then(class_2170.method_9244((String)"contract", (ArgumentType)ContractArgumentType.contract()).executes(context -> {
            Contract contract;
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            ContractsComponent contractsComponent = (ContractsComponent)BWComponents.CONTRACTS_COMPONENT.get((Object)player);
            if (contractsComponent.hasContract(contract = ContractArgumentType.getContract((CommandContext<class_2168>)context, "contract"))) {
                int days = Math.round((float)((Contract.Instance)contractsComponent.getContracts().stream().filter((Predicate<Contract.Instance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$init$10(moriyashiine.bewitchment.api.registry.Contract moriyashiine.bewitchment.api.registry.Contract$Instance ), (Lmoriyashiine/bewitchment/api/registry/Contract$Instance;)Z)((Contract)contract)).findFirst().orElse(null)).duration / 24000.0f);
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.contract.get.single", new Object[]{player.method_5820(), days, BWRegistries.CONTRACTS.method_10221((Object)contract)}), false);
                return 1;
            }
            throw ContractArgumentType.GET_NO_CONTRACT_EXCEPTION.create((Object)player.method_5820());
        }))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"contract", (ArgumentType)ContractArgumentType.contract()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            Contract contract = ContractArgumentType.getContract((CommandContext<class_2168>)context, "contract");
            ((ContractsComponent)BWComponents.CONTRACTS_COMPONENT.get((Object)player)).addContract(new Contract.Instance(contract, 168000, 0));
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.contract.add", new Object[]{player.method_5820(), 7, BWRegistries.CONTRACTS.method_10221((Object)contract)}), true);
            return 1;
        })).then(class_2170.method_9244((String)"days", (ArgumentType)IntegerArgumentType.integer((int)1, (int)365)).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            Contract contract = ContractArgumentType.getContract((CommandContext<class_2168>)context, "contract");
            int days = IntegerArgumentType.getInteger((CommandContext)context, (String)"days");
            ((ContractsComponent)BWComponents.CONTRACTS_COMPONENT.get((Object)player)).addContract(new Contract.Instance(contract, days * 24000, 0));
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.contract.add", new Object[]{player.method_5820(), days, BWRegistries.CONTRACTS.method_10221((Object)contract)}), true);
            return 1;
        })))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"contract", (ArgumentType)ContractArgumentType.contract()).executes(context -> {
            Contract contract;
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            ContractsComponent contractsComponent = (ContractsComponent)BWComponents.CONTRACTS_COMPONENT.get((Object)player);
            if (contractsComponent.hasContract(contract = ContractArgumentType.getContract((CommandContext<class_2168>)context, "contract"))) {
                contractsComponent.removeContract(contract);
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.contract.remove", new Object[]{player.method_5820(), BWRegistries.CONTRACTS.method_10221((Object)contract)}), true);
                return 1;
            }
            throw ContractArgumentType.REMOVE_NO_CONTRACT_EXCEPTION.create((Object)player.method_5820());
        }))))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            ContractsComponent contractsComponent = (ContractsComponent)BWComponents.CONTRACTS_COMPONENT.get((Object)player);
            if (!contractsComponent.getContracts().isEmpty()) {
                contractsComponent.getContracts().clear();
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.contract.clear", new Object[]{player.method_5820()}), true);
                return 1;
            }
            throw ContractArgumentType.CLEAR_NO_CONTRACTS_EXCPETION.create((Object)player.method_5820());
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"curse").requires(serverCommandSource -> serverCommandSource.method_9259(3))).then(class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> {
            class_1297 entity = class_2186.method_9313((CommandContext)context, (String)"entity");
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                CursesComponent cursesComponent = (CursesComponent)BWComponents.CURSES_COMPONENT.get((Object)livingEntity);
                if (!cursesComponent.getCurses().isEmpty()) {
                    StringBuilder curses = new StringBuilder();
                    for (Curse.Instance instance : cursesComponent.getCurses()) {
                        curses.append(BWRegistries.CURSES.method_10221((Object)instance.curse).toString()).append(", ");
                    }
                    ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.curse.get.multiple", new Object[]{entity.method_5820(), curses.delete(curses.lastIndexOf(","), curses.capacity())}), false);
                    return 1;
                }
                throw CurseArgumentType.GET_NO_CURSES_EXCEPTION.create((Object)entity.method_5820());
            }
            return 0;
        })).then(class_2170.method_9244((String)"curse", (ArgumentType)CurseArgumentType.curse()).executes(context -> {
            class_1297 entity = class_2186.method_9313((CommandContext)context, (String)"entity");
            if (entity instanceof class_1309) {
                Curse curse;
                class_1309 livingEntity = (class_1309)entity;
                CursesComponent cursesComponent = (CursesComponent)BWComponents.CURSES_COMPONENT.get((Object)livingEntity);
                if (cursesComponent.hasCurse(curse = CurseArgumentType.getCurse((CommandContext<class_2168>)context, "curse"))) {
                    int days = Math.round((float)((Curse.Instance)cursesComponent.getCurses().stream().filter((Predicate<Curse.Instance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$init$18(moriyashiine.bewitchment.api.registry.Curse moriyashiine.bewitchment.api.registry.Curse$Instance ), (Lmoriyashiine/bewitchment/api/registry/Curse$Instance;)Z)((Curse)curse)).findFirst().orElse(null)).duration / 24000.0f);
                    ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.curse.get.single", new Object[]{entity.method_5820(), days, BWRegistries.CURSES.method_10221((Object)curse)}), false);
                    return 1;
                }
                throw CurseArgumentType.GET_NO_CURSE_EXCEPTION.create((Object)entity.method_5820());
            }
            return 0;
        }))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"curse", (ArgumentType)CurseArgumentType.curse()).executes(context -> {
            class_1297 entity = class_2186.method_9313((CommandContext)context, (String)"entity");
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                Curse curse = CurseArgumentType.getCurse((CommandContext<class_2168>)context, "curse");
                ((CursesComponent)BWComponents.CURSES_COMPONENT.get((Object)livingEntity)).addCurse(new Curse.Instance(curse, 168000));
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.curse.add", new Object[]{entity.method_5820(), 7, BWRegistries.CURSES.method_10221((Object)curse)}), true);
                return 1;
            }
            return 0;
        })).then(class_2170.method_9244((String)"days", (ArgumentType)IntegerArgumentType.integer((int)1, (int)365)).executes(context -> {
            class_1297 entity = class_2186.method_9313((CommandContext)context, (String)"entity");
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                Curse curse = CurseArgumentType.getCurse((CommandContext<class_2168>)context, "curse");
                int days = IntegerArgumentType.getInteger((CommandContext)context, (String)"days");
                ((CursesComponent)BWComponents.CURSES_COMPONENT.get((Object)livingEntity)).addCurse(new Curse.Instance(curse, days * 24000));
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.curse.add", new Object[]{entity.method_5820(), days, BWRegistries.CURSES.method_10221((Object)curse)}), true);
                return 1;
            }
            return 0;
        })))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"curse", (ArgumentType)CurseArgumentType.curse()).executes(context -> {
            class_1297 entity = class_2186.method_9313((CommandContext)context, (String)"entity");
            if (entity instanceof class_1309) {
                Curse curse;
                class_1309 livingEntity = (class_1309)entity;
                CursesComponent cursesComponent = (CursesComponent)BWComponents.CURSES_COMPONENT.get((Object)livingEntity);
                if (cursesComponent.hasCurse(curse = CurseArgumentType.getCurse((CommandContext<class_2168>)context, "curse"))) {
                    cursesComponent.removeCurse(curse);
                    ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.curse.remove", new Object[]{entity.method_5820(), BWRegistries.CURSES.method_10221((Object)curse)}), true);
                    return 1;
                }
                throw CurseArgumentType.REMOVE_NO_CURSE_EXCEPTION.create((Object)entity.method_5820());
            }
            return 0;
        }))))).then(class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> {
            class_1297 entity = class_2186.method_9313((CommandContext)context, (String)"entity");
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                CursesComponent cursesComponent = (CursesComponent)BWComponents.CURSES_COMPONENT.get((Object)livingEntity);
                if (!cursesComponent.getCurses().isEmpty()) {
                    cursesComponent.getCurses().clear();
                    ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.curse.clear", new Object[]{entity.method_5820()}), true);
                    return 1;
                }
                throw CurseArgumentType.CLEAR_NO_CURSES_EXCPETION.create((Object)entity.method_5820());
            }
            return 0;
        }))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"removefamiliar").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            if (player != null) {
                BWUniversalWorldState universalWorldState = BWUniversalWorldState.get(player.field_6002);
                for (int i = universalWorldState.familiars.size() - 1; i >= 0; --i) {
                    if (!player.method_5667().equals(universalWorldState.familiars.get(i).method_15442())) continue;
                    universalWorldState.familiars.remove(i);
                    universalWorldState.method_80();
                    ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.removefamiliar.success", new Object[]{player.method_5477()}), true);
                    return 1;
                }
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.removefamiliar.no_familiar", new Object[]{player.method_5477()}), true);
            }
            return 0;
        })));
    }

    public static void registerArgumentTypes() {
        class_2316.method_10017((String)"bewitchment:fortune", FortuneArgumentType.class, (class_2314)new class_2319(FortuneArgumentType::fortune));
        class_2316.method_10017((String)"bewitchment:transformation", TransformationArgumentType.class, (class_2314)new class_2319(TransformationArgumentType::transformation));
        class_2316.method_10017((String)"bewitchment:contract", ContractArgumentType.class, (class_2314)new class_2319(ContractArgumentType::contract));
        class_2316.method_10017((String)"bewitchment:curse", CurseArgumentType.class, (class_2314)new class_2319(CurseArgumentType::curse));
    }

    private static /* synthetic */ boolean lambda$init$18(Curse curse, Curse.Instance instance) {
        return instance.curse == curse;
    }

    private static /* synthetic */ boolean lambda$init$10(Contract contract, Contract.Instance instance) {
        return instance.contract == contract;
    }

    private static /* synthetic */ void lambda$init$6(CommandContext context, class_1657 player, TransformationComponent transformationComponent) {
        Transformation transformation = TransformationArgumentType.getTransformation((CommandContext<class_2168>)context, "transformation");
        if (transformationComponent.isAlternateForm()) {
            TransformationAbilityPacket.useAbility(player, true);
        }
        transformationComponent.getTransformation().onRemoved(player);
        transformationComponent.setTransformation(transformation);
        transformationComponent.getTransformation().onAdded(player);
        ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.transformation.set", new Object[]{player.method_5820(), BWRegistries.TRANSFORMATIONS.method_10221((Object)transformation)}), true);
    }

    private static class FortuneArgumentType
    implements ArgumentType<Fortune> {
        public static final DynamicCommandExceptionType INVALID_FORTUNE_EXCEPTION = new DynamicCommandExceptionType(object -> new class_2588("commands.fortune.not_found", new Object[]{object}));
        public static final DynamicCommandExceptionType GET_NO_FORTUNE_EXCEPTION = new DynamicCommandExceptionType(object -> new class_2588("commands.fortune.get.no_fortune", new Object[]{object}));
        public static final DynamicCommandExceptionType REMOVE_NO_FORTUNE_EXCEPTION = new DynamicCommandExceptionType(object -> new class_2588("commands.fortune.remove.no_fortune", new Object[]{object}));

        private FortuneArgumentType() {
        }

        public static FortuneArgumentType fortune() {
            return new FortuneArgumentType();
        }

        public static Fortune getFortune(CommandContext<class_2168> commandContext, String string) {
            return (Fortune)commandContext.getArgument(string, Fortune.class);
        }

        public Fortune parse(StringReader reader) throws CommandSyntaxException {
            class_2960 identifier = class_2960.method_12835((StringReader)reader);
            return (Fortune)BWRegistries.FORTUNES.method_17966(identifier).orElseThrow(() -> INVALID_FORTUNE_EXCEPTION.create((Object)identifier));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return class_2172.method_9270((Iterable)BWRegistries.FORTUNES.method_10235(), (SuggestionsBuilder)builder);
        }
    }

    private static class TransformationArgumentType
    implements ArgumentType<Transformation> {
        public static final DynamicCommandExceptionType INVALID_TRANSFORMATION_EXCEPTION = new DynamicCommandExceptionType(object -> new class_2588("commands.transformation.not_found", new Object[]{object}));

        private TransformationArgumentType() {
        }

        public static TransformationArgumentType transformation() {
            return new TransformationArgumentType();
        }

        public static Transformation getTransformation(CommandContext<class_2168> commandContext, String string) {
            return (Transformation)commandContext.getArgument(string, Transformation.class);
        }

        public Transformation parse(StringReader reader) throws CommandSyntaxException {
            class_2960 identifier = class_2960.method_12835((StringReader)reader);
            return (Transformation)BWRegistries.TRANSFORMATIONS.method_17966(identifier).orElseThrow(() -> INVALID_TRANSFORMATION_EXCEPTION.create((Object)identifier));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return class_2172.method_9270((Iterable)BWRegistries.TRANSFORMATIONS.method_10235(), (SuggestionsBuilder)builder);
        }
    }

    private static class ContractArgumentType
    implements ArgumentType<Contract> {
        public static final DynamicCommandExceptionType INVALID_CONTRACT_EXCEPTION = new DynamicCommandExceptionType(object -> new class_2588("commands.contract.not_found", new Object[]{object}));
        public static final DynamicCommandExceptionType GET_NO_CONTRACTS_EXCEPTION = new DynamicCommandExceptionType(object -> new class_2588("commands.contract.get.no_contracts", new Object[]{object}));
        public static final DynamicCommandExceptionType GET_NO_CONTRACT_EXCEPTION = new DynamicCommandExceptionType(object -> new class_2588("commands.contract.get.no_contract", new Object[]{object}));
        public static final DynamicCommandExceptionType REMOVE_NO_CONTRACT_EXCEPTION = new DynamicCommandExceptionType(object -> new class_2588("commands.contract.remove.no_contract", new Object[]{object}));
        public static final DynamicCommandExceptionType CLEAR_NO_CONTRACTS_EXCPETION = new DynamicCommandExceptionType(object -> new class_2588("commands.contract.clear.no_contracts", new Object[]{object}));

        private ContractArgumentType() {
        }

        public static ContractArgumentType contract() {
            return new ContractArgumentType();
        }

        public static Contract getContract(CommandContext<class_2168> commandContext, String string) {
            return (Contract)commandContext.getArgument(string, Contract.class);
        }

        public Contract parse(StringReader reader) throws CommandSyntaxException {
            class_2960 identifier = class_2960.method_12835((StringReader)reader);
            return (Contract)BWRegistries.CONTRACTS.method_17966(identifier).orElseThrow(() -> INVALID_CONTRACT_EXCEPTION.create((Object)identifier));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return class_2172.method_9270((Iterable)BWRegistries.CONTRACTS.method_10235(), (SuggestionsBuilder)builder);
        }
    }

    private static class CurseArgumentType
    implements ArgumentType<Curse> {
        public static final DynamicCommandExceptionType INVALID_CURSE_EXCEPTION = new DynamicCommandExceptionType(object -> new class_2588("commands.curse.not_found", new Object[]{object}));
        public static final DynamicCommandExceptionType GET_NO_CURSES_EXCEPTION = new DynamicCommandExceptionType(object -> new class_2588("commands.curse.get.no_curses", new Object[]{object}));
        public static final DynamicCommandExceptionType GET_NO_CURSE_EXCEPTION = new DynamicCommandExceptionType(object -> new class_2588("commands.curse.get.no_curse", new Object[]{object}));
        public static final DynamicCommandExceptionType REMOVE_NO_CURSE_EXCEPTION = new DynamicCommandExceptionType(object -> new class_2588("commands.curse.remove.no_curse", new Object[]{object}));
        public static final DynamicCommandExceptionType CLEAR_NO_CURSES_EXCPETION = new DynamicCommandExceptionType(object -> new class_2588("commands.curse.clear.no_curses", new Object[]{object}));

        private CurseArgumentType() {
        }

        public static CurseArgumentType curse() {
            return new CurseArgumentType();
        }

        public static Curse getCurse(CommandContext<class_2168> commandContext, String string) {
            return (Curse)commandContext.getArgument(string, Curse.class);
        }

        public Curse parse(StringReader reader) throws CommandSyntaxException {
            class_2960 identifier = class_2960.method_12835((StringReader)reader);
            return (Curse)BWRegistries.CURSES.method_17966(identifier).orElseThrow(() -> INVALID_CURSE_EXCEPTION.create((Object)identifier));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return class_2172.method_9270((Iterable)BWRegistries.CURSES.method_10235(), (SuggestionsBuilder)builder);
        }
    }
}

