/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import moriyashiine.bewitchment.api.registry.RitualFunction;
import moriyashiine.bewitchment.common.registry.BWRecipeTypes;
import moriyashiine.bewitchment.common.registry.BWRegistries;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;

public class RitualRecipe
implements class_1860<class_1263> {
    private final class_2960 identifier;
    public final class_2371<class_1856> input;
    public final String inner;
    public final String outer;
    public final RitualFunction ritualFunction;
    public final int cost;
    public final int runningTime;

    public RitualRecipe(class_2960 identifier, class_2371<class_1856> input, String inner, String outer, RitualFunction ritualFunction, int cost, int runningTime) {
        this.identifier = identifier;
        this.input = input;
        this.inner = inner;
        this.outer = outer;
        this.ritualFunction = ritualFunction;
        this.cost = cost;
        this.runningTime = runningTime;
    }

    public boolean method_8115(class_1263 inv, class_1937 world) {
        return RitualRecipe.matches(inv, this.input);
    }

    public class_1799 method_8116(class_1263 inv) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110() {
        return class_1799.field_8037;
    }

    public class_2960 method_8114() {
        return this.identifier;
    }

    public class_1865<?> method_8119() {
        return BWRecipeTypes.RITUAL_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return BWRecipeTypes.RITUAL_RECIPE_TYPE;
    }

    public static boolean matches(class_1263 inv, class_2371<class_1856> input) {
        ArrayList<class_1799> checklist = new ArrayList<class_1799>();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            checklist.add(stack);
        }
        if (input.size() != checklist.size()) {
            return false;
        }
        for (class_1856 ingredient : input) {
            boolean found = false;
            for (class_1799 stack : checklist) {
                if (!ingredient.method_8093(stack)) continue;
                found = true;
                checklist.remove(stack);
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static class Serializer
    implements class_1865<RitualRecipe> {
        public RitualRecipe read(class_2960 id, JsonObject json) {
            class_2371<class_1856> ingredients = Serializer.getIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for ritual recipe");
            }
            if (ingredients.size() > 6) {
                throw new JsonParseException("Too many ingredients for ritual recipe");
            }
            String inner = class_3518.method_15265((JsonObject)json, (String)"inner");
            if (inner.isEmpty()) {
                throw new JsonParseException("Inner circle is empty");
            }
            return new RitualRecipe(id, ingredients, inner, class_3518.method_15253((JsonObject)json, (String)"outer", (String)""), (RitualFunction)BWRegistries.RITUAL_FUNCTIONS.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"ritual_function"))), class_3518.method_15260((JsonObject)json, (String)"cost"), class_3518.method_15282((JsonObject)json, (String)"running_time", (int)0));
        }

        public RitualRecipe read(class_2960 id, class_2540 buf) {
            class_2371 defaultedList = class_2371.method_10213((int)buf.method_10816(), (Object)class_1856.field_9017);
            for (int i = 0; i < defaultedList.size(); ++i) {
                defaultedList.set(i, (Object)class_1856.method_8086((class_2540)buf));
            }
            return new RitualRecipe(id, (class_2371<class_1856>)defaultedList, buf.method_19772(), buf.method_19772(), (RitualFunction)BWRegistries.RITUAL_FUNCTIONS.method_10223(new class_2960(buf.method_19772())), buf.readInt(), buf.readInt());
        }

        public void write(class_2540 buf, RitualRecipe recipe) {
            buf.method_10804(recipe.input.size());
            for (class_1856 ingredient : recipe.input) {
                ingredient.method_8088(buf);
            }
            buf.method_10814(recipe.inner);
            buf.method_10814(recipe.outer);
            buf.method_10814(BWRegistries.RITUAL_FUNCTIONS.method_10221((Object)recipe.ritualFunction).toString());
            buf.writeInt(recipe.cost);
            buf.writeInt(recipe.runningTime);
        }

        public static class_2371<class_1856> getIngredients(JsonArray json) {
            class_2371 ingredients = class_2371.method_10211();
            for (int i = 0; i < json.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)json.get(i));
                if (ingredient.method_8103()) continue;
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }
    }
}

