/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.network.packet;

import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.Pal;
import io.github.ladysnake.pal.VanillaAbilities;
import io.netty.buffer.Unpooled;
import moriyashiine.bewitchment.api.BewitchmentAPI;
import moriyashiine.bewitchment.api.component.BloodComponent;
import moriyashiine.bewitchment.api.component.TransformationComponent;
import moriyashiine.bewitchment.client.network.packet.SpawnSmokeParticlesPacket;
import moriyashiine.bewitchment.common.component.entity.AdditionalWerewolfDataComponent;
import moriyashiine.bewitchment.common.registry.BWComponents;
import moriyashiine.bewitchment.common.registry.BWEntityTypes;
import moriyashiine.bewitchment.common.registry.BWScaleTypes;
import moriyashiine.bewitchment.common.registry.BWSoundEvents;
import moriyashiine.bewitchment.common.registry.BWTransformations;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import virtuoel.pehkui.api.ScaleData;

public class TransformationAbilityPacket {
    public static final class_2960 ID = new class_2960("bewitchment", "transformation_ability");
    public static final AbilitySource VAMPIRE_FLIGHT_SOURCE = Pal.getAbilitySource((class_2960)new class_2960("bewitchment", "vampire_flight"));
    private static final float VAMPIRE_WIDTH = class_1299.field_6108.method_17685() / class_1299.field_6097.method_17685();
    private static final float VAMPIRE_HEIGHT = class_1299.field_6108.method_17686() / class_1299.field_6097.method_17686();
    private static final float WEREWOLF_WIDTH = BWEntityTypes.WEREWOLF.method_17685() / class_1299.field_6097.method_17685();
    private static final float WEREWOLF_HEIGHT = BWEntityTypes.WEREWOLF.method_17686() / class_1299.field_6097.method_17686();

    public static void send() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        ClientPlayNetworking.send((class_2960)ID, (class_2540)buf);
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 network, class_2540 buf, PacketSender sender) {
        server.execute(() -> {
            if (TransformationAbilityPacket.canUseAbility((class_1657)player)) {
                TransformationAbilityPacket.useAbility((class_1657)player, false);
            }
        });
    }

    private static boolean canUseAbility(class_1657 player) {
        TransformationComponent transformationComponent = (TransformationComponent)BWComponents.TRANSFORMATION_COMPONENT.get((Object)player);
        if (transformationComponent.getTransformation() == BWTransformations.VAMPIRE) {
            return true;
        }
        if (transformationComponent.getTransformation() == BWTransformations.WEREWOLF) {
            return !((AdditionalWerewolfDataComponent)BWComponents.ADDITIONAL_WEREWOLF_DATA_COMPONENT.get((Object)player)).isForcedTransformation();
        }
        return false;
    }

    public static void useAbility(class_1657 player, boolean forced) {
        BWComponents.TRANSFORMATION_COMPONENT.maybeGet((Object)player).ifPresent(transformationComponent -> {
            class_1937 world = player.field_6002;
            boolean isAlternateForm = transformationComponent.isAlternateForm();
            ScaleData width = BWScaleTypes.MODIFY_WIDTH_TYPE.getScaleData((class_1297)player);
            ScaleData height = BWScaleTypes.MODIFY_HEIGHT_TYPE.getScaleData((class_1297)player);
            if (transformationComponent.getTransformation() == BWTransformations.VAMPIRE && (forced || BewitchmentAPI.isPledged(player, "pledge.bewitchment.lilith") && ((BloodComponent)BWComponents.BLOOD_COMPONENT.get((Object)player)).getBlood() > 0)) {
                PlayerLookup.tracking((class_1297)player).forEach(trackingPlayer -> SpawnSmokeParticlesPacket.send((class_1657)trackingPlayer, (class_1297)player));
                SpawnSmokeParticlesPacket.send(player, (class_1297)player);
                world.method_8396(null, player.method_24515(), BWSoundEvents.ENTITY_GENERIC_TRANSFORM, player.method_5634(), 1.0f, 1.0f);
                transformationComponent.setAlternateForm(!isAlternateForm);
                if (isAlternateForm) {
                    width.setScale(width.getBaseScale() / VAMPIRE_WIDTH);
                    height.setScale(height.getBaseScale() / VAMPIRE_HEIGHT);
                    VAMPIRE_FLIGHT_SOURCE.revokeFrom(player, VanillaAbilities.ALLOW_FLYING);
                    VAMPIRE_FLIGHT_SOURCE.revokeFrom(player, VanillaAbilities.FLYING);
                } else {
                    width.setScale(width.getBaseScale() * VAMPIRE_WIDTH);
                    height.setScale(height.getBaseScale() * VAMPIRE_HEIGHT);
                    VAMPIRE_FLIGHT_SOURCE.grantTo(player, VanillaAbilities.ALLOW_FLYING);
                    VAMPIRE_FLIGHT_SOURCE.grantTo(player, VanillaAbilities.FLYING);
                }
            } else if (transformationComponent.getTransformation() == BWTransformations.WEREWOLF && (forced || BewitchmentAPI.isPledged(player, "pledge.bewitchment.herne"))) {
                PlayerLookup.tracking((class_1297)player).forEach(trackingPlayer -> SpawnSmokeParticlesPacket.send((class_1657)trackingPlayer, (class_1297)player));
                SpawnSmokeParticlesPacket.send(player, (class_1297)player);
                world.method_8396(null, player.method_24515(), BWSoundEvents.ENTITY_GENERIC_TRANSFORM, player.method_5634(), 1.0f, 1.0f);
                transformationComponent.setAlternateForm(!isAlternateForm);
                if (isAlternateForm) {
                    width.setScale(width.getBaseScale() / WEREWOLF_WIDTH);
                    height.setScale(height.getBaseScale() / WEREWOLF_HEIGHT);
                    if (player.method_6059(class_1294.field_5925) && player.method_6112(class_1294.field_5925).method_5591()) {
                        player.method_6016(class_1294.field_5925);
                    }
                } else {
                    width.setScale(width.getBaseScale() * WEREWOLF_WIDTH);
                    height.setScale(height.getBaseScale() * WEREWOLF_HEIGHT);
                }
            }
        });
    }
}

