/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.network.packet;

import io.netty.buffer.Unpooled;
import moriyashiine.bewitchment.api.BewitchmentAPI;
import moriyashiine.bewitchment.api.block.entity.UsesAltarPower;
import moriyashiine.bewitchment.common.block.entity.WitchAltarBlockEntity;
import moriyashiine.bewitchment.common.block.entity.WitchCauldronBlockEntity;
import moriyashiine.bewitchment.common.misc.BWUtil;
import moriyashiine.bewitchment.common.world.BWWorldState;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class CauldronTeleportPacket {
    public static final class_2960 ID = new class_2960("bewitchment", "cauldron_teleport");

    public static void send(class_2338 cauldronPos, String message) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(cauldronPos);
        buf.method_10814(message);
        ClientPlayNetworking.send((class_2960)ID, (class_2540)buf);
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 network, class_2540 buf, PacketSender sender) {
        class_2338 cauldronPos = buf.method_10811();
        String message = buf.method_10800(Short.MAX_VALUE);
        server.execute(() -> {
            class_1937 world = player.field_6002;
            class_2338 closest = null;
            BWWorldState worldState = BWWorldState.get(world);
            for (Long longPos : worldState.witchCauldrons) {
                WitchCauldronBlockEntity cauldron;
                class_2338 pos = class_2338.method_10092((long)longPos);
                class_2586 blockEntity = world.method_8321(pos);
                if (!(blockEntity instanceof WitchCauldronBlockEntity) || !(cauldron = (WitchCauldronBlockEntity)blockEntity).method_16914() || !cauldron.method_5797().getString().equals(message) || closest != null && !(pos.method_19770((class_2374)player.method_19538(), true) < closest.method_19770((class_2374)player.method_19538(), true))) continue;
                closest = pos;
            }
            if (closest != null) {
                WitchAltarBlockEntity altar;
                class_2586 altarBE;
                class_2338 altarPos;
                boolean hasPower = BewitchmentAPI.isPledged((class_1657)player, "pledge.bewitchment.leonard");
                if (!hasPower && (altarPos = ((UsesAltarPower)world.method_8321(cauldronPos)).getAltarPos()) != null && (altarBE = world.method_8321(altarPos)) instanceof WitchAltarBlockEntity && (altar = (WitchAltarBlockEntity)altarBE).drain((int)Math.sqrt(closest.method_19770((class_2374)player.method_19538(), true)) / 2, false)) {
                    hasPower = true;
                }
                if (hasPower) {
                    BWUtil.teleport((class_1297)player, (double)closest.method_10263() + 0.5, (double)closest.method_10264() - 0.4375, (double)closest.method_10260() + 0.5, true);
                } else {
                    player.method_7353((class_2561)new class_2588("bewitchment.message.insufficent_altar_power", new Object[]{message}), true);
                }
            } else {
                player.method_7353((class_2561)new class_2588("bewitchment.message.invalid_cauldron", new Object[]{message}), true);
            }
        });
    }
}

