/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.item;

import java.util.List;
import java.util.UUID;
import moriyashiine.bewitchment.common.block.entity.interfaces.Lockable;
import moriyashiine.bewitchment.common.block.entity.interfaces.SigilHolder;
import moriyashiine.bewitchment.common.block.entity.interfaces.TaglockHolder;
import moriyashiine.bewitchment.common.misc.BWUtil;
import moriyashiine.bewitchment.common.registry.BWObjects;
import moriyashiine.bewitchment.common.registry.BWSigils;
import moriyashiine.bewitchment.common.registry.BWSoundEvents;
import moriyashiine.bewitchment.common.registry.BWTags;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class TaglockItem
extends class_1792 {
    public TaglockItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = world.method_8320(pos);
        class_1657 player = context.method_8036();
        boolean client = world.field_9236;
        if (state.method_26204() instanceof class_2244) {
            MinecraftServer server;
            if (!client && player != null && player.method_5715() && (server = world.method_8503()) != null) {
                if (state.method_11654((class_2769)class_2244.field_9967) != class_2742.field_12560) {
                    pos = pos.method_10093((class_2350)state.method_11654((class_2769)class_2244.field_11177));
                }
                class_3222 earliestSleeper = null;
                for (class_3222 playerEntity : server.method_3760().method_14571()) {
                    class_2338 bedPos = playerEntity.method_26280();
                    if (bedPos == null || !bedPos.equals((Object)pos) || earliestSleeper != null && playerEntity.method_7297() >= earliestSleeper.method_7297()) continue;
                    earliestSleeper = playerEntity;
                }
                if (earliestSleeper != null) {
                    return TaglockItem.useTaglock(player, earliestSleeper, context.method_20287(), false, true);
                }
            }
            return class_1269.method_29236((boolean)client);
        }
        class_1799 stack = context.method_8041();
        class_2586 blockEntity = world.method_8321(state.method_26204() instanceof class_2323 && state.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12609 ? pos.method_10074() : pos);
        if (blockEntity instanceof TaglockHolder) {
            int firstEmpty;
            TaglockHolder taglockHolder = (TaglockHolder)blockEntity;
            if (player.method_5667().equals(taglockHolder.getOwner()) && (firstEmpty = taglockHolder.getFirstEmptySlot()) != -1) {
                if (!client) {
                    taglockHolder.getTaglockInventory().set(firstEmpty, (Object)stack.method_7971(1));
                    taglockHolder.syncTaglockHolder(blockEntity);
                    blockEntity.method_5431();
                }
                return class_1269.method_29236((boolean)client);
            }
        } else if (blockEntity instanceof Lockable) {
            Lockable lockable = (Lockable)blockEntity;
            if (TaglockItem.hasTaglock(stack) && player.method_5667().equals(lockable.getOwner()) && lockable.getLocked()) {
                UUID uuid = TaglockItem.getTaglockUUID(stack);
                if (!lockable.getEntities().contains(uuid)) {
                    if (!client) {
                        if (lockable.getEntities().isEmpty()) {
                            lockable.setModeOnWhitelist(true);
                        }
                        lockable.getEntities().add(uuid);
                        if (!player.method_7337()) {
                            stack.method_7934(1);
                        }
                        lockable.syncLockable(blockEntity);
                        blockEntity.method_5431();
                    }
                    return class_1269.method_29236((boolean)client);
                }
            }
        } else if (blockEntity instanceof SigilHolder) {
            SigilHolder sigilHolder = (SigilHolder)blockEntity;
            if (TaglockItem.hasTaglock(stack)) {
                if (!client && sigilHolder.getSigil() != null) {
                    UUID uuid = TaglockItem.getTaglockUUID(stack);
                    if (!sigilHolder.getEntities().contains(uuid)) {
                        if (sigilHolder.getEntities().isEmpty()) {
                            sigilHolder.setModeOnWhitelist(true);
                        }
                        sigilHolder.getEntities().add(uuid);
                        if (!player.method_7337()) {
                            stack.method_7934(1);
                        }
                        sigilHolder.syncSigilHolder(blockEntity);
                        blockEntity.method_5431();
                    }
                }
                return class_1269.method_29236((boolean)client);
            }
        }
        return super.method_7884(context);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        if (entity instanceof class_1657) {
            return TaglockItem.useTaglock(user, entity, hand, true, false);
        }
        return super.method_7847(stack, user, entity, hand);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (TaglockItem.hasTaglock(stack)) {
            tooltip.add((class_2561)new class_2585(TaglockItem.getTaglockName(stack)).method_27692(class_124.field_1080));
            class_2487 nbt = stack.method_7969();
            if (nbt.method_10545("UsedForScrying")) {
                if (nbt.method_10545("Failed")) {
                    tooltip.add((class_2561)new class_2588("bewitchment.tooltip.failed").method_27692(class_124.field_1063));
                } else {
                    boolean shifting = class_437.method_25442();
                    class_2338 pos = class_2338.method_10092((long)stack.method_7969().method_10537("LocationPos"));
                    tooltip.add((class_2561)new class_2588("bewitchment.tooltip.location", new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), stack.method_7969().method_10558("LocationWorld")}).method_27692(class_124.field_1063));
                    tooltip.add((class_2561)new class_2588("bewitchment.tooltip.level", new Object[]{stack.method_7969().method_10550("Level")}).method_27692(class_124.field_1063));
                    class_2588 curseTooltip = new class_2588("bewitchment.tooltip.curse");
                    class_2499 cursesList = nbt.method_10554("Curses", 10);
                    if (cursesList.isEmpty()) {
                        curseTooltip.method_10852((class_2561)new class_2588("bewitchment.tooltip.none"));
                    } else if (!shifting) {
                        curseTooltip.method_10852((class_2561)new class_2588("bewitchment.tooltip.press_shift"));
                    }
                    tooltip.add((class_2561)curseTooltip.method_27692(class_124.field_1063));
                    if (shifting) {
                        for (class_2520 element : cursesList) {
                            class_2487 curseCompound = (class_2487)element;
                            class_2588 curseText = new class_2588("curse." + curseCompound.method_10558("Curse").replace(":", "."));
                            int duration = curseCompound.method_10550("Duration") / 24000;
                            tooltip.add((class_2561)new class_2588("bewitchment.tooltip.curse_expanded", new Object[]{curseText, duration}).method_27692(class_124.field_1063));
                        }
                    }
                    class_2588 contractTooltip = new class_2588("bewitchment.tooltip.contract");
                    class_2499 contractList = nbt.method_10554("Contracts", 10);
                    if (contractList.isEmpty()) {
                        contractTooltip.method_10852((class_2561)new class_2588("bewitchment.tooltip.none"));
                    } else if (!shifting) {
                        contractTooltip.method_10852((class_2561)new class_2588("bewitchment.tooltip.press_shift"));
                    }
                    tooltip.add((class_2561)contractTooltip.method_27692(class_124.field_1063));
                    if (shifting) {
                        for (class_2520 element : contractList) {
                            class_2487 contractCompound = (class_2487)element;
                            class_2588 curseText = new class_2588("contract." + contractCompound.method_10558("Contract").replace(":", "."));
                            int duration = contractCompound.method_10550("Duration") / 24000;
                            tooltip.add((class_2561)new class_2588("bewitchment.tooltip.curse_expanded", new Object[]{curseText, duration}).method_27692(class_124.field_1063));
                        }
                    }
                    tooltip.add((class_2561)new class_2588("bewitchment.tooltip.transformation", new Object[]{new class_2588(stack.method_7969().method_10558("Transformation"))}).method_27692(class_124.field_1063));
                    tooltip.add((class_2561)new class_2588("bewitchment.tooltip.familiar", new Object[]{new class_2588("entity." + nbt.method_10558("Familiar").replace(":", "."))}).method_27692(class_124.field_1063));
                    tooltip.add((class_2561)new class_2588("bewitchment.tooltip.pledge", new Object[]{new class_2588(stack.method_7969().method_10558("Pledge"))}).method_27692(class_124.field_1063));
                }
            }
        }
    }

    public static class_1269 useTaglock(class_1657 user, class_1309 entity, class_1268 hand, boolean checkVisibility, boolean bed) {
        class_1799 stack = user.method_5998(hand);
        if (entity.method_5805() && !BWTags.TAGLOCK_BLACKLIST.method_15141((Object)entity.method_5864()) && !TaglockItem.hasTaglock(stack)) {
            class_2586 blockEntity;
            SigilHolder sigil;
            boolean failed = false;
            class_2338 sigilPos = BWUtil.getClosestBlockPos(entity.method_24515(), 16, currentPos -> user.field_6002.method_8321(currentPos) instanceof SigilHolder && ((SigilHolder)user.field_6002.method_8321(currentPos)).getSigil() == BWSigils.SLIPPERY);
            if (sigilPos == null && bed) {
                sigilPos = BWUtil.getClosestBlockPos(user.method_24515(), 16, currentPos -> user.field_6002.method_8321(currentPos) instanceof SigilHolder && ((SigilHolder)user.field_6002.method_8321(currentPos)).getSigil() == BWSigils.SLIPPERY);
            }
            if (sigilPos != null && (sigil = (SigilHolder)(blockEntity = user.field_6002.method_8321(sigilPos))).test((class_1297)entity)) {
                sigil.setUses(sigil.getUses() - 1);
                blockEntity.method_5431();
                failed = true;
            }
            if (!failed && checkVisibility && !entity.method_6113()) {
                double targetYaw = entity.method_5791() % 360.0f;
                double userYaw = user.method_5791() % 360.0f;
                if (userYaw < 0.0) {
                    userYaw += 360.0;
                }
                if (targetYaw < 0.0) {
                    targetYaw += 360.0;
                }
                boolean bl = failed = Math.abs(targetYaw - userYaw) > 120.0;
            }
            if (failed) {
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    player.method_7353((class_2561)new class_2588("bewitchment.message.taglock_fail", new Object[]{user.method_5476().getString()}), false);
                    if (entity.field_6002.field_9236) {
                        entity.field_6002.method_8449(player, (class_1297)user, BWSoundEvents.ENTITY_GENERIC_PLING, class_3419.field_15248, 1.0f, 1.0f);
                    }
                }
                return class_1269.field_5814;
            }
            boolean client = user.field_6002.field_9236;
            if (!client) {
                if (entity instanceof class_1308) {
                    class_1308 mob = (class_1308)entity;
                    mob.method_5971();
                }
                BWUtil.addItemToInventoryAndConsume(user, hand, TaglockItem.putTaglock(new class_1799((class_1935)BWObjects.TAGLOCK), (class_1297)entity));
            } else {
                user.field_6002.method_8449(user, (class_1297)entity, BWSoundEvents.ENTITY_GENERIC_PLING, class_3419.field_15248, 1.0f, 1.0f);
            }
            return class_1269.method_29236((boolean)client);
        }
        return class_1269.field_5814;
    }

    public static class_1799 putTaglock(class_1799 stack, class_1297 entity) {
        stack.method_7948().method_25927("OwnerUUID", entity.method_5667());
        stack.method_7948().method_10582("OwnerName", entity.method_5476().getString());
        stack.method_7948().method_10556("FromPlayer", entity instanceof class_1657);
        return stack;
    }

    public static class_1799 copyTo(class_1799 from, class_1799 to) {
        if (TaglockItem.hasTaglock(from)) {
            to.method_7948().method_25927("OwnerUUID", from.method_7948().method_25926("OwnerUUID"));
            to.method_7948().method_10582("OwnerName", from.method_7948().method_10558("OwnerName"));
            to.method_7948().method_10556("FromPlayer", from.method_7948().method_10577("FromPlayer"));
        }
        return to;
    }

    public static boolean hasTaglock(class_1799 stack) {
        return stack.method_7985() && stack.method_7948().method_10545("OwnerUUID");
    }

    public static void removeTaglock(class_1799 stack) {
        if (stack.method_7985()) {
            stack.method_7948().method_10551("OwnerUUID");
            stack.method_7948().method_10551("OwnerName");
            stack.method_7948().method_10551("FromPlayer");
        }
    }

    public static UUID getTaglockUUID(class_1799 stack) {
        if (TaglockItem.hasTaglock(stack)) {
            return stack.method_7948().method_25926("OwnerUUID");
        }
        return null;
    }

    public static String getTaglockName(class_1799 stack) {
        if (TaglockItem.hasTaglock(stack)) {
            return stack.method_7948().method_10558("OwnerName");
        }
        return "";
    }

    public static boolean isTaglockFromPlayer(class_1799 stack) {
        return TaglockItem.hasTaglock(stack) && stack.method_7948().method_10577("FromPlayer");
    }
}

