/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.entity.living;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import moriyashiine.bewitchment.api.BewitchmentAPI;
import moriyashiine.bewitchment.api.component.ContractsComponent;
import moriyashiine.bewitchment.api.registry.Contract;
import moriyashiine.bewitchment.client.network.packet.SyncContractsPacket;
import moriyashiine.bewitchment.client.network.packet.SyncDemonTradesPacket;
import moriyashiine.bewitchment.client.screen.DemonScreenHandler;
import moriyashiine.bewitchment.common.entity.DemonMerchant;
import moriyashiine.bewitchment.common.entity.living.util.BWHostileEntity;
import moriyashiine.bewitchment.common.misc.BWUtil;
import moriyashiine.bewitchment.common.registry.BWComponents;
import moriyashiine.bewitchment.common.registry.BWMaterials;
import moriyashiine.bewitchment.common.registry.BWRegistries;
import moriyashiine.bewitchment.common.registry.BWSoundEvents;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1531;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1738;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import net.minecraft.class_747;
import org.jetbrains.annotations.Nullable;

public class DemonEntity
extends BWHostileEntity
implements DemonMerchant {
    public static final class_2940<Boolean> MALE = class_2945.method_12791(DemonEntity.class, (class_2941)class_2943.field_13323);
    private final List<DemonTradeOffer> offers = new ArrayList<DemonTradeOffer>();
    private class_1657 customer = null;
    private int tradeResetTimer = 0;

    public DemonEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, 0.0f);
        this.method_5941(class_7.field_3, 0.0f);
        this.field_6194 = 20;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 200.0).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23718, 0.75);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236) {
            class_1309 target;
            ++this.tradeResetTimer;
            if (this.tradeResetTimer >= 168000) {
                this.tradeResetTimer = 0;
                this.offers.clear();
            }
            if ((target = this.method_5968()) != null) {
                this.method_5951((class_1297)target, 360.0f, 360.0f);
                if ((this.field_6012 + this.method_5628()) % 40 == 0) {
                    class_1677 fireball = new class_1677(this.field_6002, (class_1309)this, target.method_23317() - this.method_23317(), target.method_23323(0.5) - this.method_23323(0.5), target.method_23321() - this.method_23321());
                    fireball.method_30634(fireball.method_23317(), this.method_23323(0.5), fireball.method_23321());
                    this.field_6002.method_8396(null, this.method_24515(), BWSoundEvents.ENTITY_GENERIC_SHOOT, this.method_5634(), this.method_6107(), this.method_6017());
                    this.field_6002.method_8649((class_1297)fireball);
                    this.method_6104(class_1268.field_5808);
                }
            }
        }
    }

    @Override
    protected boolean hasShiny() {
        return true;
    }

    @Override
    public int getVariants() {
        return 5;
    }

    public class_1310 method_6046() {
        return BewitchmentAPI.DEMON;
    }

    @Nullable
    protected class_3414 method_5994() {
        return BWSoundEvents.ENTITY_DEMON_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return BWSoundEvents.ENTITY_DEMON_HURT;
    }

    protected class_3414 method_6002() {
        return BWSoundEvents.ENTITY_DEMON_DEATH;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.field_6002.field_9236 && this.method_5805() && this.method_5968() == null) {
            if (BWUtil.rejectTrades((class_1309)this)) {
                return class_1269.field_5814;
            }
            if (this.getCurrentCustomer() == null) {
                this.setCurrentCustomer(player);
            }
            if (!this.getOffers().isEmpty()) {
                SyncContractsPacket.send(player);
                player.method_17355((class_3908)new class_747((id, playerInventory, customer) -> new DemonScreenHandler(id, this), this.method_5476())).ifPresent(syncId -> SyncDemonTradesPacket.send(player, this, syncId));
            } else {
                this.setCurrentCustomer(null);
            }
        }
        return class_1269.method_29236((boolean)this.field_6002.field_9236);
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    public boolean method_17326() {
        return true;
    }

    public boolean method_6121(class_1297 target) {
        boolean flag = super.method_6121(target);
        if (flag && target instanceof class_1309) {
            target.method_5639(6);
            target.method_5762(0.0, 0.2, 0.0);
            this.method_6104(class_1268.field_5808);
        }
        return flag;
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        this.field_6011.method_12778(MALE, (Object)this.field_5974.nextBoolean());
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(MALE, (Object)nbt.method_10577("Male"));
        if (nbt.method_10545("Offers")) {
            this.offers.clear();
            class_2499 offersList = nbt.method_10554("Offers", 10);
            for (class_2520 offerTag : offersList) {
                this.offers.add(new DemonTradeOffer((class_2487)offerTag));
            }
        }
        this.tradeResetTimer = nbt.method_10550("TradeResetTimer");
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Male", ((Boolean)this.field_6011.method_12789(MALE)).booleanValue());
        if (!this.offers.isEmpty()) {
            class_2499 offersList = new class_2499();
            for (DemonTradeOffer offer : this.offers) {
                offersList.add((Object)offer.toTag());
            }
            nbt.method_10566("Offers", (class_2520)offersList);
        }
        nbt.method_10569("TradeResetTimer", this.tradeResetTimer);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(MALE, (Object)false);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, new LookAtCustomerGoal<DemonEntity>(this));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, false, entity -> !(entity instanceof class_1531) && BWUtil.getArmorPieces(entity, stack -> stack.method_7909() instanceof class_1738 && ((class_1738)stack.method_7909()).method_7686() == BWMaterials.BESMIRCHED_ARMOR) < 3 && (entity.method_6046() != BewitchmentAPI.DEMON || entity instanceof class_1657)));
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        this.setCurrentCustomer(null);
    }

    public void method_5980(@Nullable class_1309 target) {
        super.method_5980(target);
        if (target != null) {
            this.setCurrentCustomer(null);
        }
    }

    @Override
    public List<DemonTradeOffer> getOffers() {
        if (this.offers.isEmpty()) {
            List availableContracts = BWRegistries.CONTRACTS.method_10220().collect(Collectors.toList());
            for (int i = 0; i < 3; ++i) {
                Contract contract = (Contract)availableContracts.get(this.field_5974.nextInt(availableContracts.size()));
                this.offers.add(new DemonTradeOffer(contract, 168000, class_3532.method_15395((Random)this.field_5974, (int)3, (int)6)));
                availableContracts.remove(contract);
            }
        }
        return this.offers;
    }

    @Override
    public class_1309 getDemonTrader() {
        return this;
    }

    @Override
    public void onSell(DemonTradeOffer offer) {
        if (!this.field_6002.field_9236) {
            this.field_6002.method_8396(null, this.method_24515(), BWSoundEvents.ITEM_CONTRACT_USE, this.method_5634(), this.method_6107(), this.method_6017());
            this.field_6002.method_8396(null, this.method_24515(), this.method_5994(), this.method_5634(), this.method_6107(), this.method_6017());
        }
    }

    @Override
    public void setCurrentCustomer(class_1657 customer) {
        this.customer = customer;
    }

    @Override
    @Nullable
    public class_1657 getCurrentCustomer() {
        return this.customer;
    }

    public static class DemonTradeOffer {
        private final Contract contract;
        private final int duration;
        private final int cost;

        public DemonTradeOffer(class_2487 tag) {
            this((Contract)BWRegistries.CONTRACTS.method_10223(new class_2960(tag.method_10558("Contract"))), tag.method_10550("Duration"), tag.method_10550("Cost"));
        }

        public DemonTradeOffer(Contract contract, int duration, int cost) {
            this.contract = contract;
            this.duration = duration;
            this.cost = cost;
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10582("Contract", BWRegistries.CONTRACTS.method_10221((Object)this.contract).toString());
            tag.method_10569("Duration", this.duration);
            tag.method_10569("Cost", this.cost);
            return tag;
        }

        public static void toPacket(List<DemonTradeOffer> offers, class_2540 buf) {
            buf.writeInt(offers.size());
            for (DemonTradeOffer offer : offers) {
                buf.method_10812(BWRegistries.CONTRACTS.method_10221((Object)offer.getContract()));
                buf.writeInt(offer.duration);
                buf.writeInt(offer.cost);
            }
        }

        public static List<DemonTradeOffer> fromPacket(class_2540 buf) {
            int count = buf.readInt();
            ArrayList<DemonTradeOffer> offers = new ArrayList<DemonTradeOffer>(count);
            for (int i = 0; i < count; ++i) {
                offers.add(new DemonTradeOffer((Contract)BWRegistries.CONTRACTS.method_10223(buf.method_10810()), buf.readInt(), buf.readInt()));
            }
            return offers;
        }

        public void apply(DemonMerchant merchant) {
            if (merchant.getCurrentCustomer() != null) {
                ((ContractsComponent)BWComponents.CONTRACTS_COMPONENT.get((Object)merchant.getCurrentCustomer())).addContract(new Contract.Instance(this.contract, this.getDuration(), this.getCost(merchant)));
            }
        }

        public Contract getContract() {
            return this.contract;
        }

        public int getDuration() {
            return this.duration;
        }

        public int getCost(DemonMerchant merchant) {
            return merchant.isDiscount() ? 1 : this.cost;
        }
    }

    public static class LookAtCustomerGoal<T extends class_1308>
    extends class_1361 {
        private final T merchant;

        public LookAtCustomerGoal(T merchant) {
            super(merchant, class_1657.class, 8.0f);
            this.merchant = merchant;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (((DemonMerchant)this.merchant).getCurrentCustomer() != null) {
                this.field_6484 = ((DemonMerchant)this.merchant).getCurrentCustomer();
                return true;
            }
            return false;
        }
    }
}

