/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import moriyashiine.bewitchment.api.BewitchmentAPI;
import moriyashiine.bewitchment.api.entity.BroomEntity;
import moriyashiine.bewitchment.api.item.SigilItem;
import moriyashiine.bewitchment.api.registry.Sigil;
import moriyashiine.bewitchment.common.item.AthameItem;
import moriyashiine.bewitchment.common.item.TaglockItem;
import moriyashiine.bewitchment.common.registry.BWEntityTypes;
import moriyashiine.bewitchment.common.registry.BWRegistries;
import moriyashiine.bewitchment.common.registry.BWSoundEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3419;

public class DragonsBloodBroomEntity
extends BroomEntity {
    private final List<UUID> entities = new ArrayList<UUID>();
    private Sigil sigil = null;
    private int uses = 0;
    private boolean modeOnWhitelist = false;

    public DragonsBloodBroomEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236 && this.sigil != null && this.uses <= 0) {
            this.entities.clear();
            this.sigil = null;
            this.uses = 0;
            this.modeOnWhitelist = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        boolean client = this.field_6002.field_9236;
        if (!player.method_5715()) {
            if (this.field_6002.field_9236) return super.method_5688(player, hand);
            if (hand != class_1268.field_5808) return super.method_5688(player, hand);
            if (this.sigil == null) return super.method_5688(player, hand);
            if (this.sigil == null) return super.method_5688(player, hand);
            if (!this.sigil.active) return super.method_5688(player, hand);
            if (!this.test((class_1297)player)) return super.method_5688(player, hand);
            class_1269 result = this.sigil.use(this.field_6002, this.method_24515(), (class_1309)player, hand);
            if (result != class_1269.field_5812) return super.method_5688(player, hand);
            --this.uses;
            return super.method_5688(player, hand);
        }
        if (client) return class_1269.method_29236((boolean)client);
        if (!player.method_5667().equals(this.getOwner())) return class_1269.method_29236((boolean)client);
        class_1799 stack = player.method_5998(hand);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof SigilItem) {
            SigilItem sigilItem = (SigilItem)class_17922;
            if (sigilItem.sigil.active) {
                this.sigil = sigilItem.sigil;
                this.uses = this.sigil.uses * (BewitchmentAPI.getFamiliar(player) == BWEntityTypes.SNAKE ? 2 : 1);
                this.modeOnWhitelist = true;
                stack.method_7934(1);
                return class_1269.method_29236((boolean)client);
            }
        }
        if (this.sigil == null) return class_1269.method_29236((boolean)client);
        if (stack.method_7909() instanceof TaglockItem && TaglockItem.hasTaglock(stack)) {
            this.entities.add(TaglockItem.getTaglockUUID(stack));
            stack.method_7934(1);
            return class_1269.method_29236((boolean)client);
        }
        if (!(stack.method_7909() instanceof AthameItem)) return class_1269.method_29236((boolean)client);
        if (this.entities.isEmpty()) return class_1269.method_29236((boolean)client);
        this.field_6002.method_8396(null, this.method_24515(), BWSoundEvents.BLOCK_SIGIL_PLING, class_3419.field_15254, 1.0f, this.modeOnWhitelist ? 0.5f : 1.0f);
        player.method_7353((class_2561)new class_2588("bewitchment.message.toggle_" + (!this.modeOnWhitelist ? "whitelist" : "blacklist")), true);
        this.modeOnWhitelist = !this.modeOnWhitelist;
        return class_1269.method_29236((boolean)client);
    }

    @Override
    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.readFromNbt(nbt);
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.sigil != null) {
            this.writeToNbt(nbt);
        }
    }

    @Override
    public void init(class_1799 stack) {
        if (stack.method_7985()) {
            this.readFromNbt(stack.method_7969());
        }
    }

    @Override
    protected class_1799 getDroppedStack() {
        class_1799 stack = super.getDroppedStack();
        if (this.sigil != null) {
            this.writeToNbt(stack.method_7948());
        } else if (stack.method_7985()) {
            stack.method_7969().method_10551("Entities");
            stack.method_7969().method_10551("Sigil");
            stack.method_7969().method_10551("Uses");
            stack.method_7969().method_10551("ModeOnWhitelist");
        }
        return stack;
    }

    private void readFromNbt(class_2487 nbt) {
        if (nbt.method_10545("Sigil")) {
            class_2499 entitiesList = nbt.method_10554("Entities", 8);
            for (int i = 0; i < entitiesList.size(); ++i) {
                this.entities.add(UUID.fromString(entitiesList.method_10608(i)));
            }
            this.sigil = (Sigil)BWRegistries.SIGILS.method_10223(new class_2960(nbt.method_10558("Sigil")));
            this.uses = nbt.method_10550("Uses");
            this.modeOnWhitelist = nbt.method_10577("ModeOnWhitelist");
        }
    }

    private void writeToNbt(class_2487 nbt) {
        if (this.sigil != null) {
            class_2499 entitiesList = new class_2499();
            for (UUID entity : this.entities) {
                entitiesList.add((Object)class_2519.method_23256((String)entity.toString()));
            }
            nbt.method_10566("Entities", (class_2520)entitiesList);
            nbt.method_10582("Sigil", BWRegistries.SIGILS.method_10221((Object)this.sigil).toString());
            nbt.method_10569("Uses", this.uses);
            nbt.method_10556("ModeOnWhitelist", this.modeOnWhitelist);
        }
    }

    private boolean test(class_1297 entity) {
        if (!this.entities.isEmpty()) {
            if (this.modeOnWhitelist) {
                return this.entities.contains(entity.method_5667());
            }
            return !this.entities.contains(entity.method_5667());
        }
        return true;
    }
}

