/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.block.entity.interfaces;

import java.util.List;
import java.util.UUID;
import moriyashiine.bewitchment.api.registry.Sigil;
import moriyashiine.bewitchment.common.block.entity.DragonsBloodChestBlockEntity;
import moriyashiine.bewitchment.common.block.entity.SigilBlockEntity;
import moriyashiine.bewitchment.common.registry.BWObjects;
import moriyashiine.bewitchment.common.registry.BWRegistries;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public interface SigilHolder {
    public List<UUID> getEntities();

    public UUID getOwner();

    public void setOwner(UUID var1);

    public Sigil getSigil();

    public void setSigil(Sigil var1);

    public int getUses();

    public void setUses(int var1);

    public boolean getModeOnWhitelist();

    public void setModeOnWhitelist(boolean var1);

    default public void fromNbtSigil(class_2487 nbt) {
        class_2499 entitiesList = nbt.method_10554("Entities", 8);
        for (int i = 0; i < entitiesList.size(); ++i) {
            this.getEntities().add(UUID.fromString(entitiesList.method_10608(i)));
        }
        if (nbt.method_10545("Owner")) {
            this.setOwner(nbt.method_25926("Owner"));
        }
        this.setSigil((Sigil)BWRegistries.SIGILS.method_10223(new class_2960(nbt.method_10558("Sigil"))));
        this.setUses(nbt.method_10550("Uses"));
        this.setModeOnWhitelist(nbt.method_10577("ModeOnWhitelist"));
    }

    default public void toNbtSigil(class_2487 nbt) {
        class_2499 entitiesList = new class_2499();
        for (int i = 0; i < this.getEntities().size(); ++i) {
            entitiesList.add((Object)class_2519.method_23256((String)this.getEntities().get(i).toString()));
        }
        nbt.method_10566("Entities", (class_2520)entitiesList);
        if (this.getOwner() != null) {
            nbt.method_25927("Owner", this.getOwner());
        }
        if (this.getSigil() != null) {
            nbt.method_10582("Sigil", BWRegistries.SIGILS.method_10221((Object)this.getSigil()).toString());
        }
        nbt.method_10569("Uses", this.getUses());
        nbt.method_10556("ModeOnWhitelist", this.getModeOnWhitelist());
    }

    default public void use(class_1937 world, class_2338 pos, class_1309 user, class_1268 hand) {
        class_1269 result;
        if (this.getSigil() != null && this.getSigil().active && this.test((class_1297)user) && (result = this.getSigil().use(world, pos, user, hand)) == class_1269.field_5812) {
            class_2586 blockEntity = world.method_8321(pos);
            this.setUses(this.getUses() - 1);
            this.syncSigilHolder(blockEntity);
            blockEntity.method_5431();
        }
    }

    default public void tick(class_1937 world, class_2338 pos, class_2586 blockEntity) {
        if (world != null && !world.field_9236 && this.getSigil() != null) {
            int used;
            if (!this.getSigil().active && (used = this.getSigil().tick(world, pos)) > 0) {
                this.setUses(this.getUses() - used);
                this.syncSigilHolder(blockEntity);
                blockEntity.method_5431();
            }
            if (this.getUses() <= 0) {
                this.getEntities().clear();
                this.setOwner(null);
                this.setSigil(null);
                this.setUses(0);
                this.setModeOnWhitelist(false);
                this.syncSigilHolder(blockEntity);
                blockEntity.method_5431();
                if (blockEntity.method_11010().method_26204() == BWObjects.SIGIL) {
                    world.method_8501(pos, class_2246.field_10124.method_9564());
                }
            }
        }
    }

    default public boolean test(class_1297 entity) {
        if (!this.getEntities().isEmpty()) {
            if (this.getModeOnWhitelist()) {
                return this.getEntities().contains(entity.method_5667());
            }
            return !this.getEntities().contains(entity.method_5667());
        }
        return true;
    }

    default public void syncSigilHolder(class_2586 blockEntity) {
        if (blockEntity instanceof SigilBlockEntity) {
            SigilBlockEntity sigilBlockEntity = (SigilBlockEntity)blockEntity;
            sigilBlockEntity.sync();
        } else if (blockEntity instanceof DragonsBloodChestBlockEntity) {
            DragonsBloodChestBlockEntity dragonsBloodChestBlockEntity = (DragonsBloodChestBlockEntity)blockEntity;
            dragonsBloodChestBlockEntity.sync();
        }
    }

    public static void onUse(class_1937 world, class_2338 pos, class_1309 user, class_1268 hand) {
        SigilHolder sigilHolder;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof SigilHolder && (sigilHolder = (SigilHolder)class_25862).test((class_1297)user)) {
            sigilHolder.use(world, pos, user, hand);
        }
    }
}

