/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.client.renderer.blockentity;

import java.util.Random;
import moriyashiine.bewitchment.client.misc.SpriteIdentifiers;
import moriyashiine.bewitchment.common.block.entity.WitchCauldronBlockEntity;
import moriyashiine.bewitchment.common.registry.BWParticleTypes;
import moriyashiine.bewitchment.common.registry.BWProperties;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class WitchCauldronBlockEntityRenderer
implements class_827<WitchCauldronBlockEntity> {
    private static final float[] HEIGHT = new float[]{0.0f, 0.25f, 0.4375f, 0.625f};

    public void render(WitchCauldronBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        if (world != null) {
            class_2338 pos = entity.method_11016();
            this.renderName(entity, pos, matrices, vertexConsumers, light);
            int level = (Integer)entity.method_11010().method_11654((class_2769)BWProperties.LEVEL);
            if (level > 0) {
                matrices.method_22903();
                matrices.method_22904(0.0, (double)HEIGHT[level], 0.0);
                if (entity.mode == WitchCauldronBlockEntity.Mode.TELEPORTATION) {
                    this.renderPortal(entity, pos, matrices, vertexConsumers);
                }
                this.renderWater(entity, matrices, vertexConsumers.getBuffer(class_1921.method_23583()), light, overlay, SpriteIdentifiers.CAULDRON_WATER.method_24148());
                matrices.method_22909();
                if (entity.heatTimer >= 60 && !class_310.method_1551().method_1493()) {
                    float fluidHeight = 0.0f;
                    float width = 0.35f;
                    switch ((Integer)entity.method_11010().method_11654((class_2769)BWProperties.LEVEL)) {
                        case 1: {
                            fluidHeight = 0.225f;
                            break;
                        }
                        case 2: {
                            fluidHeight = 0.425f;
                            width = 0.3f;
                            break;
                        }
                        case 3: {
                            fluidHeight = 0.625f;
                        }
                    }
                    if (fluidHeight > 0.0f) {
                        if (entity.mode == WitchCauldronBlockEntity.Mode.TELEPORTATION) {
                            world.method_8406((class_2394)new class_2390(new class_1160((float)(entity.color >> 16 & 0xFF) / 255.0f, (float)(entity.color >> 8 & 0xFF) / 255.0f, (float)(entity.color & 0xFF) / 255.0f), 1.0f), (double)pos.method_10263() + 0.5 + class_3532.method_15366((Random)world.field_9229, (double)(-width), (double)width), (double)((float)pos.method_10264() + fluidHeight), (double)pos.method_10260() + 0.5 + class_3532.method_15366((Random)world.field_9229, (double)(-width), (double)width), 0.0, 0.0, 0.0);
                        }
                        if (entity.mode == WitchCauldronBlockEntity.Mode.OIL_CRAFTING && entity.color != 0xFC00FC) {
                            world.method_8406((class_2394)class_2398.field_11208, (double)pos.method_10263() + 0.5 + class_3532.method_15366((Random)world.field_9229, (double)(-width), (double)width), (double)((float)pos.method_10264() + fluidHeight), (double)pos.method_10260() + 0.5 + class_3532.method_15366((Random)world.field_9229, (double)(-width), (double)width), 0.0, 0.0, 0.0);
                        }
                        if (entity.mode == WitchCauldronBlockEntity.Mode.BREWING) {
                            world.method_8406((class_2394)class_2398.field_11226, (double)pos.method_10263() + 0.5 + class_3532.method_15366((Random)world.field_9229, (double)(-width), (double)width), (double)((float)pos.method_10264() + fluidHeight), (double)pos.method_10260() + 0.5 + class_3532.method_15366((Random)world.field_9229, (double)(-width), (double)width), (double)((float)(entity.color >> 16 & 0xFF) / 255.0f), (double)((float)(entity.color >> 8 & 0xFF) / 255.0f), (double)((float)(entity.color & 0xFF) / 255.0f));
                        }
                        world.method_8406((class_2394)BWParticleTypes.CAULDRON_BUBBLE, (double)pos.method_10263() + 0.5 + class_3532.method_15366((Random)world.field_9229, (double)(-width), (double)width), (double)((float)pos.method_10264() + fluidHeight), (double)pos.method_10260() + 0.5 + class_3532.method_15366((Random)world.field_9229, (double)(-width), (double)width), (double)((float)(entity.color >> 16 & 0xFF) / 255.0f), (double)((float)(entity.color >> 8 & 0xFF) / 255.0f), (double)((float)(entity.color & 0xFF) / 255.0f));
                    }
                }
            }
        }
    }

    private void renderName(WitchCauldronBlockEntity entity, class_2338 pos, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (entity.method_16914() && pos.method_19770((class_2374)class_310.method_1551().method_1561().field_4686.method_19326(), true) <= 256.0) {
            matrices.method_22903();
            matrices.method_22904(0.5, 1.0, 0.5);
            matrices.method_22907(class_310.method_1551().method_1561().field_4686.method_23767());
            matrices.method_22905(-0.025f, -0.025f, 0.025f);
            class_2561 name = entity.method_5797();
            class_1159 model = matrices.method_23760().method_23761();
            int x = -class_310.method_1551().field_1772.method_27525((class_5348)name) / 2;
            class_310.method_1551().field_1772.method_30882(name, (float)x, 0.0f, 0x20FFFF, false, model, vertexConsumers, true, (int)(class_310.method_1551().field_1690.method_19343(0.25f) * 255.0f) << 24, light);
            class_310.method_1551().field_1772.method_30882(name, (float)x, 0.0f, -1, false, model, vertexConsumers, false, 0, light);
            matrices.method_22909();
        }
    }

    private void renderPortal(WitchCauldronBlockEntity entity, class_2338 pos, class_4587 matrices, class_4597 vertexConsumers) {
        matrices.method_22903();
        class_1159 matrix4f = matrices.method_23760().method_23761();
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23574());
        vertexConsumer.method_22918(matrix4f, 0.125f, 0.0f, 0.875f).method_1344();
        vertexConsumer.method_22918(matrix4f, 0.875f, 0.0f, 0.875f).method_1344();
        vertexConsumer.method_22918(matrix4f, 0.875f, 0.0f, 0.125f).method_1344();
        vertexConsumer.method_22918(matrix4f, 0.125f, 0.0f, 0.125f).method_1344();
        matrices.method_22909();
    }

    private void renderWater(WitchCauldronBlockEntity entity, class_4587 matrices, class_4588 buffer, int light, int overlay, class_1058 sprite) {
        matrices.method_22903();
        class_1159 mat = matrices.method_23760().method_23761();
        float sizeFactor = 0.125f;
        float maxV = (sprite.method_4575() - sprite.method_4593()) * sizeFactor;
        float minV = (sprite.method_4575() - sprite.method_4593()) * (1.0f - sizeFactor);
        int red = entity.color >> 16 & 0xFF;
        int green = entity.color >> 8 & 0xFF;
        int blue = entity.color & 0xFF;
        buffer.method_22918(mat, sizeFactor, 0.0f, 1.0f - sizeFactor).method_1336(red, green, blue, 255).method_22913(sprite.method_4594(), sprite.method_4593() + maxV).method_22916(light).method_22922(overlay).method_22914(1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22918(mat, 1.0f - sizeFactor, 0.0f, 1.0f - sizeFactor).method_1336(red, green, blue, 255).method_22913(sprite.method_4577(), sprite.method_4593() + maxV).method_22916(light).method_22922(overlay).method_22914(1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22918(mat, 1.0f - sizeFactor, 0.0f, sizeFactor).method_1336(red, green, blue, 255).method_22913(sprite.method_4577(), sprite.method_4593() + minV).method_22916(light).method_22922(overlay).method_22914(1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22918(mat, sizeFactor, 0.0f, sizeFactor).method_1336(red, green, blue, 255).method_22913(sprite.method_4594(), sprite.method_4593() + minV).method_22916(light).method_22922(overlay).method_22914(1.0f, 1.0f, 1.0f).method_1344();
        matrices.method_22909();
    }
}

