/*
 * Decompiled with CFR 0.152.
 */
package dev.mrsterner.guardvillagers.common.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.mrsterner.guardvillagers.GuardVillagers;
import dev.mrsterner.guardvillagers.GuardVillagersConfig;
import dev.mrsterner.guardvillagers.client.screen.GuardVillagerScreenHandler;
import dev.mrsterner.guardvillagers.common.GuardLootTables;
import dev.mrsterner.guardvillagers.common.ToolAction;
import dev.mrsterner.guardvillagers.common.entity.ai.goals.ArmorerRepairGuardArmorGoal;
import dev.mrsterner.guardvillagers.common.entity.ai.goals.FollowShieldGuards;
import dev.mrsterner.guardvillagers.common.entity.ai.goals.GuardEatFoodGoal;
import dev.mrsterner.guardvillagers.common.entity.ai.goals.GuardRunToEatGoal;
import dev.mrsterner.guardvillagers.common.entity.ai.goals.GuardSetRunningToEatGoal;
import dev.mrsterner.guardvillagers.common.entity.ai.goals.HeroHurtByTargetGoal;
import dev.mrsterner.guardvillagers.common.entity.ai.goals.HeroHurtTargetGoal;
import dev.mrsterner.guardvillagers.common.entity.ai.goals.KickGoal;
import dev.mrsterner.guardvillagers.common.entity.ai.goals.RaiseShieldGoal;
import dev.mrsterner.guardvillagers.common.entity.ai.goals.RangedBowAttackPassiveGoal;
import dev.mrsterner.guardvillagers.common.entity.ai.goals.RangedCrossbowAttackPassiveGoal;
import dev.mrsterner.guardvillagers.common.entity.ai.goals.RunToClericGoal;
import dev.mrsterner.guardvillagers.common.entity.ai.goals.WalkBackToCheckPointGoal;
import dev.mrsterner.guardvillagers.mixin.MeleeAttackGoalAccessor;
import dev.mrsterner.guardvillagers.mixin.MobEntityAccessor;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1368;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1405;
import net.minecraft.class_1439;
import net.minecraft.class_1456;
import net.minecraft.class_1538;
import net.minecraft.class_1543;
import net.minecraft.class_156;
import net.minecraft.class_1569;
import net.minecraft.class_1581;
import net.minecraft.class_1584;
import net.minecraft.class_1603;
import net.minecraft.class_1640;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1703;
import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1811;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3745;
import net.minecraft.class_3763;
import net.minecraft.class_3854;
import net.minecraft.class_3908;
import net.minecraft.class_3988;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4255;
import net.minecraft.class_4291;
import net.minecraft.class_47;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5274;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_6019;
import org.jetbrains.annotations.Nullable;

public class GuardEntity
extends class_1314
implements class_3745,
class_1603,
class_5354,
class_1265 {
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final class_1322 USE_ITEM_SPEED_PENALTY = new class_1322(MODIFIER_UUID, "Use item speed penalty", -0.25, class_1322.class_1323.field_6328);
    private static final class_2940<Optional<class_2338>> GUARD_POS = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13315);
    private static final class_2940<Boolean> PATROLLING = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> GUARD_VARIANT = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> RUNNING_TO_EAT = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_CHARGING_STATE = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> EATING = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> KICKING = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FOLLOWING = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Optional<UUID>> OWNER_UNIQUE_ID = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13313);
    private static final Map<class_4050, class_4048> SIZE_BY_POSE = ImmutableMap.builder().put((Object)class_4050.field_18076, (Object)class_4048.method_18384((float)0.6f, (float)1.95f)).put((Object)class_4050.field_18078, (Object)field_18072).put((Object)class_4050.field_18077, (Object)class_4048.method_18384((float)0.6f, (float)0.6f)).put((Object)class_4050.field_18079, (Object)class_4048.method_18384((float)0.6f, (float)0.6f)).put((Object)class_4050.field_18080, (Object)class_4048.method_18384((float)0.6f, (float)0.6f)).put((Object)class_4050.field_18081, (Object)class_4048.method_18384((float)0.6f, (float)1.75f)).put((Object)class_4050.field_18082, (Object)class_4048.method_18385((float)0.2f, (float)0.2f)).build();
    public class_1277 guardInventory = new class_1277(6);
    public int kickTicks;
    public int shieldCoolDown;
    public int kickCoolDown;
    public boolean interacting;
    private int remainingPersistentAngerTime;
    private static final class_6019 angerTime = class_4802.method_24505((int)20, (int)39);
    private UUID persistentAngerTarget;
    private static final Map<class_1304, class_2960> EQUIPMENT_SLOT_ITEMS = (Map)class_156.method_654((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(class_1304.field_6173, GuardLootTables.GUARD_MAIN_HAND);
        slotItems.put(class_1304.field_6171, GuardLootTables.GUARD_OFF_HAND);
        slotItems.put(class_1304.field_6169, GuardLootTables.GUARD_HELMET);
        slotItems.put(class_1304.field_6174, GuardLootTables.GUARD_CHEST);
        slotItems.put(class_1304.field_6172, GuardLootTables.GUARD_LEGGINGS);
        slotItems.put(class_1304.field_6166, GuardLootTables.GUARD_FEET);
    });

    public GuardEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.guardInventory.method_5489((class_1265)this);
        this.method_5971();
    }

    public void method_5673(class_1304 slotIn, class_1799 stack) {
        super.method_5673(slotIn, stack);
        switch (slotIn) {
            case field_6174: {
                if (!this.guardInventory.method_5438(1).method_7960()) break;
                this.guardInventory.method_5447(1, (class_1799)((MobEntityAccessor)((Object)this)).armorItems().get(slotIn.method_5927()));
                break;
            }
            case field_6166: {
                if (!this.guardInventory.method_5438(3).method_7960()) break;
                this.guardInventory.method_5447(3, (class_1799)((MobEntityAccessor)((Object)this)).armorItems().get(slotIn.method_5927()));
                break;
            }
            case field_6169: {
                if (!this.guardInventory.method_5438(0).method_7960()) break;
                this.guardInventory.method_5447(0, (class_1799)((MobEntityAccessor)((Object)this)).armorItems().get(slotIn.method_5927()));
                break;
            }
            case field_6172: {
                if (!this.guardInventory.method_5438(2).method_7960()) break;
                this.guardInventory.method_5447(2, (class_1799)((MobEntityAccessor)((Object)this)).armorItems().get(slotIn.method_5927()));
                break;
            }
            case field_6173: {
                if (!this.guardInventory.method_5438(5).method_7960()) break;
                this.guardInventory.method_5447(5, (class_1799)((MobEntityAccessor)((Object)this)).armorItems().get(slotIn.method_5927()));
                break;
            }
            case field_6171: {
                if (!this.guardInventory.method_5438(4).method_7960()) break;
                this.guardInventory.method_5447(4, (class_1799)((MobEntityAccessor)((Object)this)).armorItems().get(slotIn.method_5927()));
            }
        }
    }

    public void method_5711(byte id) {
        if (id == 4) {
            this.kickTicks = 10;
        } else {
            super.method_5711(id);
        }
    }

    public boolean method_6062() {
        return this.interacting || super.method_6062();
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.method_5971();
        int type = GuardEntity.getRandomTypeForBiome((class_1936)world, this.method_24515());
        if (entityData instanceof GuardData) {
            type = ((GuardData)entityData).variantData;
            entityData = new GuardData(type);
        }
        this.setGuardVariant(type);
        this.method_5964(difficulty);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void method_5964(class_1266 difficulty) {
        for (class_1304 equipmentslottype : class_1304.values()) {
            for (class_1799 stack : this.getItemsFromLootTable(equipmentslottype)) {
                this.method_5673(equipmentslottype, stack);
            }
        }
        this.field_6187[class_1304.field_6173.method_5927()] = 100.0f;
        this.field_6187[class_1304.field_6171.method_5927()] = 100.0f;
    }

    protected void method_6087(class_1297 entity) {
        if (entity instanceof class_1314) {
            boolean attackTargets;
            class_1314 living = (class_1314)entity;
            boolean bl = attackTargets = living.method_5968() instanceof class_1646 || living.method_5968() instanceof class_1439 || living.method_5968() instanceof GuardEntity;
            if (attackTargets) {
                this.method_5980((class_1309)living);
            }
        }
        super.method_6087(entity);
    }

    public void setPatrolPos(class_2338 position) {
        this.field_6011.method_12778(GUARD_POS, Optional.ofNullable(position));
    }

    @Nullable
    public class_2338 getPatrolPos() {
        return ((Optional)this.field_6011.method_12789(GUARD_POS)).orElse(null);
    }

    protected class_3414 method_5994() {
        return class_3417.field_15175;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        if (this.method_6039()) {
            return class_3417.field_15150;
        }
        return class_3417.field_15139;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15225;
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        for (int i = 0; i < this.guardInventory.method_5439(); ++i) {
            class_1799 itemstack = this.guardInventory.method_5438(i);
            if (itemstack.method_7960() || class_1890.method_8221((class_1799)itemstack)) continue;
            this.method_5775(itemstack);
        }
    }

    public static int slotToInventoryIndex(class_1304 slot) {
        switch (slot) {
            case field_6174: {
                return 1;
            }
            case field_6166: {
                return 3;
            }
            case field_6169: {
                return 0;
            }
            case field_6172: {
                return 2;
            }
        }
        return 0;
    }

    public void method_5749(class_2487 nbt) {
        int i;
        UUID uuid;
        super.method_5749(nbt);
        UUID uUID = uuid = nbt.method_25928("Owner") ? nbt.method_25926("Owner") : null;
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                this.setOwnerId(null);
            }
        }
        this.setGuardVariant(nbt.method_10550("Type"));
        this.kickTicks = nbt.method_10550("KickTicks");
        this.setFollowing(nbt.method_10577("Following"));
        this.interacting = nbt.method_10577("Interacting");
        this.setEating(nbt.method_10577("Eating"));
        this.setPatrolling(nbt.method_10577("Patrolling"));
        this.setRunningToEat(nbt.method_10577("RunningToEat"));
        this.shieldCoolDown = nbt.method_10550("KickCooldown");
        this.kickCoolDown = nbt.method_10550("ShieldCooldown");
        if (nbt.method_10545("PatrolPosX")) {
            int x = nbt.method_10550("PatrolPosX");
            int y = nbt.method_10550("PatrolPosY");
            int z = nbt.method_10550("PatrolPosZ");
            this.field_6011.method_12778(GUARD_POS, Optional.ofNullable(new class_2338(x, y, z)));
        }
        class_2499 listnbt = nbt.method_10554("Inventory", 10);
        for (int i2 = 0; i2 < listnbt.size(); ++i2) {
            class_2487 compoundnbt = listnbt.method_10602(i2);
            int j = compoundnbt.method_10571("Slot") & 0xFF;
            this.guardInventory.method_5447(j, class_1799.method_7915((class_2487)compoundnbt));
        }
        if (nbt.method_10573("ArmorItems", 9)) {
            class_2499 armorItems = nbt.method_10554("ArmorItems", 10);
            for (i = 0; i < ((MobEntityAccessor)((Object)this)).armorItems().size(); ++i) {
                int index = GuardEntity.slotToInventoryIndex(class_1308.method_32326((class_1799)class_1799.method_7915((class_2487)armorItems.method_10602(i))));
                this.guardInventory.method_5447(index, class_1799.method_7915((class_2487)armorItems.method_10602(i)));
            }
        }
        if (nbt.method_10573("HandItems", 9)) {
            class_2499 handItems = nbt.method_10554("HandItems", 10);
            for (i = 0; i < ((MobEntityAccessor)((Object)this)).handItems().size(); ++i) {
                int handSlot = i == 0 ? 5 : 4;
                this.guardInventory.method_5447(handSlot, class_1799.method_7915((class_2487)handItems.method_10602(i)));
            }
        }
        if (!this.field_6002.method_8608()) {
            this.method_29512(this.field_6002, nbt);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Type", this.getGuardVariant());
        nbt.method_10569("KickTicks", this.kickTicks);
        nbt.method_10569("ShieldCooldown", this.shieldCoolDown);
        nbt.method_10569("KickCooldown", this.kickCoolDown);
        nbt.method_10556("Following", this.isFollowing());
        nbt.method_10556("Interacting", this.interacting);
        nbt.method_10556("Eating", this.isEating());
        nbt.method_10556("Patrolling", this.isPatrolling());
        nbt.method_10556("RunningToEat", this.isRunningToEat());
        if (this.getOwnerId() != null) {
            nbt.method_25927("Owner", this.getOwnerId());
        }
        class_2499 listnbt = new class_2499();
        for (int i = 0; i < this.guardInventory.method_5439(); ++i) {
            class_1799 itemstack = this.guardInventory.method_5438(i);
            class_2487 compoundnbt = new class_2487();
            compoundnbt.method_10567("Slot", (byte)i);
            itemstack.method_7953(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        nbt.method_10566("Inventory", (class_2520)listnbt);
        if (this.getPatrolPos() != null) {
            nbt.method_10569("PatrolPosX", this.getPatrolPos().method_10263());
            nbt.method_10569("PatrolPosY", this.getPatrolPos().method_10264());
            nbt.method_10569("PatrolPosZ", this.getPatrolPos().method_10260());
        }
        this.method_29512(this.field_6002, nbt);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_6011.method_12778(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public void setFollowing(boolean following) {
        this.field_6011.method_12778(FOLLOWING, (Object)following);
    }

    public void setEating(boolean eating) {
        this.field_6011.method_12778(EATING, (Object)eating);
    }

    public void setPatrolling(boolean patrolling) {
        this.field_6011.method_12778(PATROLLING, (Object)patrolling);
    }

    public boolean isRunningToEat() {
        return (Boolean)this.field_6011.method_12789(RUNNING_TO_EAT);
    }

    public void setRunningToEat(boolean running) {
        this.field_6011.method_12778(RUNNING_TO_EAT, (Object)running);
    }

    public UUID getOwnerId() {
        return ((Optional)this.field_6011.method_12789(OWNER_UNIQUE_ID)).orElse(null);
    }

    public int getGuardVariant() {
        return (Integer)this.field_6011.method_12789(GUARD_VARIANT);
    }

    public int getKickTicks() {
        return this.kickTicks;
    }

    public void setKicking(boolean kicking) {
        this.field_6011.method_12778(KICKING, (Object)kicking);
    }

    public boolean isFollowing() {
        return (Boolean)this.field_6011.method_12789(FOLLOWING);
    }

    public boolean isEating() {
        return (Boolean)this.field_6011.method_12789(EATING);
    }

    public boolean isPatrolling() {
        return (Boolean)this.field_6011.method_12789(PATROLLING);
    }

    public class_1799 getPickedResult(class_239 target) {
        return new class_1799((class_1935)GuardVillagers.GUARD_SPAWN_EGG.method_8389());
    }

    @Nullable
    public class_1309 getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null || uuid != null && this.field_6002.method_18470(uuid) != null && !this.field_6002.method_18470(uuid).method_6059(class_1294.field_18980) ? null : this.field_6002.method_18470(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean method_6121(class_1297 target) {
        if (this.isKicking()) {
            ((class_1309)target).method_6005(1.0, Math.sin(this.method_36454() * ((float)Math.PI / 180)), -Math.cos(this.method_36454() * ((float)Math.PI / 180)));
            this.kickTicks = 10;
            this.field_6002.method_8421((class_1297)this, (byte)4);
            this.method_5951(target, 90.0f, 90.0f);
        }
        class_1799 hand = this.method_6047();
        hand.method_7956(1, (class_1309)this, entity -> entity.method_20235(class_1304.field_6173));
        return super.method_6121(target);
    }

    public boolean isKicking() {
        return (Boolean)this.field_6011.method_12789(KICKING);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new KickGoal(this));
        this.field_6201.method_6277(0, (class_1352)new GuardEatFoodGoal(this));
        this.field_6201.method_6277(0, (class_1352)new RaiseShieldGoal(this));
        this.field_6201.method_6277(1, (class_1352)new GuardRunToEatGoal(this));
        this.field_6201.method_6277(1, (class_1352)new GuardSetRunningToEatGoal(this, 1.0));
        this.field_6201.method_6277(2, new RangedCrossbowAttackPassiveGoal<GuardEntity>(this, 1.0, 8.0f));
        this.field_6201.method_6277(2, new RangedBowAttackPassiveGoal<GuardEntity>(this, 0.5, 20, 15.0f));
        this.field_6201.method_6277(2, (class_1352)new GuardMeleeGoal(this, 0.8, true));
        this.field_6201.method_6277(3, (class_1352)new FollowHeroGoal(this));
        if (GuardVillagersConfig.get().GuardsRunFromPolarBears) {
            this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1456.class, 12.0f, 1.0, 1.2));
        }
        this.field_6201.method_6277(3, (class_1352)new class_4291((class_1314)this, 0.5, false));
        this.field_6201.method_6277(3, (class_1352)new class_5274((class_1314)this, 0.5));
        this.field_6201.method_6277(3, (class_1352)new class_1368((class_1314)this, 0.5, false, 4, () -> false));
        if (GuardVillagersConfig.get().GuardsOpenDoors) {
            this.field_6201.method_6277(3, (class_1352)new class_4255((class_1308)this, true){

                public void method_6269() {
                    this.field_6413.method_6104(class_1268.field_5808);
                    super.method_6269();
                }
            });
        }
        if (GuardVillagersConfig.get().GuardFormation) {
            this.field_6201.method_6277(5, (class_1352)new FollowShieldGuards(this));
        }
        if (GuardVillagersConfig.get().ClericHealing) {
            this.field_6201.method_6277(6, (class_1352)new RunToClericGoal(this));
        }
        if (GuardVillagersConfig.get().armorerRepairGuardArmor) {
            this.field_6201.method_6277(6, (class_1352)new ArmorerRepairGuardArmorGoal(this));
        }
        this.field_6201.method_6277(4, (class_1352)new WalkBackToCheckPointGoal(this, 0.5));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_3988.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 0.5));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6185.method_6277(5, (class_1352)new DefendVillageGuardGoal(this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1584.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[]{GuardEntity.class, class_1439.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[]{class_1308.class}));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1640.class, true));
        this.field_6185.method_6277(3, (class_1352)new HeroHurtByTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new HeroHurtTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1543.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1581.class, true));
        if (GuardVillagersConfig.get().AttackAllMobs) {
            this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1308.class, 5, true, true, mob -> mob instanceof class_1569 && !GuardVillagersConfig.get().MobBlackList.contains(mob.method_5820())));
        }
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, arg_0 -> ((GuardEntity)this).method_29515(arg_0)));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1642.class, true));
        this.field_6185.method_6277(4, (class_1352)new class_5398((class_1308)this, false));
    }

    public void method_6078(class_1282 source) {
        if ((this.field_6002.method_8407() == class_1267.field_5802 || this.field_6002.method_8407() == class_1267.field_5807) && source.method_5526() instanceof class_1642) {
            if (this.field_6002.method_8407() != class_1267.field_5807 && this.field_5974.nextBoolean()) {
                return;
            }
            class_1641 zombieguard = (class_1641)this.method_29243(class_1299.field_6054, true);
            zombieguard.method_5943((class_5425)this.field_6002, this.field_6002.method_8404(zombieguard.method_24515()), class_3730.field_16468, (class_1315)new class_1642.class_1644(false, true), null);
            if (!this.method_5701()) {
                this.field_6002.method_8444(null, 1026, this.method_24515(), 0);
            }
            this.method_31472();
        }
        super.method_6078(source);
    }

    protected void method_6040() {
        class_1268 interactionhand = this.method_6058();
        if (!this.field_6277.equals(this.method_5998(interactionhand))) {
            this.method_6075();
        } else if (!this.field_6277.method_7960() && this.method_6115()) {
            this.method_6098(this.field_6277, 16);
            if (!this.field_6277.method_19267()) {
                this.field_6277.method_7934(1);
            }
            this.method_6075();
        }
    }

    public class_1799 method_18866(class_1937 world, class_1799 stack) {
        if (stack.method_19267()) {
            this.method_6025(stack.method_7909().method_19264().method_19230());
        }
        super.method_18866(world, stack);
        world.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_19149, class_3419.field_15248, 0.5f, world.field_9229.nextFloat() * 0.1f + 0.9f);
        this.setEating(false);
        return stack;
    }

    public void method_6007() {
        if (this.kickTicks > 0) {
            --this.kickTicks;
        }
        if (this.kickCoolDown > 0) {
            --this.kickCoolDown;
        }
        if (this.shieldCoolDown > 0) {
            --this.shieldCoolDown;
        }
        if (this.method_6032() < this.method_6063() && this.field_6012 % 200 == 0) {
            this.method_6025(GuardVillagersConfig.get().amountOfHealthRegenerated);
        }
        if (!this.field_6002.method_8608()) {
            this.method_29510((class_3218)this.field_6002, true);
        }
        this.method_6119();
        super.method_6007();
    }

    public class_4048 method_18377(class_4050 poseIn) {
        return SIZE_BY_POSE.getOrDefault(poseIn, class_4048.method_18384((float)0.6f, (float)1.95f));
    }

    public float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        if (poseIn == class_4050.field_18081) {
            return 1.4f;
        }
        return super.method_18394(poseIn, sizeIn);
    }

    protected void method_6090(class_1309 entityIn) {
        super.method_6090(entityIn);
        if (entityIn.method_6047().method_7909() instanceof class_1743) {
            this.disableShield(true);
        }
    }

    protected void method_6056(float damage) {
        if (this.canPerformAction(this.field_6277, ToolActions.SHIELD_BLOCK) && damage >= 3.0f) {
            int i = 1 + class_3532.method_15375((float)damage);
            class_1268 hand = this.method_6058();
            this.field_6277.method_7956(i, (class_1309)this, entity -> entity.method_20236(hand));
            if (this.field_6277.method_7960()) {
                if (hand == class_1268.field_5808) {
                    this.method_5673(class_1304.field_6173, class_1799.field_8037);
                } else {
                    this.method_5673(class_1304.field_6171, class_1799.field_8037);
                }
                this.field_6277 = class_1799.field_8037;
                this.method_5783(class_3417.field_15239, 0.8f, 0.8f + this.field_6002.field_9229.nextFloat() * 0.4f);
            }
        }
    }

    public boolean canPerformAction(class_1799 stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction);
    }

    public void method_6019(class_1268 hand) {
        class_1799 itemstack = this.method_5998(hand);
        if (this.canPerformAction(itemstack, ToolActions.SHIELD_BLOCK)) {
            class_1324 modifiableattributeinstance = this.method_5996(class_5134.field_23719);
            modifiableattributeinstance.method_6202(USE_ITEM_SPEED_PENALTY);
            modifiableattributeinstance.method_26835(USE_ITEM_SPEED_PENALTY);
        }
        super.method_6019(hand);
    }

    public void method_6075() {
        if (this.method_5996(class_5134.field_23719).method_6196(USE_ITEM_SPEED_PENALTY)) {
            this.method_5996(class_5134.field_23719).method_6202(USE_ITEM_SPEED_PENALTY);
        }
        super.method_6075();
    }

    public void disableShield(boolean increase) {
        float chance = 0.25f + (float)class_1890.method_8234((class_1309)this) * 0.05f;
        if (increase) {
            chance = (float)((double)chance + 0.75);
        }
        if (this.field_5974.nextFloat() < chance) {
            this.shieldCoolDown = 100;
            this.method_6075();
            this.field_6002.method_8421((class_1297)this, (byte)30);
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(GUARD_VARIANT, (Object)0);
        this.field_6011.method_12784(DATA_CHARGING_STATE, (Object)false);
        this.field_6011.method_12784(KICKING, (Object)false);
        this.field_6011.method_12784(OWNER_UNIQUE_ID, Optional.empty());
        this.field_6011.method_12784(EATING, (Object)false);
        this.field_6011.method_12784(FOLLOWING, (Object)false);
        this.field_6011.method_12784(GUARD_POS, Optional.empty());
        this.field_6011.method_12784(PATROLLING, (Object)false);
        this.field_6011.method_12784(RUNNING_TO_EAT, (Object)false);
    }

    public static int getRandomTypeForBiome(class_1936 world, class_2338 pos) {
        class_3854 type = class_3854.method_16930((Optional)world.method_31081(pos));
        if (type == class_3854.field_17075) {
            return 6;
        }
        if (type == class_3854.field_17077) {
            return 5;
        }
        if (type == class_3854.field_17072) {
            return 4;
        }
        if (type == class_3854.field_17076) {
            return 3;
        }
        if (type == class_3854.field_17074) {
            return 2;
        }
        if (type == class_3854.field_17071) {
            return 1;
        }
        return 0;
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    public List<class_1799> getItemsFromLootTable(class_1304 slot) {
        if (EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            class_52 loot = this.field_6002.method_8503().method_3857().method_367(EQUIPMENT_SLOT_ITEMS.get(slot));
            class_47.class_48 lootcontext$builder = new class_47.class_48((class_3218)this.field_6002).method_312(class_181.field_1226, (Object)this).method_311(this.method_6051());
            return loot.method_319(lootcontext$builder.method_309(GuardLootTables.SLOT));
        }
        return null;
    }

    public void method_7110(boolean charging) {
    }

    public void method_18811(class_1309 target, class_1799 crossbow, class_1676 projectile, float multiShotSpray) {
        this.method_24652((class_1309)this, target, projectile, multiShotSpray, 1.6f);
    }

    public void method_5980(class_1309 entity) {
        if (entity instanceof GuardEntity || entity instanceof class_1646 || entity instanceof class_1439) {
            return;
        }
        super.method_5980(entity);
    }

    protected void method_6060(class_1309 entityIn) {
        if (this.isKicking()) {
            this.setKicking(false);
        }
        super.method_6060((class_1309)this);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        boolean inventoryRequirements;
        boolean configValues = !GuardVillagersConfig.get().giveGuardStuffHOTV || !GuardVillagersConfig.get().setGuardPatrolHotv || player.method_6059(class_1294.field_18980) && GuardVillagersConfig.get().giveGuardStuffHOTV || player.method_6059(class_1294.field_18980) && GuardVillagersConfig.get().setGuardPatrolHotv || player.method_6059(class_1294.field_18980) && GuardVillagersConfig.get().giveGuardStuffHOTV && GuardVillagersConfig.get().setGuardPatrolHotv;
        boolean bl = inventoryRequirements = !player.method_21823() && this.field_5952;
        if (configValues && inventoryRequirements && this.method_5968() != player && this.method_6034()) {
            this.openGui(player);
            return class_1269.method_29236((boolean)this.field_6002.method_8608());
        }
        return super.method_5992(player, hand);
    }

    public void openGui(class_1657 player) {
        if (player.field_6002 != null && !this.field_6002.method_8608()) {
            this.interacting = true;
            player.method_17355((class_3908)new GuardScreenHandlerFactory());
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23717, 20.0);
    }

    public void method_7105(class_1309 target, float pullProgress) {
        this.shieldCoolDown = 8;
        if (this.method_6047().method_7909() instanceof class_1764) {
            this.method_24654((class_1309)this, 6.0f);
        }
        if (this.method_6047().method_7909() instanceof class_1753) {
            int punchLevel;
            class_1799 itemStack = this.method_18808(this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8102)));
            class_1799 hand = this.method_6030();
            class_1665 persistentProjectileEntity = class_1675.method_18813((class_1309)this, (class_1799)itemStack, (float)pullProgress);
            int powerLevel = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)itemStack);
            if (powerLevel > 0) {
                persistentProjectileEntity.method_7438(persistentProjectileEntity.method_7448() + (double)powerLevel * 0.5 + 0.5);
            }
            if ((punchLevel = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)itemStack)) > 0) {
                persistentProjectileEntity.method_7449(punchLevel);
            }
            if (class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)itemStack) > 0) {
                persistentProjectileEntity.method_20803(100);
            }
            double d = target.method_23317() - this.method_23317();
            double e = target.method_23323(0.3333333333333333) - persistentProjectileEntity.method_23318();
            double f = target.method_23321() - this.method_23321();
            double g = Math.sqrt(d * d + f * f);
            persistentProjectileEntity.method_7485(d, e + g * (double)0.2f, f, 1.6f, (float)(14 - this.field_6002.method_8407().method_5461() * 4));
            this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().nextFloat() * 0.4f + 0.8f));
            this.field_6002.method_8649((class_1297)persistentProjectileEntity);
            hand.method_7956(1, (class_1309)this, entity -> entity.method_20235(class_1304.field_6173));
        }
    }

    public class_1799 method_18808(class_1799 shootable) {
        if (shootable.method_7909() instanceof class_1811) {
            Predicate predicate = ((class_1811)shootable.method_7909()).method_20310();
            class_1799 itemstack = class_1811.method_18815((class_1309)this, (Predicate)predicate);
            return itemstack.method_7960() ? new class_1799((class_1935)class_1802.field_8107) : itemstack;
        }
        return class_1799.field_8037;
    }

    public boolean method_18395(class_1309 target) {
        return !GuardVillagersConfig.get().MobBlackList.contains(target.method_5820()) && !target.method_6059(class_1294.field_18980) && !this.isOwner(target) && !(target instanceof class_1646) && !(target instanceof class_1439) && !(target instanceof GuardEntity) && super.method_18395(target);
    }

    public boolean isOwner(class_1309 entityIn) {
        return entityIn == this.getOwner();
    }

    public void method_5842() {
        super.method_5842();
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof class_1314) {
            class_1314 creatureEntity = (class_1314)class_12972;
            this.field_6283 = creatureEntity.field_6283;
        }
    }

    public void method_24651() {
        this.field_6278 = 0;
    }

    public int method_29507() {
        return this.remainingPersistentAngerTime;
    }

    public void method_29514(int ticks) {
        this.remainingPersistentAngerTime = ticks;
    }

    @Nullable
    public UUID method_29508() {
        return this.persistentAngerTarget;
    }

    public void method_29513(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void method_29509() {
        this.method_29514(angerTime.method_35008(this.field_5974));
    }

    public void method_5453(class_1263 sender) {
    }

    protected void method_6105(class_1282 damageSource, float damage) {
        if (damage >= 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            for (int i = 0; i < this.guardInventory.method_5439(); ++i) {
                class_1799 itemstack = this.guardInventory.method_5438(i);
                if (damageSource.method_5534() && itemstack.method_7909().method_24358() || !(itemstack.method_7909() instanceof class_1738)) continue;
                int j = i;
                itemstack.method_7956((int)damage, (class_1309)this, p_214023_1_ -> p_214023_1_.method_20235(class_1304.method_20234((class_1304.class_1305)class_1304.class_1305.field_6178, (int)j)));
            }
        }
    }

    public void method_5800(class_3218 serverWorld, class_1538 lightningEntity) {
        if (serverWorld.method_8407() != class_1267.field_5801) {
            class_1640 witchEntity = (class_1640)class_1299.field_6145.method_5883((class_1937)serverWorld);
            if (witchEntity == null) {
                return;
            }
            witchEntity.method_5719((class_1297)this);
            witchEntity.method_5943((class_5425)serverWorld, this.field_6002.method_8404(witchEntity.method_24515()), class_3730.field_16468, null, null);
            witchEntity.method_5977(this.method_5987());
            witchEntity.method_5665(this.method_5797());
            witchEntity.method_5880(this.method_5807());
            witchEntity.method_5971();
            serverWorld.method_8649((class_1297)witchEntity);
            this.method_31472();
        } else {
            super.method_5800(serverWorld, lightningEntity);
        }
    }

    public void setGuardVariant(int typeId) {
        this.field_6011.method_12778(GUARD_VARIANT, (Object)typeId);
    }

    public static class GuardData
    implements class_1315 {
        public final int variantData;

        public GuardData(int type) {
            this.variantData = type;
        }
    }

    public static class GuardMeleeGoal
    extends class_1366 {
        public final GuardEntity guard;

        public GuardMeleeGoal(GuardEntity guard, double speedIn, boolean useLongMemory) {
            super((class_1314)guard, speedIn, useLongMemory);
            this.guard = guard;
        }

        public boolean method_6264() {
            return !(this.guard.method_6047().method_7909() instanceof class_1764) && this.guard.method_5968() != null && !this.guard.isEating() && super.method_6264();
        }

        public boolean method_6266() {
            return super.method_6266() && this.guard.method_5968() != null && !(this.guard.method_6047().method_7909() instanceof class_1764);
        }

        public void method_6268() {
            class_1309 target = this.guard.method_5968();
            if (target != null) {
                if ((double)target.method_5739((class_1297)this.guard) <= 3.0 && !this.guard.method_6039()) {
                    this.guard.method_5962().method_6243(-2.0f, 0.0f);
                    this.guard.method_5951((class_1297)target, 30.0f, 30.0f);
                }
                if (((MeleeAttackGoalAccessor)((Object)this)).path() != null && (double)target.method_5739((class_1297)this.guard) <= 2.0) {
                    this.guard.method_5942().method_6340();
                }
                super.method_6268();
            }
        }

        protected double method_6289(class_1309 attackTarget) {
            return super.method_6289(attackTarget) * 3.55;
        }

        protected void method_6288(class_1309 enemy, double distToEnemySqr) {
            double d0 = this.method_6289(enemy);
            if (distToEnemySqr <= d0 && this.method_28348() <= 0) {
                this.method_28346();
                this.guard.method_6075();
                if (this.guard.shieldCoolDown == 0) {
                    this.guard.shieldCoolDown = 8;
                }
                this.guard.method_6104(class_1268.field_5808);
                this.guard.method_6121((class_1297)enemy);
            }
        }
    }

    public static class FollowHeroGoal
    extends class_1352 {
        public final GuardEntity guard;

        public FollowHeroGoal(GuardEntity mob) {
            this.guard = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public void method_6269() {
            super.method_6269();
            if (this.guard.getOwner() != null) {
                this.guard.method_5942().method_6335((class_1297)this.guard.getOwner(), 0.9);
            }
        }

        public void method_6268() {
            if (this.guard.getOwner() != null) {
                this.guard.method_5942().method_6335((class_1297)this.guard.getOwner(), 0.9);
            }
        }

        public boolean method_6266() {
            return this.guard.isFollowing() && this.method_6264();
        }

        public boolean method_6264() {
            List list = this.guard.field_6002.method_18467(class_1657.class, this.guard.method_5829().method_1014(10.0));
            if (!list.isEmpty()) {
                for (class_1657 mob : list) {
                    if (mob.method_5767() || !mob.method_6059(class_1294.field_18980)) continue;
                    this.guard.setOwnerId(mob.method_5667());
                    return this.guard.isFollowing();
                }
            }
            return false;
        }

        public void method_6270() {
            this.guard.method_5942().method_6340();
            if (this.guard.getOwner() != null && !this.guard.getOwner().method_6059(class_1294.field_18980)) {
                this.guard.setOwnerId(null);
                this.guard.setFollowing(false);
            }
        }
    }

    public static class DefendVillageGuardGoal
    extends class_1405 {
        private final GuardEntity guard;
        private class_1309 villageAggressorTarget;

        public DefendVillageGuardGoal(GuardEntity guardIn) {
            super((class_1308)guardIn, false, true);
            this.guard = guardIn;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_238 axisalignedbb = this.guard.method_5829().method_1009(10.0, 8.0, 10.0);
            List list = this.guard.field_6002.method_18467(class_1646.class, axisalignedbb);
            List list1 = this.guard.field_6002.method_18467(class_1657.class, axisalignedbb);
            for (class_1646 livingentity : list) {
                for (class_1657 playerentity : list1) {
                    int i = livingentity.method_20594(playerentity);
                    if (i > -100) continue;
                    this.villageAggressorTarget = playerentity;
                }
            }
            return this.villageAggressorTarget != null && !this.villageAggressorTarget.method_6059(class_1294.field_18980) && !this.villageAggressorTarget.method_7325() && !((class_1657)this.villageAggressorTarget).method_7337();
        }

        public void method_6269() {
            this.guard.method_5980(this.villageAggressorTarget);
            super.method_6269();
        }
    }

    public static class ToolActions {
        public static final ToolAction SHIELD_BLOCK = ToolAction.get("shield_block");
        public static final Set<ToolAction> DEFAULT_SHIELD_ACTIONS = ToolActions.of(SHIELD_BLOCK);

        private static Set<ToolAction> of(ToolAction ... actions) {
            return Stream.of(actions).collect(Collectors.toCollection(Sets::newIdentityHashSet));
        }
    }

    private class GuardScreenHandlerFactory
    implements ExtendedScreenHandlerFactory {
        private GuardScreenHandlerFactory() {
        }

        private GuardEntity guard() {
            return GuardEntity.this;
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            buf.method_10804(this.guard().method_5628());
        }

        public class_2561 method_5476() {
            return this.guard().method_5476();
        }

        public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
            class_1277 guardInv = this.guard().guardInventory;
            return new GuardVillagerScreenHandler(syncId, inv, (class_1263)guardInv, this.guard());
        }
    }
}

