/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.cloth.impl.datagen;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import me.shedaniel.cloth.api.datagen.v1.DataGeneratorHandler;
import me.shedaniel.cloth.api.datagen.v1.TagData;
import net.minecraft.class_1299;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TagDataProvider
implements class_2405,
TagData {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataGeneratorHandler handler;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Table<TagType, class_2960, Builder<?>> tagBuilders = HashBasedTable.create();

    public TagDataProvider(DataGeneratorHandler handler) {
        this.handler = handler;
        this.handler.install(this);
    }

    @Override
    public TagData.TagBuilder<class_2248> block(class_2960 tag) {
        Builder builder = (Builder)this.tagBuilders.get((Object)TagType.BLOCKS, (Object)tag);
        if (builder != null) {
            return builder;
        }
        this.tagBuilders.put((Object)TagType.BLOCKS, (Object)tag, new Builder(TagType.BLOCKS, tag));
        return this.block(tag);
    }

    @Override
    public TagData.TagBuilder<class_1935> item(class_2960 tag) {
        Builder builder = (Builder)this.tagBuilders.get((Object)TagType.ITEMS, (Object)tag);
        if (builder != null) {
            return builder;
        }
        this.tagBuilders.put((Object)TagType.ITEMS, (Object)tag, new Builder(TagType.ITEMS, tag));
        return this.item(tag);
    }

    @Override
    public TagData.TagBuilder<class_1299<?>> entity(class_2960 tag) {
        Builder builder = (Builder)this.tagBuilders.get((Object)TagType.ENTITY_TYPES, (Object)tag);
        if (builder != null) {
            return builder;
        }
        this.tagBuilders.put((Object)TagType.ENTITY_TYPES, (Object)tag, new Builder(TagType.ENTITY_TYPES, tag));
        return this.entity(tag);
    }

    @Override
    public TagData.TagBuilder<class_3611> fluid(class_2960 tag) {
        Builder builder = (Builder)this.tagBuilders.get((Object)TagType.FLUIDS, (Object)tag);
        if (builder != null) {
            return builder;
        }
        this.tagBuilders.put((Object)TagType.FLUIDS, (Object)tag, new Builder(TagType.FLUIDS, tag));
        return this.fluid(tag);
    }

    public void method_10319(class_2408 cache) throws IOException {
        HashMap map = Maps.newHashMap();
        this.tagBuilders.rowMap().forEach((tagType, tagMap) -> tagMap.forEach((identifier, builder) -> {
            builder.sort();
            JsonObject jsonObject = builder.method_26788();
            Path path = this.getOutput((TagType)((Object)tagType), (class_2960)identifier);
            try {
                String string = GSON.toJson((JsonElement)jsonObject);
                String string2 = field_11280.hashUnencodedChars((CharSequence)string).toString();
                if (!Objects.equals(cache.method_10323(path), string2) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedWriter.write(string);
                    }
                }
                cache.method_10325(path, string2);
            }
            catch (IOException var24) {
                LOGGER.error("Couldn't save tags to {}", (Object)path, (Object)var24);
            }
        }));
    }

    private Path getOutput(TagType tagType, class_2960 identifier) {
        return this.handler.getOutput().resolve("data/" + identifier.method_12836() + "/tags/" + tagType.name().toLowerCase(Locale.ROOT) + "/" + identifier.method_12832() + ".json");
    }

    public String method_10321() {
        return this.getClass().getSimpleName();
    }

    static enum TagType {
        BLOCKS((class_2378<?>)class_2378.field_11146),
        ITEMS((class_2378<?>)class_2378.field_11142),
        ENTITY_TYPES((class_2378<?>)class_2378.field_11145),
        FLUIDS((class_2378<?>)class_2378.field_11154);

        class_2378 registry;
        Comparator<Integer> objectComparator = Comparator.nullsLast(Integer::compare);
        Comparator<class_3494.class_5145> comparator = (o1, o2) -> {
            boolean isTag2;
            class_3494.class_3496 entry1 = o1.method_27067();
            class_3494.class_3496 entry2 = o2.method_27067();
            boolean isTag1 = entry1 instanceof class_3494.class_3497 || entry1 instanceof class_3494.class_5480;
            boolean bl = isTag2 = entry2 instanceof class_3494.class_3497 || entry2 instanceof class_3494.class_5480;
            if (isTag1 && isTag2) {
                return entry1.toString().compareTo(entry2.toString());
            }
            if (isTag1) {
                return 1;
            }
            if (isTag2) {
                return -1;
            }
            Integer first = this.registry.method_17966(new class_2960(this.stripOptional(entry1.toString()))).map(arg_0 -> ((class_2378)this.registry).method_10206(arg_0)).orElse(null);
            Integer second = this.registry.method_17966(new class_2960(this.stripOptional(entry2.toString()))).map(arg_0 -> ((class_2378)this.registry).method_10206(arg_0)).orElse(null);
            return this.objectComparator.compare(first, second);
        };

        private TagType(class_2378<?> registry) {
            this.registry = registry;
        }

        private String stripOptional(String s) {
            if (s.endsWith("?")) {
                return s.substring(0, s.length() - 1);
            }
            return s;
        }
    }

    private static class Builder<T>
    extends class_3494.class_3495
    implements TagData.TagBuilder<T> {
        private final TagType tagType;
        private final class_2960 identifier;

        public Builder(TagType tagType, class_2960 identifier) {
            this.tagType = tagType;
            this.identifier = identifier;
        }

        @Override
        public class_2960 getId() {
            return this.identifier;
        }

        @Override
        public TagData.TagBuilder<T> append(boolean optional, class_2960 value) {
            this.method_27065((class_3494.class_3496)(optional ? new class_3494.class_5479(value) : new class_3494.class_5122(value)), "Datagen");
            return this;
        }

        @Override
        public TagData.TagBuilder<T> append(boolean optional, T value) {
            Object object = value;
            if (value instanceof class_1935 && this.tagType == TagType.ITEMS) {
                object = ((class_1935)value).method_8389();
            }
            return this.append(optional, (T)((class_5321)this.tagType.registry.method_29113(object).get()).method_29177());
        }

        @Override
        public TagData.TagBuilder<T> appendTag(boolean optional, class_2960 tag) {
            this.method_27065((class_3494.class_3496)(optional ? new class_3494.class_5480(tag) : new class_3494.class_3497(tag)), "Datagen");
            return this;
        }

        private void sort() {
            this.field_23688.sort(this.tagType.comparator);
        }
    }
}

