/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.cloth.impl.datagen;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Supplier;
import me.shedaniel.cloth.api.datagen.v1.BlockStateDefinitionData;
import me.shedaniel.cloth.api.datagen.v1.DataGeneratorHandler;
import me.shedaniel.cloth.api.datagen.v1.ModelStateData;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelStateDataProvider
implements class_2405,
ModelStateData,
BlockStateDefinitionData {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataGeneratorHandler handler;
    private final Map<class_2960, Supplier<JsonElement>> models = Maps.newHashMap();
    private final Map<class_2960, Supplier<JsonElement>> states = Maps.newHashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ModelStateDataProvider(DataGeneratorHandler handler) {
        this.handler = handler;
        this.handler.install(this);
    }

    @Override
    public void addModel(class_2960 identifier, Supplier<JsonElement> element) {
        this.models.put(identifier, element);
    }

    @Override
    public void addState(class_2960 identifier, Supplier<JsonElement> element) {
        this.states.put(identifier, element);
    }

    public void method_10319(class_2408 cache) throws IOException {
        Path path = this.handler.getOutput();
        this.states.forEach((identifier, jsonElement) -> {
            Path outputPath = ModelStateDataProvider.getStateOutput(path, identifier);
            try {
                class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)((JsonElement)jsonElement.get()), (Path)outputPath);
            }
            catch (IOException var6) {
                LOGGER.error("Couldn't save block state {}", (Object)outputPath, (Object)var6);
            }
        });
        this.models.forEach((identifier, jsonElement) -> {
            Path outputPath = ModelStateDataProvider.getModelOutput(path, identifier);
            try {
                class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)((JsonElement)jsonElement.get()), (Path)outputPath);
            }
            catch (IOException var6) {
                LOGGER.error("Couldn't save block state {}", (Object)outputPath, (Object)var6);
            }
        });
    }

    private static Path getModelOutput(Path rootOutput, class_2960 id) {
        return rootOutput.resolve("assets/" + id.method_12836() + "/models/" + id.method_12832() + ".json");
    }

    private static Path getStateOutput(Path rootOutput, class_2960 id) {
        return rootOutput.resolve("assets/" + id.method_12836() + "/blockstates/" + id.method_12832() + ".json");
    }

    public String method_10321() {
        return this.getClass().getSimpleName();
    }
}

