/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.cloth.impl.datagen;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import me.shedaniel.cloth.api.datagen.v1.DataGeneratorHandler;
import me.shedaniel.cloth.api.datagen.v1.LootTableData;
import net.minecraft.class_176;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_60;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableDataProvider
implements class_2405,
LootTableData {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataGeneratorHandler handler;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public final Table<class_176, class_2960, class_52.class_53> lootTables = HashBasedTable.create();

    public LootTableDataProvider(DataGeneratorHandler handler) {
        this.handler = handler;
        this.handler.install(this);
    }

    @Override
    public void register(class_176 type, class_2960 identifier, class_52.class_53 lootTable) {
        this.lootTables.put((Object)type, (Object)identifier, (Object)lootTable);
    }

    public void method_10319(class_2408 cache) throws IOException {
        Path path = this.handler.getOutput();
        HashMap map = Maps.newHashMap();
        this.lootTables.rowMap().forEach((type, tableMap) -> tableMap.forEach((identifier, builder) -> {
            if (map.put(identifier, builder.method_334(type).method_338()) != null) {
                throw new IllegalStateException("Duplicate loot table " + identifier);
            }
        }));
        map.forEach((identifier, lootTable) -> {
            Path outputPath = LootTableDataProvider.getOutput(path, identifier);
            try {
                class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)class_60.method_372((class_52)lootTable), (Path)outputPath);
            }
            catch (IOException var6) {
                LOGGER.error("Couldn't save loot table {}", (Object)outputPath, (Object)var6);
            }
        });
    }

    private static Path getOutput(Path rootOutput, class_2960 lootTableId) {
        return rootOutput.resolve("data/" + lootTableId.method_12836() + "/loot_tables/" + lootTableId.method_12832() + ".json");
    }

    public String method_10321() {
        return this.getClass().getSimpleName();
    }
}

