/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.cammiesminecarttweaks.mixin;

import dev.cammiescorner.cammiesminecarttweaks.MinecartTweaks;
import dev.cammiescorner.cammiesminecarttweaks.packets.SyncChainedMinecartPacket;
import dev.cammiescorner.cammiesminecarttweaks.utils.Linkable;
import java.util.HashSet;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1688.class})
public abstract class AbstractMinecartEntityMixin
extends class_1297
implements Linkable {
    @Unique
    private class_1688 linkedParent;
    @Unique
    private class_1688 linkedChild;
    @Unique
    private UUID parentUuid;
    @Unique
    private UUID childUuid;

    @Shadow
    public abstract class_2350 method_5755();

    public AbstractMinecartEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"getMaxOffRailSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    public void minecarttweaks$increaseSpeed(CallbackInfoReturnable<Double> info) {
        if (this.getLinkedParent() != null) {
            info.setReturnValue((Object)this.getLinkedParent().method_7504());
        } else {
            info.setReturnValue((Object)MinecartTweaks.getConfig().getOtherMinecartSpeed());
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void minecarttweaks$tick(CallbackInfo info) {
        block14: {
            block13: {
                if (this.field_6002.method_8608()) break block13;
                PlayerLookup.tracking((class_1297)this).forEach(player -> SyncChainedMinecartPacket.send((class_1657)player, this.linkedParent, (class_1688)this));
                if (this.getLinkedParent() == null) break block14;
                double distance = this.getLinkedParent().method_5739((class_1297)this) - 1.0f;
                if (distance <= 3.0) {
                    class_243 direction = this.getLinkedParent().method_19538().method_1020(this.method_19538()).method_1029();
                    if (distance > 1.0) {
                        class_243 parentVelocity = this.getLinkedParent().method_18798();
                        if (parentVelocity.method_1033() == 0.0) {
                            this.method_18799(direction.method_1021(0.05));
                        } else {
                            this.method_18799(direction.method_1021(parentVelocity.method_1033()));
                            this.method_18799(this.method_18798().method_1021(distance));
                        }
                    } else if (distance < 0.8) {
                        this.method_18799(direction.method_1021(-0.05));
                    } else {
                        this.method_18799(class_243.field_1353);
                    }
                } else {
                    ((Linkable)this.getLinkedParent()).setLinkedChild(null);
                    this.setLinkedParent(null);
                    this.method_5775(new class_1799((class_1935)class_1802.field_23983));
                    return;
                }
                if (this.getLinkedParent().method_31481()) {
                    this.setLinkedParent(null);
                }
                if (this.getLinkedChild() == null || !this.getLinkedChild().method_31481()) break block14;
                this.setLinkedChild(null);
                break block14;
            }
            if (MinecartTweaks.getConfig().clientTweaks.playerViewIsLocked) {
                class_243 directionVec = this.method_18798().method_1029();
                if (this.method_18798().method_1033() > MinecartTweaks.getConfig().getOtherMinecartSpeed() * 0.5) {
                    float yaw = (float)class_3532.method_15338((double)(Math.toDegrees(Math.atan2(directionVec.method_10215(), directionVec.method_10216())) - 90.0));
                    for (class_1297 passenger : this.method_5685()) {
                        float steps;
                        float wantedYaw = class_3532.method_15393((float)(class_3532.method_20306((float)passenger.method_36454(), (float)yaw, (float)MinecartTweaks.getConfig().clientTweaks.maxViewAngle) - passenger.method_36454()));
                        if (wantedYaw >= (steps = Math.abs(wantedYaw) / 5.0f)) {
                            passenger.method_36456(passenger.method_36454() + steps);
                        }
                        if (!(wantedYaw <= -steps)) continue;
                        passenger.method_36456(passenger.method_36454() - steps);
                    }
                }
            }
        }
    }

    @Inject(method={"dropItems"}, at={@At(value="HEAD")})
    public void minecarttweaks$dropChain(class_1282 damageSource, CallbackInfo info) {
        if (this.getLinkedParent() != null || this.getLinkedChild() != null) {
            this.method_5775(new class_1799((class_1935)class_1802.field_23983));
        }
    }

    @Inject(method={"collidesWith"}, at={@At(value="HEAD")}, cancellable=true)
    public void minecarttweaks$damageEntities(class_1297 other, CallbackInfoReturnable<Boolean> info) {
        class_1309 living;
        float damage;
        if (other instanceof class_1688) {
            class_1688 minecart = (class_1688)other;
            if (this.getLinkedParent() != null && !this.getLinkedParent().equals((Object)minecart)) {
                minecart.method_18799(this.method_18798());
            }
        }
        if ((damage = MinecartTweaks.getConfig().serverTweaks.minecartDamage) > 0.0f && !this.field_6002.method_8608() && other instanceof class_1309 && (living = (class_1309)other).method_5805() && !living.method_5765() && this.method_18798().method_1033() > 1.5) {
            living.method_5643(MinecartTweaks.minecart(this), damage);
            class_243 knockback = living.method_18798().method_1031(this.method_18798().method_10216() * 0.9, this.method_18798().method_1033() * 0.2, this.method_18798().method_10215() * 0.9);
            living.method_18799(knockback);
            living.field_6007 = true;
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    public void minecarttweaks$readNbt(class_2487 nbt, CallbackInfo info) {
        if (nbt.method_10545("ParentUuid")) {
            this.parentUuid = nbt.method_25926("ParentUuid");
        }
        if (nbt.method_10545("ChildUuid")) {
            this.childUuid = nbt.method_25926("ChildUuid");
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="HEAD")})
    public void minecarttweaks$writeNbt(class_2487 nbt, CallbackInfo info) {
        if (this.getLinkedParent() != null) {
            nbt.method_25927("ParentUuid", this.getLinkedParent().method_5667());
        }
        if (this.getLinkedChild() != null) {
            nbt.method_25927("ChildUuid", this.getLinkedChild().method_5667());
        }
    }

    @Redirect(method={"moveOnRail"}, at=@At(value="INVOKE", target="Ljava/lang/Math;min(DD)D"))
    private double minecarttweaks$uncapSpeed(double garbo, double uncappedSpeed) {
        return uncappedSpeed;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (MinecartTweaks.getConfig().serverTweaks.canLinkMinecarts) {
            class_1799 stack = player.method_5998(hand);
            if (player.method_5715() && stack.method_31574(class_1802.field_23983) && this.getLinkedChild() == null) {
                class_1937 class_19372 = this.field_6002;
                if (class_19372 instanceof class_3218) {
                    class_3218 server = (class_3218)class_19372;
                    class_2487 nbt = stack.method_7948();
                    if (nbt.method_10545("ParentEntity")) {
                        class_1297 class_12972;
                        if (!this.method_5667().equals(nbt.method_25926("ParentEntity")) && (class_12972 = server.method_14190(nbt.method_25926("ParentEntity"))) instanceof class_1688) {
                            class_1688 parent = (class_1688)class_12972;
                            Linkable linkable = (Linkable)parent;
                            HashSet<Linkable> train = new HashSet<Linkable>();
                            train.add(linkable);
                            while ((linkable = (Linkable)linkable.getLinkedParent()) instanceof Linkable && !train.contains(linkable)) {
                                train.add(linkable);
                            }
                            if (train.contains(this)) {
                                player.method_7353((class_2561)new class_2588("minecarttweaks.cant_link_to_engine").method_27692(class_124.field_1061), true);
                            } else {
                                if (this.getLinkedParent() != null) {
                                    ((Linkable)this.getLinkedParent()).setLinkedChild(null);
                                }
                                this.setLinkedParent(parent);
                                ((Linkable)parent).setLinkedChild((class_1688)this);
                            }
                        } else {
                            nbt.method_10551("ParentEntity");
                            if (nbt.method_33133()) {
                                stack.method_7980(null);
                            }
                        }
                        this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_24063, class_3419.field_15254, 1.0f, 1.0f);
                        if (!player.method_7337()) {
                            stack.method_7934(1);
                        }
                        nbt.method_10551("ParentEntity");
                        if (nbt.method_33133()) {
                            stack.method_7980(null);
                        }
                    } else {
                        nbt.method_25927("ParentEntity", this.method_5667());
                        this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_24062, class_3419.field_15254, 1.0f, 1.0f);
                    }
                }
                return class_1269.method_29236((boolean)true);
            }
        }
        return super.method_5688(player, hand);
    }

    @Override
    public class_1688 getLinkedParent() {
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            if (this.linkedParent == null && this.parentUuid != null && (class_19372 = server.method_14190(this.parentUuid)) instanceof class_1688) {
                class_1688 parent = (class_1688)class_19372;
                this.setLinkedParent(parent);
            }
        }
        return this.linkedParent;
    }

    @Override
    public void setLinkedParent(class_1688 parent) {
        this.linkedParent = parent;
        if (parent == null) {
            this.parentUuid = null;
        }
    }

    @Override
    public class_1688 getLinkedChild() {
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            if (this.linkedChild == null && this.childUuid != null && (class_19372 = server.method_14190(this.childUuid)) instanceof class_1688) {
                class_1688 child = (class_1688)class_19372;
                this.setLinkedChild(child);
            }
        }
        return this.linkedChild;
    }

    @Override
    public void setLinkedChild(class_1688 child) {
        this.linkedChild = child;
        if (child == null) {
            this.childUuid = null;
        }
    }
}

