/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.cammiesminecarttweaks.integration;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="minecarttweaks")
public class MinecartTweaksConfig
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject
    public ClientTweaks clientTweaks = new ClientTweaks();
    @ConfigEntry.Gui.CollapsibleObject
    public ServerTweaks serverTweaks = new ServerTweaks();

    public double getFurnaceMinecartSpeed() {
        return Math.max(0.1, this.serverTweaks.furnaceMinecartSpeed * 0.05);
    }

    public double getOtherMinecartSpeed() {
        return Math.max(0.1, this.serverTweaks.otherMinecartSpeed * 0.05);
    }

    public double getMaxSpeedAroundTurns() {
        return Math.min(1.0, this.serverTweaks.maxSpeedAroundTurns * 0.05);
    }

    public static class ClientTweaks {
        public boolean useCampfireSmoke = true;
        public boolean playerViewIsLocked = false;
        @ConfigEntry.BoundedDiscrete(max=90L)
        public int maxViewAngle = 90;
    }

    public static class ServerTweaks {
        public double furnaceMinecartSpeed = 40.0;
        public double otherMinecartSpeed = 10.0;
        public double maxSpeedAroundTurns = 8.0;
        public float minecartDamage = 20.0f;
        public int furnaceMaxBurnTime = 72000;
        public boolean canLinkMinecarts = true;
        public boolean shouldPoweredRailsStopFurnace = true;
        public boolean furnacesCanUseAllFuels = true;
    }
}

