/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.event.PlayerTransferredTeamOwnershipEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class PartyTeam
extends Team {
    UUID owner = class_156.field_25140;

    public PartyTeam(TeamManager m) {
        super(m);
    }

    @Override
    public TeamType getType() {
        return TeamType.PARTY;
    }

    @Override
    protected void serializeExtraNBT(class_2487 tag) {
        tag.method_10582("owner", this.owner.toString());
    }

    @Override
    public void deserializeNBT(class_2487 tag) {
        super.deserializeNBT(tag);
        this.owner = UUID.fromString(tag.method_10558("owner"));
    }

    @Override
    public TeamRank getHighestRank(UUID playerId) {
        if (this.owner.equals(playerId)) {
            return TeamRank.OWNER;
        }
        return super.getHighestRank(playerId);
    }

    public boolean isOwner(UUID profile) {
        return this.owner.equals(profile);
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Nullable
    public class_3222 getOwnerPlayer() {
        return FTBTUtils.getPlayerByUUID(this.manager.server, this.owner);
    }

    @Deprecated
    public int join(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        Team oldTeam = this.manager.getPlayerTeam(player);
        if (!oldTeam.getType().isPlayer()) {
            throw TeamArgument.ALREADY_IN_PARTY.create();
        }
        UUID id = player.method_5667();
        ((PlayerTeam)oldTeam).actualTeam = this;
        this.ranks.put(id, TeamRank.MEMBER);
        this.sendMessage(class_156.field_25140, (class_2561)new class_2585("").method_10852(player.method_5477()).method_27693(" joined your party!").method_27692(class_124.field_1060));
        this.save();
        oldTeam.ranks.remove(id);
        oldTeam.save();
        ((PlayerTeam)oldTeam).updatePresence();
        this.manager.syncAll();
        this.changedTeam(oldTeam, id, player, false);
        return 1;
    }

    @Deprecated
    public int invite(class_3222 from, Collection<GameProfile> players) throws CommandSyntaxException {
        for (GameProfile player : players) {
            if (this.isMember(player.getId())) continue;
            this.ranks.put(player.getId(), TeamRank.INVITED);
            this.save();
            this.sendMessage(from.method_5667(), (class_2561)new class_2585("Invited " + player.getName()).method_27692(class_124.field_1060));
            class_3222 p = FTBTUtils.getPlayerByUUID(this.manager.getServer(), player.getId());
            if (p == null) continue;
            p.method_9203((class_2561)new class_2585("").method_10852(from.method_5477()).method_27693(" has invited you to join their party!"), class_156.field_25140);
            class_5250 acceptButton = new class_2585("Accept \u2714").method_27696(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11750, "/ftbteams party join " + this.getStringID())));
            class_5250 denyButton = new class_2585("Deny \u2718").method_27696(class_2583.field_24360.method_10977(class_124.field_1061).method_10958(new class_2558(class_2558.class_2559.field_11750, "/ftbteams party deny_invite " + this.getStringID())));
            p.method_9203((class_2561)new class_2585("[").method_10852((class_2561)acceptButton).method_27693("] [").method_10852((class_2561)denyButton).method_27693("]"), class_156.field_25140);
        }
        return 1;
    }

    @Deprecated
    public int kick(class_3222 from, Collection<GameProfile> players) throws CommandSyntaxException {
        for (GameProfile player : players) {
            UUID id = player.getId();
            Team oldTeam = this.manager.getPlayerTeam(id);
            if (oldTeam != this) {
                throw TeamArgument.NOT_IN_PARTY.create();
            }
            if (this.isOwner(id)) {
                throw TeamArgument.CANT_KICK_OWNER.create();
            }
            PlayerTeam team = this.manager.getInternalPlayerTeam(id);
            team.actualTeam = team;
            class_3222 playerEntity = FTBTUtils.getPlayerByUUID(this.manager.getServer(), id);
            team.ranks.put(id, TeamRank.OWNER);
            this.sendMessage(from.method_5667(), (class_2561)new class_2585("Kicked ").method_10852(this.manager.getName(id)).method_27693(" from ").method_10852(this.getName()).method_27692(class_124.field_1061));
            team.save();
            this.ranks.remove(id);
            this.save();
            team.updatePresence();
            this.manager.syncAll();
            if (playerEntity != null) {
                playerEntity.method_7353((class_2561)new class_2585("You have been kicked from ").method_10852(this.getName()).method_27693("!"), false);
                this.updateCommands(playerEntity);
            }
            team.changedTeam(this, id, playerEntity, false);
        }
        return 1;
    }

    @Deprecated
    public int transferOwnership(class_3222 from, class_3222 to) throws CommandSyntaxException {
        if (!this.getOnlineMembers().contains(to)) {
            throw TeamArgument.NOT_MEMBER.create((Object)to.method_5476(), (Object)this.getName());
        }
        if (from == to) {
            from.method_9203((class_2561)new class_2585("What."), class_156.field_25140);
            return 0;
        }
        this.ranks.put(this.owner, TeamRank.OFFICER);
        this.owner = to.method_5667();
        this.ranks.put(this.owner, TeamRank.OWNER);
        this.save();
        ((Consumer)TeamEvent.OWNERSHIP_TRANSFERRED.invoker()).accept(new PlayerTransferredTeamOwnershipEvent(this, from, to));
        this.sendMessage(from.method_5667(), (class_2561)new class_2585("Transferred ownership to ").method_10852(to.method_5476()).method_27692(class_124.field_1061));
        this.updateCommands(from);
        this.updateCommands(to);
        this.manager.syncAll();
        return 1;
    }

    @Deprecated
    public int leave(class_3222 player) throws CommandSyntaxException {
        UUID id = player.method_5667();
        if (this.isOwner(id) && this.getMembers().size() > 1) {
            throw TeamArgument.OWNER_CANT_LEAVE.create();
        }
        PlayerTeam team = this.manager.getInternalPlayerTeam(id);
        team.actualTeam = team;
        team.ranks.put(id, TeamRank.OWNER);
        this.sendMessage(class_156.field_25140, (class_2561)new class_2585("").method_10852(player.method_5477()).method_27693(" left your party!").method_27692(class_124.field_1054));
        team.save();
        this.ranks.remove(id);
        this.manager.save();
        boolean deleted = false;
        if (this.getMembers().isEmpty()) {
            deleted = true;
            this.manager.saveNow();
            this.manager.teamMap.remove(this.getId());
            String fn = this.getId() + ".snbt";
            try {
                Path dir = this.manager.server.method_27050(TeamManager.FOLDER_NAME).resolve("deleted");
                if (Files.notExists(dir, new LinkOption[0])) {
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                Files.move(this.manager.server.method_27050(TeamManager.FOLDER_NAME).resolve("party/" + fn), dir.resolve(fn), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    Files.deleteIfExists(this.manager.server.method_27050(TeamManager.FOLDER_NAME).resolve("party/" + fn));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        team.updatePresence();
        this.manager.syncAll();
        team.changedTeam(this, id, player, deleted);
        return 1;
    }

    @Deprecated
    public int addAlly(class_2168 source, Collection<GameProfile> players) throws CommandSyntaxException {
        UUID from = source.method_9228() == null ? class_156.field_25140 : source.method_9228().method_5667();
        boolean changed = false;
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (this.isAlly(id)) continue;
            this.ranks.put(id, TeamRank.ALLY);
            this.sendMessage(from, (class_2561)new class_2585("").method_27693(player.getName()).method_27693(" added as ally!").method_27692(class_124.field_1054));
            changed = true;
        }
        if (changed) {
            this.save();
            this.manager.syncAll();
            return 1;
        }
        return 0;
    }

    @Deprecated
    public int removeAlly(class_2168 source, Collection<GameProfile> players) throws CommandSyntaxException {
        UUID from = source.method_9228() == null ? class_156.field_25140 : source.method_9228().method_5667();
        boolean changed = false;
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (!this.isAlly(id) || this.isMember(id)) continue;
            this.ranks.remove(id);
            this.sendMessage(from, (class_2561)new class_2585("").method_27693(player.getName()).method_27693(" removed from allies!").method_27692(class_124.field_1054));
            changed = true;
        }
        if (changed) {
            this.save();
            this.manager.syncAll();
            return 1;
        }
        return 0;
    }

    @Deprecated
    public int listAllies(class_2168 source) throws CommandSyntaxException {
        source.method_9226((class_2561)new class_2585("Allies:"), false);
        boolean any = false;
        for (Map.Entry<UUID, TeamRank> entry : this.getRanked(TeamRank.ALLY).entrySet()) {
            if (entry.getValue().is(TeamRank.MEMBER)) continue;
            source.method_9226(this.manager.getName(entry.getKey()), false);
            any = true;
        }
        if (!any) {
            source.method_9226((class_2561)new class_2585("None"), false);
        }
        return 1;
    }
}

