/*
 * Decompiled with CFR 0.152.
 */
package com.shnupbups.redstonebits.blockentity;

import com.shnupbups.redstonebits.FakePlayerEntity;
import com.shnupbups.redstonebits.container.BreakerScreenHandler;
import com.shnupbups.redstonebits.init.ModBlockEntities;
import com.shnupbups.redstonebits.properties.ModProperties;
import java.util.Iterator;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3215;
import net.minecraft.class_3913;

public class BreakerBlockEntity
extends class_2624 {
    private final class_3913 propertyDelegate = new BreakerPropertyDelegate();
    private final class_2371<class_1799> inventory;
    private class_2680 breakState;
    private class_1799 breakStack = class_1799.field_8037;
    private int breakProgress = 0;
    private FakePlayerEntity fakePlayerEntity;

    public BreakerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.BREAKER, pos, state);
        this.inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, BreakerBlockEntity blockEntity) {
        class_2680 currentBreakState = world.method_8320(blockEntity.getBreakPos());
        int prevBreakPercentage = blockEntity.getBreakPercentage();
        boolean dirty = false;
        if (blockEntity.isBreaking()) {
            class_2680 breakState = blockEntity.getBreakState();
            if (breakState == null) {
                blockEntity.startBreak();
            }
            if (!blockEntity.getBreakStack().equals(blockEntity.getTool()) || !breakState.equals(currentBreakState) || currentBreakState.method_26215() || currentBreakState.method_26214((class_1922)world, pos) < 0.0f) {
                blockEntity.cancelBreak();
            } else if (blockEntity.getBreakProgress() >= blockEntity.getBreakTime()) {
                blockEntity.finishBreak();
            } else {
                blockEntity.continueBreak();
            }
            int newBreakPercentage = blockEntity.getBreakPercentage();
            if (newBreakPercentage != prevBreakPercentage) {
                dirty = true;
                world.method_8455(pos, world.method_8320(pos).method_26204());
                if (newBreakPercentage <= 0 || newBreakPercentage >= 100) {
                    world.method_8517(blockEntity.getFakePlayer().method_5628(), blockEntity.getBreakPos(), -1);
                } else {
                    world.method_8517(blockEntity.getFakePlayer().method_5628(), blockEntity.getBreakPos(), blockEntity.getBreakPercentage() / 10);
                }
            }
        }
        if (blockEntity.isBreaking() != ((Boolean)world.method_8320(pos).method_11654((class_2769)ModProperties.BREAKING)).booleanValue()) {
            world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)ModProperties.BREAKING, (Comparable)Boolean.valueOf(blockEntity.isBreaking())));
            dirty = true;
        }
        if (dirty) {
            ((class_3215)world.method_8398()).method_14128(pos);
            blockEntity.method_5431();
        }
    }

    public static int getBreakPercentage(int breakProgress, int breakTime) {
        if (breakTime > 0) {
            float div = (float)breakProgress / (float)breakTime;
            return Math.min((int)(div * 100.0f), 100);
        }
        return 0;
    }

    public class_1799 getBreakStack() {
        return this.breakStack;
    }

    public void setBreakStack(class_1799 stack) {
        this.breakStack = stack;
    }

    public class_2680 getBreakState() {
        return this.breakState;
    }

    public void setBreakState(class_2680 state) {
        this.breakState = state;
    }

    public int getBreakProgress() {
        return this.breakProgress;
    }

    public void setBreakProgress(int breakProgress) {
        this.breakProgress = breakProgress;
    }

    public void incrementBreakProgress() {
        ++this.breakProgress;
    }

    public void resetBreakProgress() {
        this.breakProgress = 0;
    }

    public class_3913 getPropertyDelegate() {
        return this.propertyDelegate;
    }

    public int getBreakTime() {
        class_2680 breakState = this.getBreakState();
        class_1799 stack = this.getBreakStack();
        if (breakState == null) {
            return 0;
        }
        float baseTime = this.calcBlockBreakingTime();
        float itemMultiplier = stack.method_7924(breakState);
        int level = class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)stack);
        if (level > 0 && itemMultiplier > 1.0f) {
            itemMultiplier += (float)(level * level + 1);
        }
        float time = baseTime / itemMultiplier;
        return (int)time;
    }

    public boolean isToolEffective() {
        class_2680 breakState = this.getBreakState();
        if (breakState == null) {
            return false;
        }
        return !breakState.method_29291() || this.getTool().method_7951(breakState);
    }

    public float calcBlockBreakingTime() {
        class_2680 breakState = this.getBreakState();
        if (breakState == null) {
            return 0.0f;
        }
        float hardness = breakState.method_26214((class_1922)this.method_10997(), this.getBreakPos());
        if (hardness == -1.0f) {
            return 0.0f;
        }
        int multiplier = this.isToolEffective() ? 30 : 100;
        return hardness * (float)multiplier;
    }

    public void startBreak() {
        this.setBreakState(this.method_10997().method_8320(this.getBreakPos()));
        this.setBreakStack(this.getTool());
        this.incrementBreakProgress();
        this.method_5431();
    }

    public void cancelBreak() {
        this.setBreakState(null);
        this.setBreakStack(class_1799.field_8037);
        this.resetBreakProgress();
        this.method_5431();
    }

    public void finishBreak() {
        this.breakBlock();
        this.cancelBreak();
        this.method_5431();
    }

    public boolean isBreaking() {
        return this.getBreakProgress() > 0;
    }

    public class_2350 getFacing() {
        if (this.method_10997() == null || !this.method_10997().method_8320(this.method_11016()).method_28498((class_2769)class_2741.field_12525)) {
            return class_2350.field_11043;
        }
        return (class_2350)this.method_10997().method_8320(this.method_11016()).method_11654((class_2769)class_2741.field_12525);
    }

    public class_2338 getBreakPos() {
        return this.method_11016().method_10081(this.getFacing().method_10163());
    }

    public void breakBlock() {
        class_1937 world = this.method_10997();
        if (world != null && !world.method_8608()) {
            class_2680 breakState = this.getBreakState();
            class_1657 fakePlayer = this.getFakePlayer();
            class_2586 blockEntity = breakState.method_31709() ? world.method_8321(this.getBreakPos()) : null;
            fakePlayer.method_6122(class_1268.field_5808, this.getBreakStack());
            if (this.getTool().method_7909().method_7885(breakState, world, this.getBreakPos(), fakePlayer) && this.isToolEffective()) {
                class_2248.method_9511((class_2680)breakState, (class_1937)world, (class_2338)this.getBreakPos(), (class_2586)blockEntity, (class_1297)fakePlayer, (class_1799)this.getTool());
            }
            this.getTool().method_7909().method_7879(this.getTool(), world, breakState, this.getBreakPos(), (class_1309)fakePlayer);
            world.method_22352(this.getBreakPos(), false);
        }
    }

    public void continueBreak() {
        this.incrementBreakProgress();
        this.method_5431();
    }

    public class_1799 getTool() {
        return this.method_5438(0);
    }

    public class_1657 getFakePlayer() {
        if (this.fakePlayerEntity == null) {
            this.fakePlayerEntity = new FakePlayerEntity(this.method_10997(), this.method_11016());
        }
        return this.fakePlayerEntity;
    }

    public class_2561 method_17823() {
        return new class_2588("container.redstonebits.breaker");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new BreakerScreenHandler(syncId, playerInventory, (class_1263)this, this.getPropertyDelegate());
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5442() {
        class_1799 stack;
        Iterator var1 = this.inventory.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((stack = (class_1799)var1.next()).method_7960());
        return false;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.readBreakerNbt(nbt);
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        this.writeBreakerNbt(nbt);
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        if (!stack.method_7960()) {
            this.method_5431();
        }
        return stack;
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        class_2338 pos = this.method_11016();
        if (this.method_10997() == null || this.method_10997().method_8321(pos) != this) {
            return false;
        }
        return player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public int getBreakPercentage() {
        return BreakerBlockEntity.getBreakPercentage(this.getBreakProgress(), this.getBreakTime());
    }

    public void writeBreakerNbt(class_2487 nbt) {
        nbt.method_10569("BreakProgress", this.getBreakProgress());
        if (this.getBreakState() != null) {
            nbt.method_10566("BreakState", (class_2520)class_2512.method_10686((class_2680)this.getBreakState()));
        }
        class_2487 breakStack = new class_2487();
        this.getBreakStack().method_7953(breakStack);
        nbt.method_10566("BreakStack", (class_2520)breakStack);
    }

    public void readBreakerNbt(class_2487 nbt) {
        this.setBreakProgress(nbt.method_10550("BreakProgress"));
        if (nbt.method_10545("BreakState")) {
            this.setBreakState(class_2512.method_10681((class_2487)nbt.method_10562("BreakState")));
        } else {
            this.setBreakState(null);
        }
        this.setBreakStack(class_1799.method_7915((class_2487)nbt.method_10562("BreakStack")));
    }

    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.writeBreakerNbt(nbt);
        return nbt;
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    private class BreakerPropertyDelegate
    implements class_3913 {
        private BreakerPropertyDelegate() {
        }

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> BreakerBlockEntity.this.getBreakProgress();
                case 1 -> BreakerBlockEntity.this.getBreakTime();
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                BreakerBlockEntity.this.setBreakProgress(value);
            }
        }

        public int method_17389() {
            return 2;
        }
    }
}

