/*
 * Decompiled with CFR 0.152.
 */
package com.shnupbups.redstonebits.block;

import com.shnupbups.redstonebits.init.ModSoundEvents;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class RotatorBlock
extends class_2318 {
    public static final class_2746 INVERTED = class_2741.field_12501;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final List<class_2769<?>> ROTATION_PROPERTIES = List.of(class_2741.field_12525, class_2741.field_12545, class_2741.field_12481, class_2741.field_28062, class_2741.field_12496, class_2741.field_12529, class_2741.field_12532, class_2741.field_12507, class_2741.field_12542);

    public RotatorBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)class_2350.field_11036)).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!player.method_31549().field_7476) {
            return class_1269.field_5811;
        }
        boolean inverted = (Boolean)state.method_11654((class_2769)INVERTED);
        float pitch = inverted ? 0.55f : 0.5f;
        world.method_8396(player, pos, ModSoundEvents.BLOCK_ROTATOR_INVERT, class_3419.field_15245, 0.3f, pitch);
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)INVERTED, (Comparable)Boolean.valueOf(!inverted)), 3);
        return class_1269.field_5812;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 pos2, boolean notify) {
        class_2338 facingPos = this.getFacingPos(state, pos);
        class_2680 facingState = world.method_8320(facingPos);
        boolean receivingPower = world.method_8479(pos) || world.method_8479(pos.method_10084());
        boolean powered = (Boolean)state.method_11654((class_2769)POWERED);
        boolean shouldUpdateComparators = pos2.equals((Object)facingPos);
        if (receivingPower && !powered) {
            class_2680 rotatedState = facingState.method_26186((Boolean)state.method_11654((class_2769)INVERTED) != false ? class_2470.field_11465 : class_2470.field_11463);
            if (!rotatedState.equals(facingState) && rotatedState.method_26184((class_4538)world, facingPos)) {
                world.method_8652(facingPos, rotatedState, 3);
                world.method_8396(null, pos, ModSoundEvents.BLOCK_ROTATOR_ROTATE, class_3419.field_15245, 1.0f, 1.0f);
                shouldUpdateComparators = true;
            } else {
                world.method_8396(null, pos, ModSoundEvents.BLOCK_ROTATOR_FAIL, class_3419.field_15245, 1.0f, 1.2f);
            }
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 7);
        } else if (!receivingPower && powered) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)), 7);
        }
        if (shouldUpdateComparators) {
            world.method_8455(pos, (class_2248)this);
        }
    }

    public class_2338 getFacingPos(class_2680 state, class_2338 pos) {
        return pos.method_10093((class_2350)state.method_11654((class_2769)field_10927));
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2769<?> rotationProperty;
        class_2680 facingState = world.method_8320(this.getFacingPos(state, pos));
        if (facingState.method_28498(rotationProperty = RotatorBlock.getRotationProperty(facingState))) {
            if (rotationProperty instanceof class_2753) {
                class_2753 property = (class_2753)rotationProperty;
                return RotatorBlock.getComparatorValue((class_2350)facingState.method_11654((class_2769)property));
            }
            if (rotationProperty instanceof class_2754) {
                class_2754 property = (class_2754)rotationProperty;
                Comparable comparable = facingState.method_11654((class_2769)property);
                if (comparable instanceof class_2350.class_2351) {
                    class_2350.class_2351 axis = (class_2350.class_2351)comparable;
                    return RotatorBlock.getComparatorValue(axis);
                }
                comparable = facingState.method_11654((class_2769)property);
                if (comparable instanceof class_2768) {
                    class_2768 railShape = (class_2768)comparable;
                    return RotatorBlock.getComparatorValue(railShape);
                }
            } else if (rotationProperty instanceof class_2758) {
                class_2758 property = (class_2758)rotationProperty;
                return (Integer)facingState.method_11654((class_2769)property);
            }
        }
        return 0;
    }

    public static class_2769<?> getRotationProperty(class_2680 state) {
        for (class_2769<?> property : ROTATION_PROPERTIES) {
            if (!state.method_28498(property)) continue;
            return property;
        }
        return null;
    }

    public static int getComparatorValue(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> 0;
            case class_2350.field_11039 -> 4;
            case class_2350.field_11043 -> 8;
            case class_2350.field_11034 -> 12;
            default -> 0;
        };
    }

    public static int getComparatorValue(class_2350.class_2351 axis) {
        return switch (axis) {
            case class_2350.class_2351.field_11051 -> 0;
            case class_2350.class_2351.field_11048 -> 4;
            default -> 0;
        };
    }

    public static int getComparatorValue(class_2768 railShape) {
        return switch (railShape) {
            default -> throw new IncompatibleClassChangeError();
            case class_2768.field_12665 -> 0;
            case class_2768.field_12674 -> 4;
            case class_2768.field_12667 -> 12;
            case class_2768.field_12666 -> 4;
            case class_2768.field_12670 -> 8;
            case class_2768.field_12668 -> 0;
            case class_2768.field_12664 -> 14;
            case class_2768.field_12671 -> 2;
            case class_2768.field_12672 -> 6;
            case class_2768.field_12663 -> 10;
        };
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)ctx.method_7715().method_10153());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)field_10927, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)field_10927)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)field_10927)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_10927, POWERED, INVERTED});
    }
}

