/*
 * Decompiled with CFR 0.152.
 */
package wraith.croptosis.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.Scanner;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import wraith.croptosis.Croptosis;
import wraith.croptosis.registry.ItemRegistry;

public final class Config {
    private static final String CONFIG_FILE = "config/croptosis/config.json";
    private class_2487 configData;
    private static Config INSTANCE = null;
    private int difference = 0;

    private Config() {
    }

    public static Config getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Config();
            INSTANCE.loadConfig();
        }
        return INSTANCE;
    }

    public boolean generatePotash() {
        return this.configData.method_10562("potash_oregen").method_10577("enabled");
    }

    public boolean generateApatite() {
        return this.configData.method_10562("apatite_oregen").method_10577("enabled");
    }

    public String potashVeinShape() {
        return this.configData.method_10562("potash_oregen").method_10558("vein_shape");
    }

    public String apatiteVeinShape() {
        return this.configData.method_10562("apatite_oregen").method_10558("vein_shape");
    }

    public int potashVeinSize() {
        return this.configData.method_10562("potash_oregen").method_10550("vein_size");
    }

    public int apatiteVeinSize() {
        return this.configData.method_10562("apatite_oregen").method_10550("vein_size");
    }

    public int minimumPotashHeight() {
        return this.configData.method_10562("potash_oregen").method_10550("min_height");
    }

    public int minimumApatiteHeight() {
        return this.configData.method_10562("apatite_oregen").method_10550("min_height");
    }

    public int maximumPotashHeight() {
        return this.configData.method_10562("potash_oregen").method_10550("max_height");
    }

    public int maximumApatiteHeight() {
        return this.configData.method_10562("apatite_oregen").method_10550("max_height");
    }

    public int maxPotashVeinsPerChunk() {
        return this.configData.method_10562("potash_oregen").method_10550("per_chunk");
    }

    public int maxApatiteVeinsPerChunk() {
        return this.configData.method_10562("apatite_oregen").method_10550("per_chunk");
    }

    public int getWateringCanRange(String wateringCan) {
        class_2487 wateringCans = this.configData.method_10562("watering_cans");
        if (!wateringCans.method_10545(wateringCan)) {
            Croptosis.LOGGER.error("Watering can " + wateringCan + " not found in config file!");
            return 0;
        }
        return !this.allowWateringCans() ? 0 : wateringCans.method_10562(wateringCan).method_10550("range");
    }

    public int getWateringCanCapacity(String wateringCan) {
        class_2487 wateringCans = this.configData.method_10562("watering_cans");
        if (!wateringCans.method_10545(wateringCan)) {
            Croptosis.LOGGER.error("Watering can " + wateringCan + " not found in config file!");
            return 0;
        }
        return !this.allowWateringCans() ? 0 : wateringCans.method_10562(wateringCan).method_10550("capacity");
    }

    public double getWateringCanChance(String wateringCan) {
        class_2487 wateringCans = this.configData.method_10562("watering_cans");
        if (!wateringCans.method_10545(wateringCan)) {
            Croptosis.LOGGER.error("Watering can " + wateringCan + " not found in config file!");
            return 0.0;
        }
        return !this.allowWateringCans() ? 0.0 : wateringCans.method_10562(wateringCan).method_10574("chance");
    }

    public boolean allowWateringCans() {
        return this.configData.method_10562("watering_cans").method_10577("enabled");
    }

    public boolean canConvertToFertilizedBlocks() {
        return this.configData.method_10562("fertilized_blocks").method_10577("enable_bone_meal_conversion");
    }

    public boolean isFertilizerItemEnabled(String item) {
        class_2487 fertilizers = this.configData.method_10562("fertilizer_items");
        if (!fertilizers.method_10545("enable_" + item)) {
            Croptosis.LOGGER.error("Fertilizer item " + item + " not found in config file!");
            return false;
        }
        return fertilizers.method_10577("enable_" + item);
    }

    private class_2487 getDefaults() {
        class_2487 defaultConfig = new class_2487();
        class_2487 potash = new class_2487();
        potash.method_10556("enabled", true);
        potash.method_10582("vein_shape", "trapezoid");
        potash.method_10569("min_height", 52);
        potash.method_10569("max_height", 204);
        potash.method_10569("per_chunk", 8);
        potash.method_10569("vein_size", 8);
        defaultConfig.method_10566("potash_oregen", (class_2520)potash);
        class_2487 apatite = new class_2487();
        apatite.method_10556("enabled", true);
        potash.method_10582("vein_shape", "uniform");
        apatite.method_10569("min_height", -64);
        apatite.method_10569("max_height", 34);
        apatite.method_10569("per_chunk", 4);
        apatite.method_10569("vein_size", 12);
        defaultConfig.method_10566("apatite_oregen", (class_2520)apatite);
        class_2487 wateringCans = new class_2487();
        wateringCans.method_10556("enabled", true);
        class_2487 ironWateringCan = new class_2487();
        ironWateringCan.method_10569("range", 2);
        ironWateringCan.method_10569("capacity", 12);
        ironWateringCan.method_10549("chance", 0.02);
        class_2487 goldWateringCan = new class_2487();
        goldWateringCan.method_10569("range", 5);
        goldWateringCan.method_10569("capacity", 6);
        goldWateringCan.method_10549("chance", 0.025);
        class_2487 diamondWateringCan = new class_2487();
        diamondWateringCan.method_10569("range", 3);
        diamondWateringCan.method_10569("capacity", 16);
        diamondWateringCan.method_10549("chance", 0.025);
        class_2487 netheriteWateringCan = new class_2487();
        netheriteWateringCan.method_10569("range", 4);
        netheriteWateringCan.method_10569("capacity", 20);
        netheriteWateringCan.method_10549("chance", 0.03);
        wateringCans.method_10566("iron", (class_2520)ironWateringCan);
        wateringCans.method_10566("gold", (class_2520)goldWateringCan);
        wateringCans.method_10566("diamond", (class_2520)diamondWateringCan);
        wateringCans.method_10566("netherite", (class_2520)netheriteWateringCan);
        defaultConfig.method_10566("watering_cans", (class_2520)wateringCans);
        class_2487 fertilizers = new class_2487();
        for (String fertilizer : ItemRegistry.FERTILIEZR_ITEMS) {
            fertilizers.method_10556("enable_" + fertilizer, true);
        }
        defaultConfig.method_10566("fertilizer_items", (class_2520)fertilizers);
        class_2487 fertilizedBlocks = new class_2487();
        fertilizedBlocks.method_10556("enable_bone_meal_conversion", true);
        defaultConfig.method_10566("fertilized_blocks", (class_2520)fertilizedBlocks);
        return defaultConfig;
    }

    public int getIntOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10550(key);
        }
        ++this.difference;
        return defaults.method_10550(key);
    }

    public boolean getBooleanOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10577(key);
        }
        ++this.difference;
        return defaults.method_10577(key);
    }

    private String getStringOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10558(key);
        }
        ++this.difference;
        return defaults.method_10558(key);
    }

    private class_2487 getCompoundOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10562(key);
        }
        ++this.difference;
        return defaults.method_10562(key);
    }

    private double getDoubleOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10574(key);
        }
        ++this.difference;
        return defaults.method_10574(key);
    }

    public int getIntOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsInt();
        }
        ++this.difference;
        return defaults.method_10550(key);
    }

    public boolean getBooleanOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsBoolean();
        }
        ++this.difference;
        return defaults.method_10577(key);
    }

    private String getStringOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsString();
        }
        ++this.difference;
        return defaults.method_10558(key);
    }

    private double getDoubleOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsDouble();
        }
        ++this.difference;
        return defaults.method_10574(key);
    }

    private JsonObject toJson(class_2487 tag) {
        JsonObject json = new JsonObject();
        class_2487 defaults = this.getDefaults();
        JsonObject potashOregen = new JsonObject();
        class_2487 potash = this.getCompoundOrDefault(tag, "potash_oregen", defaults);
        potashOregen.addProperty("enabled", Boolean.valueOf(this.getBooleanOrDefault(potash, "enabled", defaults)));
        potashOregen.addProperty("vein_shape", this.getStringOrDefault(potash, "vein_shape", defaults));
        potashOregen.addProperty("min_height", (Number)this.getIntOrDefault(potash, "min_height", defaults));
        potashOregen.addProperty("max_height", (Number)this.getIntOrDefault(potash, "max_height", defaults));
        potashOregen.addProperty("per_chunk", (Number)this.getIntOrDefault(potash, "per_chunk", defaults));
        potashOregen.addProperty("vein_size", (Number)this.getIntOrDefault(potash, "vein_size", defaults));
        json.add("potash_oregen", (JsonElement)potashOregen);
        JsonObject apatiteOregen = new JsonObject();
        class_2487 apatite = this.getCompoundOrDefault(tag, "apatite_oregen", defaults);
        apatiteOregen.addProperty("enabled", Boolean.valueOf(this.getBooleanOrDefault(apatite, "enabled", defaults)));
        apatiteOregen.addProperty("vein_shape", this.getStringOrDefault(apatite, "vein_shape", defaults));
        apatiteOregen.addProperty("min_height", (Number)this.getIntOrDefault(apatite, "min_height", defaults));
        apatiteOregen.addProperty("max_height", (Number)this.getIntOrDefault(apatite, "max_height", defaults));
        apatiteOregen.addProperty("per_chunk", (Number)this.getIntOrDefault(apatite, "per_chunk", defaults));
        apatiteOregen.addProperty("vein_size", (Number)this.getIntOrDefault(apatite, "vein_size", defaults));
        json.add("apatite_oregen", (JsonElement)apatiteOregen);
        JsonObject wateringCan = new JsonObject();
        class_2487 wateringCanNbt = this.getCompoundOrDefault(tag, "watering_cans", defaults);
        wateringCan.addProperty("enabled", Boolean.valueOf(this.getBooleanOrDefault(wateringCanNbt, "enabled", defaults)));
        JsonObject ironWateringCan = new JsonObject();
        class_2487 ironWateringCanNbt = this.getCompoundOrDefault(wateringCanNbt, "iron", defaults);
        ironWateringCan.addProperty("range", (Number)ironWateringCanNbt.method_10550("range"));
        ironWateringCan.addProperty("capacity", (Number)ironWateringCanNbt.method_10550("capacity"));
        ironWateringCan.addProperty("chance", (Number)ironWateringCanNbt.method_10574("chance"));
        JsonObject goldWateringCan = new JsonObject();
        class_2487 goldWateringCanNbt = this.getCompoundOrDefault(wateringCanNbt, "gold", defaults);
        goldWateringCan.addProperty("range", (Number)goldWateringCanNbt.method_10550("range"));
        goldWateringCan.addProperty("capacity", (Number)goldWateringCanNbt.method_10550("capacity"));
        goldWateringCan.addProperty("chance", (Number)goldWateringCanNbt.method_10574("chance"));
        JsonObject diamondWateringCan = new JsonObject();
        class_2487 diamondWateringCanNbt = this.getCompoundOrDefault(wateringCanNbt, "diamond", defaults);
        diamondWateringCan.addProperty("range", (Number)diamondWateringCanNbt.method_10550("range"));
        diamondWateringCan.addProperty("capacity", (Number)diamondWateringCanNbt.method_10550("capacity"));
        diamondWateringCan.addProperty("chance", (Number)diamondWateringCanNbt.method_10574("chance"));
        JsonObject netheriteWateringCan = new JsonObject();
        class_2487 netheriteWateringCanNbt = this.getCompoundOrDefault(wateringCanNbt, "netherite", defaults);
        netheriteWateringCan.addProperty("range", (Number)netheriteWateringCanNbt.method_10550("range"));
        netheriteWateringCan.addProperty("capacity", (Number)netheriteWateringCanNbt.method_10550("capacity"));
        netheriteWateringCan.addProperty("chance", (Number)netheriteWateringCanNbt.method_10574("chance"));
        wateringCan.add("iron", (JsonElement)ironWateringCan);
        wateringCan.add("gold", (JsonElement)goldWateringCan);
        wateringCan.add("diamond", (JsonElement)diamondWateringCan);
        wateringCan.add("netherite", (JsonElement)netheriteWateringCan);
        json.add("watering_cans", (JsonElement)wateringCan);
        JsonObject fertilizerItems = new JsonObject();
        class_2487 fertilizerItemsNbt = this.getCompoundOrDefault(tag, "fertilizer_items", defaults);
        for (String fertilizer : ItemRegistry.FERTILIEZR_ITEMS) {
            String fertilizerKey = "enable_" + fertilizer;
            fertilizerItems.addProperty(fertilizerKey, Boolean.valueOf(this.getBooleanOrDefault(fertilizerItemsNbt, fertilizerKey, defaults)));
        }
        json.add("fertilizer_items", (JsonElement)fertilizerItems);
        JsonObject fertilizedBlocks = new JsonObject();
        class_2487 fertilizedBlocksNbt = this.getCompoundOrDefault(tag, "fertilized_blocks", defaults);
        fertilizedBlocks.addProperty("enable_bone_meal_conversion", Boolean.valueOf(this.getBooleanOrDefault(fertilizedBlocksNbt, "enable_bone_meal_conversion", defaults)));
        json.add("fertilized_blocks", (JsonElement)fertilizedBlocks);
        this.createFile(json, this.difference > 0);
        this.difference = 0;
        return json;
    }

    private class_2487 toNbtCompound(JsonObject json) {
        class_2487 tag = new class_2487();
        class_2487 defaults = this.getDefaults();
        class_2487 potashOregen = new class_2487();
        if (json.has("potash_oregen")) {
            JsonObject potashJson = json.get("potash_oregen").getAsJsonObject();
            class_2487 defaultPotash = defaults.method_10562("potash_oregen");
            potashOregen.method_10556("enabled", this.getBooleanOrDefault(potashJson, "enabled", defaultPotash));
            potashOregen.method_10582("vein_shape", this.getStringOrDefault(potashJson, "vein_shape", defaultPotash));
            potashOregen.method_10569("min_height", this.getIntOrDefault(potashJson, "min_height", defaultPotash));
            potashOregen.method_10569("max_height", this.getIntOrDefault(potashJson, "max_height", defaultPotash));
            potashOregen.method_10569("per_chunk", this.getIntOrDefault(potashJson, "per_chunk", defaultPotash));
            potashOregen.method_10569("vein_size", this.getIntOrDefault(potashJson, "vein_size", defaultPotash));
        } else {
            ++this.difference;
            potashOregen = defaults.method_10562("potash_oregen");
        }
        tag.method_10566("potash_oregen", (class_2520)potashOregen);
        class_2487 apatiteOregen = new class_2487();
        if (json.has("apatite_oregen")) {
            JsonObject apatiteJson = json.get("apatite_oregen").getAsJsonObject();
            class_2487 defaultApatite = defaults.method_10562("apatite_oregen");
            apatiteOregen.method_10556("enabled", this.getBooleanOrDefault(apatiteJson, "enabled", defaultApatite));
            apatiteOregen.method_10582("vein_shape", this.getStringOrDefault(apatiteJson, "vein_shape", defaultApatite));
            apatiteOregen.method_10569("min_height", this.getIntOrDefault(apatiteJson, "min_height", defaultApatite));
            apatiteOregen.method_10569("max_height", this.getIntOrDefault(apatiteJson, "max_height", defaultApatite));
            apatiteOregen.method_10569("per_chunk", this.getIntOrDefault(apatiteJson, "per_chunk", defaultApatite));
            apatiteOregen.method_10569("vein_size", this.getIntOrDefault(apatiteJson, "vein_size", defaultApatite));
        } else {
            ++this.difference;
            apatiteOregen = defaults.method_10562("apatite_oregen");
        }
        tag.method_10566("apatite_oregen", (class_2520)apatiteOregen);
        class_2487 wateringCans = new class_2487();
        if (json.has("watering_cans")) {
            JsonObject wateringCanJson = json.get("watering_cans").getAsJsonObject();
            class_2487 defaultWateringCan = defaults.method_10562("watering_cans");
            wateringCans.method_10556("enabled", this.getBooleanOrDefault(wateringCanJson, "enabled", defaultWateringCan));
            class_2487 ironWateringCan = defaultWateringCan.method_10562("iron");
            class_2487 goldWateringCan = defaultWateringCan.method_10562("gold");
            class_2487 diamondWateringCan = defaultWateringCan.method_10562("diamond");
            class_2487 netheriteWateringCan = defaultWateringCan.method_10562("netherite");
            if (wateringCanJson.has("iron")) {
                JsonObject ironJson = wateringCanJson.get("iron").getAsJsonObject();
                ironWateringCan.method_10569("range", this.getIntOrDefault(ironJson, "range", defaultWateringCan));
                ironWateringCan.method_10569("capacity", this.getIntOrDefault(ironJson, "capacity", defaultWateringCan));
                ironWateringCan.method_10549("chance", this.getDoubleOrDefault(ironJson, "chance", defaultWateringCan));
            }
            if (wateringCanJson.has("gold")) {
                JsonObject goldJson = wateringCanJson.get("gold").getAsJsonObject();
                goldWateringCan.method_10569("range", this.getIntOrDefault(goldJson, "range", defaultWateringCan));
                goldWateringCan.method_10569("capacity", this.getIntOrDefault(goldJson, "capacity", defaultWateringCan));
                goldWateringCan.method_10549("chance", this.getDoubleOrDefault(goldJson, "chance", defaultWateringCan));
            }
            if (wateringCanJson.has("diamond")) {
                JsonObject diamondJson = wateringCanJson.get("diamond").getAsJsonObject();
                diamondWateringCan.method_10569("range", this.getIntOrDefault(diamondJson, "range", defaultWateringCan));
                diamondWateringCan.method_10569("capacity", this.getIntOrDefault(diamondJson, "capacity", defaultWateringCan));
                diamondWateringCan.method_10549("chance", this.getDoubleOrDefault(diamondJson, "chance", defaultWateringCan));
            }
            if (wateringCanJson.has("netherite")) {
                JsonObject netheriteJson = wateringCanJson.get("netherite").getAsJsonObject();
                netheriteWateringCan.method_10569("range", this.getIntOrDefault(netheriteJson, "range", defaultWateringCan));
                netheriteWateringCan.method_10569("capacity", this.getIntOrDefault(netheriteJson, "capacity", defaultWateringCan));
                netheriteWateringCan.method_10549("chance", this.getDoubleOrDefault(netheriteJson, "chance", defaultWateringCan));
            }
            wateringCans.method_10566("iron", (class_2520)ironWateringCan);
            wateringCans.method_10566("gold", (class_2520)goldWateringCan);
            wateringCans.method_10566("diamond", (class_2520)diamondWateringCan);
            wateringCans.method_10566("netherite", (class_2520)netheriteWateringCan);
        } else {
            ++this.difference;
            wateringCans = defaults.method_10562("watering_cans");
        }
        tag.method_10566("watering_cans", (class_2520)wateringCans);
        class_2487 fertilizerItems = new class_2487();
        if (json.has("fertilizer_items")) {
            JsonObject fertilizerItemsJson = json.get("fertilizer_items").getAsJsonObject();
            class_2487 defaultFertilizerItems = defaults.method_10562("fertilizer_items");
            for (String fertilizer : ItemRegistry.FERTILIEZR_ITEMS) {
                String fertilizerKey = "enable_" + fertilizer;
                fertilizerItems.method_10556(fertilizerKey, this.getBooleanOrDefault(fertilizerItemsJson, fertilizerKey, defaultFertilizerItems));
            }
        } else {
            ++this.difference;
            fertilizerItems = defaults.method_10562("fertilizer_items");
        }
        tag.method_10566("fertilizer_items", (class_2520)fertilizerItems);
        class_2487 fertilizedBlocks = new class_2487();
        if (json.has("fertilized_blocks")) {
            JsonObject fertilizedBlocksJson = json.get("fertilized_blocks").getAsJsonObject();
            class_2487 defaultFertilizedBlocks = defaults.method_10562("fertilized_blocks");
            fertilizedBlocks.method_10556("enable_bone_meal_conversion", this.getBooleanOrDefault(fertilizedBlocksJson, "enable_bone_meal_conversion", defaultFertilizedBlocks));
        } else {
            ++this.difference;
            fertilizedBlocks = defaults.method_10562("fertilized_blocks");
        }
        tag.method_10566("fertilized_blocks", (class_2520)fertilizedBlocks);
        this.createFile(this.toJson(tag), this.difference > 0);
        this.difference = 0;
        return tag;
    }

    public boolean loadConfig() {
        try {
            return this.loadConfig(Config.getJsonObject(Config.readFile(new File(CONFIG_FILE))));
        }
        catch (Exception e) {
            Croptosis.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private boolean loadConfig(JsonObject fileConfig) {
        try {
            this.configData = this.toNbtCompound(fileConfig);
            return true;
        }
        catch (Exception e) {
            Croptosis.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    public boolean loadConfig(class_2487 config) {
        try {
            this.configData = config;
            return true;
        }
        catch (Exception e) {
            Croptosis.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private void createFile(JsonObject contents, boolean overwrite) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        contents = Config.getJsonObject(gson.toJson((JsonElement)contents));
        File file = new File(CONFIG_FILE);
        if (file.exists() && !overwrite) {
            return;
        }
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        file.setReadable(true);
        file.setWritable(true);
        file.setExecutable(true);
        if (contents == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(file);){
            String json = gson.toJson((JsonElement)contents).replace("\n", "").replace("\r", "");
            writer.write(gson.toJson((JsonElement)Config.getJsonObject(json)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readFile(File file) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        scanner.useDelimiter("\\Z");
        String result = scanner.next();
        scanner.close();
        return result;
    }

    public static JsonObject getJsonObject(String json) {
        return JsonParser.parseString((String)json).getAsJsonObject();
    }
}

