/*
 * Decompiled with CFR 0.152.
 */
package wraith.croptosis.item;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3621;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;
import wraith.croptosis.util.CUtils;
import wraith.croptosis.util.Config;

public class WateringCanItem
extends class_1792 {
    private final int range;
    private final double chance;
    private final int capacity;

    public WateringCanItem(int range, int capacity, double chance, class_1792.class_1793 settings) {
        super(settings.method_7889(1));
        this.range = Math.min(range, 10);
        this.capacity = capacity;
        this.chance = class_3532.method_15350((double)chance, (double)0.0, (double)1.0);
    }

    public static boolean isFilled(class_1799 stack) {
        class_1792 class_17922;
        if (!Config.getInstance().allowWateringCans() || stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof WateringCanItem)) {
            return false;
        }
        WateringCanItem wateringCan = (WateringCanItem)class_17922;
        class_2487 tag = stack.method_7941(CUtils.capitalize("croptosis"));
        return tag != null && (tag.method_10545("StoredFluid") && tag.method_10550("StoredFluid") > 0 || wateringCan.capacity == -1);
    }

    public int method_7881(class_1799 stack) {
        return 10;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!Config.getInstance().allowWateringCans()) {
            return class_1271.method_22431((Object)user.method_5998(hand));
        }
        class_1799 stack = user.method_5998(hand);
        WateringCanItem wateringCan = (WateringCanItem)stack.method_7909();
        if (!WateringCanItem.isFilled(stack)) {
            class_3965 hitResult = WateringCanItem.method_7872((class_1937)world, (class_1657)user, (class_3959.class_242)class_3959.class_242.field_1347);
            if (hitResult.method_17783() == class_239.class_240.field_1333 || hitResult.method_17783() != class_239.class_240.field_1332) {
                return class_1271.method_22430((Object)stack);
            }
            class_2338 pos = hitResult.method_17777();
            if (world.method_8316(pos).method_15772() instanceof class_3621) {
                class_2487 tag = stack.method_7911(CUtils.capitalize("croptosis"));
                tag.method_10569("StoredFluid", this.capacity);
            }
        } else {
            int xPos = (int)Math.floor(user.method_24515().method_10263());
            int yPos = (int)Math.floor(user.method_24515().method_10264());
            int zPos = (int)Math.floor(user.method_24515().method_10260());
            class_2487 tag = stack.method_7911(CUtils.capitalize("croptosis"));
            if (wateringCan.capacity > 0) {
                tag.method_10569("StoredFluid", tag.method_10550("StoredFluid") - 1);
            }
            world.method_8396(user, user.method_24515(), class_3417.field_15025, class_3419.field_15256, 1.0f, 1.0f);
            for (float x = -2.0f; x <= 2.0f; x += 2.0f) {
                for (float z = -2.0f; z <= 2.0f; z += 2.0f) {
                    world.method_8406((class_2394)class_2398.field_18306, (double)((float)xPos + 0.5f) + (double)x * CUtils.random.nextDouble(), (double)((float)yPos + 3.0f) - CUtils.random.nextDouble(), (double)zPos + 0.5 + (double)z * CUtils.random.nextDouble(), (double)x, 1.0, (double)z);
                }
            }
            if (world.field_9236) {
                return class_1271.method_22427((Object)stack);
            }
            for (int x = -this.range; x <= this.range; ++x) {
                for (int y = -3; y <= 3; ++y) {
                    for (int z = -this.range; z <= this.range; ++z) {
                        class_2256 fertilizable;
                        class_2338 cropPos;
                        class_2680 state;
                        class_2248 class_22482;
                        if (CUtils.random.nextDouble() > this.chance || !((class_22482 = (state = world.method_8320(cropPos = new class_2338(xPos + x, yPos + y, zPos + z))).method_26204()) instanceof class_2256) || !(fertilizable = (class_2256)class_22482).method_9651((class_1922)world, cropPos, state, false) || !fertilizable.method_9650(world, CUtils.random, cropPos, state)) continue;
                        fertilizable.method_9652((class_3218)world, CUtils.random, cropPos, state);
                    }
                }
            }
        }
        return class_1271.method_22427((Object)stack);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        if (!Config.getInstance().allowWateringCans()) {
            tooltip.add((class_2561)new class_2588("tooltip.croptosis.watering_can.disabled"));
            return;
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof WateringCanItem)) {
            return;
        }
        WateringCanItem wateringCan = (WateringCanItem)class_17922;
        class_2487 tag = stack.method_7941(CUtils.capitalize("croptosis"));
        int fluidAmount = tag != null && tag.method_10545("StoredFluid") ? tag.method_10550("StoredFluid") : 0;
        String fluidAmountStr = fluidAmount == -1 ? "\u221e" : String.valueOf(fluidAmount);
        String capacityStr = wateringCan.capacity == -1 ? "\u221e" : String.valueOf(wateringCan.capacity);
        tooltip.add((class_2561)new class_2588("tooltip.croptosis.watering_can.range", new Object[]{new class_2585(String.valueOf(wateringCan.range)).method_27694(style -> style.method_27703(class_5251.method_27719((String)new class_2588("tooltip.croptosis.watering_can.range.arg_color").getString())))}));
        tooltip.add((class_2561)new class_2588("tooltip.croptosis.watering_can.fluid", new Object[]{new class_2585(fluidAmountStr).method_27694(style -> style.method_27703(class_5251.method_27719((String)new class_2588("tooltip.croptosis.watering_can.fluid.arg_color1").getString()))), new class_2585(capacityStr).method_27694(style -> style.method_27703(class_5251.method_27719((String)new class_2588("tooltip.croptosis.watering_can.fluid.arg_color2").getString())))}));
        tooltip.add((class_2561)new class_2588("tooltip.croptosis.watering_can.chance", new Object[]{new class_2585(CUtils.formatDouble(wateringCan.chance * 100.0)).method_27694(style -> style.method_27703(class_5251.method_27719((String)new class_2588("tooltip.croptosis.watering_can.chance.arg_color").getString()))), new class_2585("%").method_27694(style -> style.method_27703(class_5251.method_27719((String)new class_2588("tooltip.croptosis.watering_can.chance.percent_color").getString())))}));
    }
}

