/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.respawnablepets.mixin;

import java.util.UUID;
import moriyashiine.respawnablepets.client.packet.SpawnSmokeParticlesPacket;
import moriyashiine.respawnablepets.common.RespawnablePets;
import moriyashiine.respawnablepets.common.registry.ModItems;
import moriyashiine.respawnablepets.common.registry.ModSoundEvents;
import moriyashiine.respawnablepets.common.registry.ModTags;
import moriyashiine.respawnablepets.common.world.ModWorldState;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1282;
import net.minecraft.class_1283;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Shadow
    public abstract class_1283 method_6066();

    @Shadow
    public abstract float method_6032();

    @Shadow
    protected abstract float method_6107();

    @Shadow
    public abstract float method_6017();

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void respawnablepets$respawnPetsOnTick(CallbackInfo ci) {
        int timeToRespawn = RespawnablePets.config.timeToRespawn;
        if (timeToRespawn >= 0 && this.field_6002.method_8532() % 24000L == (long)timeToRespawn) {
            RespawnablePets.respawnPets((class_1309)class_1309.class.cast((Object)this));
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void respawnablepets$togglePetRespawning(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1297 attacker;
        if (!this.field_6002.field_9236 && (attacker = source.method_5526()) instanceof class_1657 && (player = (class_1657)attacker).method_6047().method_31574(ModItems.ETHERIC_GEM)) {
            class_2487 stored = this.method_5647(new class_2487());
            if (stored.method_25928("Owner") && player.method_5667().equals(stored.method_25926("Owner"))) {
                if (ModTags.BLACKLISTED.method_15141((Object)this.method_5864())) {
                    player.method_7353((class_2561)new class_2588("respawnablepets.message.blacklisted", new Object[]{this.method_5476()}), true);
                } else {
                    ModWorldState worldState = ModWorldState.get(this.field_6002);
                    if (this.canRespawn(worldState)) {
                        player.method_7353((class_2561)new class_2588("respawnablepets.message.disable_respawn", new Object[]{this.method_5476()}), true);
                        for (int i = worldState.petsToRespawn.size() - 1; i >= 0; --i) {
                            if (!worldState.petsToRespawn.get(i).equals(this.method_5667())) continue;
                            worldState.petsToRespawn.remove(i);
                            worldState.method_80();
                        }
                    } else {
                        player.method_7353((class_2561)new class_2588("respawnablepets.message.enable_respawn", new Object[]{this.method_5476()}), true);
                        worldState.petsToRespawn.add(this.method_5667());
                        worldState.method_80();
                    }
                }
            } else {
                player.method_7353((class_2561)new class_2588("respawnablepets.message.not_owner", new Object[]{this.method_5476()}), true);
            }
            cir.cancel();
        }
    }

    @Inject(method={"applyDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getHealth()F")}, cancellable=true)
    private void respawnablepets$storePetOnDeath(class_1282 source, float amount, CallbackInfo ci) {
        if (!this.field_6002.field_9236) {
            ModWorldState worldState = ModWorldState.get(this.field_6002);
            if (this.method_6032() - amount <= 0.0f && this.canRespawn(worldState)) {
                class_2487 stored = new class_2487();
                this.method_5786(stored);
                worldState.storedPets.add(stored);
                worldState.method_80();
                PlayerLookup.tracking((class_1297)this).forEach(foundPlayer -> SpawnSmokeParticlesPacket.send(foundPlayer, this));
                this.method_5783(ModSoundEvents.ENTITY_GENERIC_TELEPORT, this.method_6107(), this.method_6017());
                this.method_5650(class_1297.class_5529.field_26999);
                class_1657 owner = this.findOwnerByUUID(stored.method_25926("Owner"));
                if (owner != null && this.field_6002.method_8450().method_8355(class_1928.field_19398)) {
                    owner.method_7353(this.method_6066().method_5548(), false);
                }
                ci.cancel();
            }
        }
    }

    @Unique
    private class_1657 findOwnerByUUID(UUID uuid) {
        for (class_3218 serverWorld : this.field_6002.method_8503().method_3738()) {
            class_1657 player = serverWorld.method_18470(uuid);
            if (player == null) continue;
            return player;
        }
        return null;
    }

    @Unique
    private boolean canRespawn(ModWorldState worldState) {
        for (UUID uuid : worldState.petsToRespawn) {
            if (!this.method_5667().equals(uuid)) continue;
            return true;
        }
        return false;
    }
}

