/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.sincereloyalty.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import ladysnake.sincereloyalty.storage.InventoryTridentEntry;
import ladysnake.sincereloyalty.storage.LoyalTridentStorage;
import ladysnake.sincereloyalty.storage.TridentEntry;
import ladysnake.sincereloyalty.storage.WorldTridentEntry;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public final class OwnedTridents
implements Iterable<TridentEntry> {
    static final OwnedTridents EMPTY = new OwnedTridents();
    private final LoyalTridentStorage parentStorage;
    private final Map<UUID, TridentEntry> ownedTridents;

    private OwnedTridents() {
        this.parentStorage = null;
        this.ownedTridents = Collections.emptyMap();
    }

    OwnedTridents(LoyalTridentStorage parentStorage) {
        this.parentStorage = parentStorage;
        this.ownedTridents = new HashMap<UUID, TridentEntry>();
    }

    public void storeTridentPosition(UUID tridentUuid, UUID tridentEntityUuid, class_2338 lastPos) {
        TridentEntry entry = this.ownedTridents.get(tridentUuid);
        if (entry instanceof WorldTridentEntry) {
            ((WorldTridentEntry)entry).updateLastPos(tridentEntityUuid, lastPos);
        } else {
            this.ownedTridents.put(tridentUuid, new WorldTridentEntry(this.parentStorage.world, tridentUuid, tridentUuid, lastPos));
        }
    }

    public void storeTridentHolder(UUID tridentUuid, class_1657 holder) {
        TridentEntry entry = this.ownedTridents.get(tridentUuid);
        if (!(entry instanceof InventoryTridentEntry) || !((InventoryTridentEntry)entry).isHolder(holder)) {
            this.addEntry(new InventoryTridentEntry(this.parentStorage.world, tridentUuid, holder.method_5667()));
        }
    }

    private void addEntry(@NotNull TridentEntry entry) {
        this.ownedTridents.put(entry.getTridentUuid(), entry);
    }

    public void clearTridentPosition(UUID tridentUuid) {
        this.ownedTridents.remove(tridentUuid);
    }

    @Override
    @NotNull
    public Iterator<TridentEntry> iterator() {
        return this.ownedTridents.values().iterator();
    }

    public boolean isEmpty() {
        return this.ownedTridents.isEmpty();
    }

    public void fromTag(class_2487 ownerNbt) {
        class_2499 tridentsNbt = ownerNbt.method_10554("tridents", 10);
        for (int j = 0; j < tridentsNbt.size(); ++j) {
            TridentEntry trident = TridentEntry.fromNbt(this.parentStorage.world, tridentsNbt.method_10602(j));
            if (trident == null) continue;
            this.addEntry(trident);
        }
    }

    public void toTag(class_2487 ownerNbt) {
        class_2499 tridentsNbt = new class_2499();
        for (TridentEntry trident : this.ownedTridents.values()) {
            tridentsNbt.add((Object)trident.toNbt(new class_2487()));
        }
        ownerNbt.method_10566("tridents", (class_2520)tridentsNbt);
    }
}

