/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.sincereloyalty.storage;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import ladysnake.sincereloyalty.LoyalTrident;
import ladysnake.sincereloyalty.storage.OwnedTridents;
import ladysnake.sincereloyalty.storage.TridentEntry;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1685;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2660;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import org.jetbrains.annotations.NotNull;

public final class LoyalTridentStorage
extends class_18 {
    private final Map<UUID, OwnedTridents> tridents = new HashMap<UUID, OwnedTridents>();
    final class_3218 world;

    public static LoyalTridentStorage get(class_3218 world) {
        String id = "impaled_trident_storage";
        return (LoyalTridentStorage)world.method_17983().method_17924(tag -> LoyalTridentStorage.fromNbt(world, tag), () -> new LoyalTridentStorage(world), "impaled_trident_storage");
    }

    public LoyalTridentStorage(class_3218 world) {
        this.world = world;
    }

    public boolean hasTridents(class_1657 player) {
        return !this.tridents.getOrDefault(player.method_5667(), OwnedTridents.EMPTY).isEmpty();
    }

    public void memorizeTrident(UUID owner, class_1685 trident) {
        class_2338 tridentPos = trident.method_24515();
        this.tridents.computeIfAbsent(owner, o -> new OwnedTridents(this)).storeTridentPosition(LoyalTrident.of(trident).loyaltrident_getTridentUuid(), trident.method_5667(), tridentPos);
    }

    public void memorizeTrident(UUID owner, UUID tridentUuid, class_1657 holder) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)tridentUuid);
        this.tridents.computeIfAbsent(owner, o -> new OwnedTridents(this)).storeTridentHolder(tridentUuid, holder);
    }

    public void forgetTrident(UUID owner, class_1685 trident) {
        this.tridents.getOrDefault(owner, OwnedTridents.EMPTY).clearTridentPosition(LoyalTrident.of(trident).loyaltrident_getTridentUuid());
    }

    public void loadTridents(class_1657 player) {
        for (TridentEntry entry : this.tridents.getOrDefault(player.method_5667(), OwnedTridents.EMPTY)) {
            entry.preloadTrident();
        }
    }

    public boolean recallTridents(class_1657 player) {
        boolean foundAny = false;
        Iterator<TridentEntry> it = this.tridents.getOrDefault(player.method_5667(), OwnedTridents.EMPTY).iterator();
        while (it.hasNext()) {
            class_1685 trident = it.next().findTrident();
            if (trident == null) {
                it.remove();
                continue;
            }
            float initialDistance = trident.method_5739((class_1297)player);
            ((LoyalTrident)trident).loyaltrident_wakeUp();
            if (initialDistance > 64.0f) {
                class_243 newPos = player.method_19538().method_1019(trident.method_19538().method_1020(player.method_19538()).method_1029().method_1021(64.0));
                trident.method_29495(newPos);
            }
            ((LoyalTrident)trident).loyaltrident_setReturnSlot(player.method_31548().field_7545);
            this.world.method_8465(player, trident.method_23317(), trident.method_23318(), trident.method_23321(), class_3417.field_14698, trident.method_5634(), 2.0f, 0.7f);
            ((class_3222)player).field_13987.field_14127.method_10743((class_2596)new class_2660(new class_2960("item.trident.return"), trident.method_5634(), trident.method_19538(), trident.method_5739((class_1297)player) / 8.0f, 0.7f));
            foundAny = true;
        }
        return foundAny;
    }

    public static LoyalTridentStorage fromNbt(class_3218 world, class_2487 tag) {
        LoyalTridentStorage ret = new LoyalTridentStorage(world);
        class_2499 ownersNbt = tag.method_10554("trident_owners", 10);
        for (int i = 0; i < ownersNbt.size(); ++i) {
            OwnedTridents tridents = new OwnedTridents(ret);
            class_2487 ownerNbt = ownersNbt.method_10602(i);
            UUID ownerUuid = ownerNbt.method_25926("owner_uuid");
            tridents.fromTag(ownerNbt);
            ret.tridents.put(ownerUuid, tridents);
        }
        return ret;
    }

    @NotNull
    public class_2487 method_75(class_2487 tag) {
        if (!this.tridents.isEmpty()) {
            class_2499 ownersNbt = new class_2499();
            this.tridents.forEach((ownerUuid, tridents) -> {
                if (!tridents.isEmpty()) {
                    class_2487 ownerNbt = new class_2487();
                    ownerNbt.method_25927("owner_uuid", ownerUuid);
                    tridents.toTag(ownerNbt);
                    ownersNbt.add((Object)ownerNbt);
                }
            });
            tag.method_10566("trident_owners", (class_2520)ownersNbt);
        }
        return tag;
    }
}

