/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.data.PlayerLocation;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.VisiblePlayerListItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class SendVisiblePlayerListPacket
extends BaseS2CMessage {
    public final List<PlayerLocation> players;
    public final class_5321<class_1937> dim;

    public SendVisiblePlayerListPacket(List<PlayerLocation> p, class_5321<class_1937> d) {
        this.players = p;
        this.dim = d;
    }

    SendVisiblePlayerListPacket(class_2540 buf) {
        int s = buf.method_10816();
        this.players = new ArrayList<PlayerLocation>(s);
        for (int i = 0; i < s; ++i) {
            PlayerLocation p = new PlayerLocation();
            long most = buf.readLong();
            long least = buf.readLong();
            p.uuid = new UUID(most, least);
            p.name = buf.method_10800(Short.MAX_VALUE);
            p.x = buf.method_10816();
            p.z = buf.method_10816();
            this.players.add(p);
        }
        this.dim = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)buf.method_10810());
    }

    public static void sendAll() {
        ArrayList<VisiblePlayerListItem> playerList = new ArrayList<VisiblePlayerListItem>();
        for (class_3222 player : FTBChunksAPI.getManager().teamManager.server.method_3760().method_14571()) {
            VisiblePlayerListItem item = new VisiblePlayerListItem();
            item.player = player;
            item.data = FTBChunksAPI.getManager().getData(player);
            item.location = new PlayerLocation((class_1657)player);
            playerList.add(item);
        }
        for (VisiblePlayerListItem self : playerList) {
            class_5321 dim = self.player.field_6002.method_27983();
            ArrayList<PlayerLocation> players = new ArrayList<PlayerLocation>();
            for (VisiblePlayerListItem other : playerList) {
                if (other.player.field_6002 != self.player.field_6002 || !self.data.canUse(other.player, FTBChunksTeamData.LOCATION_MODE)) continue;
                players.add(other.location);
            }
            new SendVisiblePlayerListPacket(players, (class_5321<class_1937>)dim).sendTo(self.player);
        }
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_VISIBLE_PLAYER_LIST;
    }

    public void write(class_2540 buf) {
        buf.method_10804(this.players.size());
        for (PlayerLocation p : this.players) {
            buf.writeLong(p.uuid.getMostSignificantBits());
            buf.writeLong(p.uuid.getLeastSignificantBits());
            buf.method_10788(p.name, Short.MAX_VALUE);
            buf.method_10804(p.x);
            buf.method_10804(p.z);
        }
        buf.method_10812(this.dim.method_29177());
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunks.PROXY.updateVisiblePlayerList(this);
    }
}

