/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.AllyMode;
import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.ClaimResults;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.data.ForceLoadMode;
import dev.ftb.mods.ftbchunks.event.ClaimedChunkEvent;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PrivacyMode;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.property.BooleanProperty;
import dev.ftb.mods.ftbteams.property.PrivacyProperty;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class FTBChunksTeamData {
    public static final BooleanProperty ALLOW_FAKE_PLAYERS = new BooleanProperty(new class_2960("ftbchunks", "allow_fake_players"), Boolean.valueOf(true));
    public static final PrivacyProperty BLOCK_EDIT_MODE = new PrivacyProperty(new class_2960("ftbchunks", "block_edit_mode"), PrivacyMode.ALLIES);
    public static final PrivacyProperty BLOCK_INTERACT_MODE = new PrivacyProperty(new class_2960("ftbchunks", "block_interact_mode"), PrivacyMode.ALLIES);
    public static final PrivacyProperty MINIMAP_MODE = new PrivacyProperty(new class_2960("ftbchunks", "minimap_mode"), PrivacyMode.ALLIES);
    public static final PrivacyProperty LOCATION_MODE = new PrivacyProperty(new class_2960("ftbchunks", "location_mode"), PrivacyMode.ALLIES);
    public final ClaimedChunkManager manager;
    private final Team team;
    public final Path file;
    private boolean shouldSave;
    public int maxClaimChunks;
    public int maxForceLoadChunks;
    public int extraClaimChunks;
    public int extraForceLoadChunks;
    public final Set<UUID> forceLoadMembers;
    private Boolean canForceLoadChunks;
    public int prevChunkX = Integer.MAX_VALUE;
    public int prevChunkZ = Integer.MAX_VALUE;
    public String lastChunkID = "";

    public FTBChunksTeamData(ClaimedChunkManager m, Path f, Team t) {
        this.manager = m;
        this.team = t;
        this.file = f;
        this.shouldSave = false;
        this.maxClaimChunks = -1;
        this.maxForceLoadChunks = -1;
        this.extraClaimChunks = 0;
        this.extraForceLoadChunks = 0;
        this.forceLoadMembers = new HashSet<UUID>();
    }

    public String toString() {
        return this.team.getStringID();
    }

    public ClaimedChunkManager getManager() {
        return this.manager;
    }

    public Team getTeam() {
        return this.team;
    }

    public UUID getTeamId() {
        return this.team.getId();
    }

    public Collection<ClaimedChunk> getClaimedChunks() {
        ArrayList<ClaimedChunk> list = new ArrayList<ClaimedChunk>();
        for (ClaimedChunk chunk : this.manager.claimedChunks.values()) {
            if (chunk.teamData != this) continue;
            list.add(chunk);
        }
        return list;
    }

    public Collection<ClaimedChunk> getForceLoadedChunks() {
        ArrayList<ClaimedChunk> list = new ArrayList<ClaimedChunk>();
        for (ClaimedChunk chunk : this.manager.claimedChunks.values()) {
            if (chunk.teamData != this || !chunk.isForceLoaded()) continue;
            list.add(chunk);
        }
        return list;
    }

    public void updateLimits(class_3222 ownerPlayer) {
        if (this.maxClaimChunks != -1 && this.team.getType().isParty() && !ownerPlayer.method_5667().equals(this.team.getOwner())) {
            return;
        }
        int c = FTBChunksWorldConfig.getMaxClaimedChunks(this, ownerPlayer);
        int f = FTBChunksWorldConfig.getMaxForceLoadedChunks(this, ownerPlayer);
        if (this.maxClaimChunks != c || this.maxForceLoadChunks != f) {
            this.maxClaimChunks = c;
            this.maxForceLoadChunks = f;
            for (class_3222 p : this.team.getOnlineMembers()) {
                SendGeneralDataPacket.send(this, p);
            }
            this.save();
        }
    }

    public ClaimResult claim(class_2168 source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.claimedChunks.get(pos);
        if (chunk != null) {
            return ClaimResults.ALREADY_CLAIMED;
        }
        if (FTBChunksWorldConfig.CLAIM_DIMENSION_BLACKLIST_SET.contains(pos.dimension)) {
            return ClaimResults.DIMENSION_FORBIDDEN;
        }
        if (!this.team.getType().isServer() && this.getClaimedChunks().size() >= FTBChunksWorldConfig.getMaxClaimedChunks(this, FTBChunksTeamData.playerOrNull(source))) {
            return ClaimResults.NOT_ENOUGH_POWER;
        }
        chunk = new ClaimedChunk(this, pos);
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_CLAIM.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        this.manager.claimedChunks.put(pos, chunk);
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_CLAIM.invoker()).after(source, chunk);
        this.save();
        return chunk;
    }

    public ClaimResult unclaim(class_2168 source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (chunk.teamData != this && !source.method_9259(2) && !source.method_9211().method_3724()) {
            return ClaimResults.NOT_OWNER;
        }
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_UNCLAIM.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.unclaim(source, true);
        return chunk;
    }

    public ClaimResult load(class_2168 source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (chunk.teamData != this && !source.method_9259(2) && !source.method_9211().method_3724()) {
            return ClaimResults.NOT_OWNER;
        }
        if (chunk.isForceLoaded()) {
            return ClaimResults.ALREADY_LOADED;
        }
        if (!this.team.getType().isServer() && this.getForceLoadedChunks().size() >= FTBChunksWorldConfig.getMaxForceLoadedChunks(this, FTBChunksTeamData.playerOrNull(source))) {
            return ClaimResults.NOT_ENOUGH_POWER;
        }
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_LOAD.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.setForceLoadedTime(System.currentTimeMillis());
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_LOAD.invoker()).after(source, chunk);
        chunk.teamData.save();
        chunk.sendUpdateToAll();
        return chunk;
    }

    public ClaimResult unload(class_2168 source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (!(chunk.teamData == this || source.method_9259(2) || source.method_9211().method_3724() || source.method_9228() instanceof class_3222 && this.isTeamMember(source.method_9228().method_5667()))) {
            return ClaimResults.NOT_OWNER;
        }
        if (!chunk.isForceLoaded()) {
            return ClaimResults.NOT_LOADED;
        }
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_UNLOAD.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.unload(source);
        return chunk;
    }

    public void save() {
        this.shouldSave = true;
        this.team.save();
    }

    public boolean isTeamMember(UUID p) {
        if (p.equals(this.getTeamId())) {
            return true;
        }
        return this.team.equals((Object)FTBTeamsAPI.getManager().getPlayerTeam(p));
    }

    public boolean isAlly(UUID p) {
        if (FTBChunksWorldConfig.ALLY_MODE.get() == AllyMode.FORCED_ALL || this.team.isMember(p)) {
            return true;
        }
        if (FTBChunksWorldConfig.ALLY_MODE.get() == AllyMode.FORCED_NONE) {
            return false;
        }
        return this.team.isAlly(p);
    }

    public boolean canUse(class_3222 p, PrivacyProperty property) {
        PrivacyMode mode = (PrivacyMode)this.team.getProperty((TeamProperty)property);
        if (mode == PrivacyMode.PUBLIC) {
            return true;
        }
        if (mode == PrivacyMode.ALLIES) {
            if (PlayerHooks.isFake((class_1657)p)) {
                return (Boolean)this.team.getProperty((TeamProperty)ALLOW_FAKE_PLAYERS);
            }
            return this.isAlly(p.method_5667());
        }
        return this.team.isMember(p.method_5667());
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.method_10569("max_claim_chunks", this.maxClaimChunks);
        tag.method_10569("max_force_load_chunks", this.maxForceLoadChunks);
        tag.method_10569("extra_claim_chunks", this.extraClaimChunks);
        tag.method_10569("extra_force_load_chunks", this.extraForceLoadChunks);
        class_2499 forceLoadMembersTag = new class_2499();
        for (UUID id : this.forceLoadMembers) {
            forceLoadMembersTag.add((Object)class_2519.method_23256((String)id.toString()));
        }
        tag.method_10566("force_load_members", (class_2520)forceLoadMembersTag);
        class_2487 chunksTag = new class_2487();
        for (ClaimedChunk chunk : this.getClaimedChunks()) {
            String key = chunk.getPos().dimension.method_29177().toString();
            class_2499 chunksListTag = chunksTag.method_10554(key, 10);
            if (chunksListTag.isEmpty()) {
                chunksTag.method_10566(key, (class_2520)chunksListTag);
            }
            SNBTCompoundTag o = new SNBTCompoundTag();
            o.singleLine();
            o.method_10569("x", chunk.getPos().x);
            o.method_10569("z", chunk.getPos().z);
            o.method_10544("time", chunk.getTimeClaimed());
            if (chunk.isForceLoaded()) {
                o.method_10544("force_loaded", chunk.getForceLoadedTime());
            }
            chunksListTag.add((Object)o);
        }
        tag.method_10566("chunks", (class_2520)chunksTag);
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        this.maxClaimChunks = tag.method_10550("max_claim_chunks");
        this.maxForceLoadChunks = tag.method_10550("max_force_load_chunks");
        this.extraClaimChunks = tag.method_10550("extra_claim_chunks");
        this.extraForceLoadChunks = tag.method_10550("extra_force_load_chunks");
        this.forceLoadMembers.clear();
        class_2499 forgeLoadMembersTag = tag.method_10554("force_load_members", 8);
        if (tag.method_10577("chunk_load_offline")) {
            this.forceLoadMembers.add(this.team.getOwner());
        } else {
            for (int i = 0; i < forgeLoadMembersTag.size(); ++i) {
                this.forceLoadMembers.add(UUID.fromString(forgeLoadMembersTag.method_10608(i)));
            }
        }
        this.forceLoadMembers.remove(class_156.field_25140);
        this.canForceLoadChunks = null;
        class_2487 chunksTag = tag.method_10562("chunks");
        for (String key : chunksTag.method_10541()) {
            class_5321 dimKey = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(key));
            class_2499 chunksListTag = chunksTag.method_10554(key, 10);
            for (int i = 0; i < chunksListTag.size(); ++i) {
                class_2487 o = chunksListTag.method_10602(i);
                ClaimedChunk chunk = new ClaimedChunk(this, new ChunkDimPos(dimKey, o.method_10550("x"), o.method_10550("z")));
                chunk.time = o.method_10537("time");
                chunk.forceLoaded = o.method_10537("force_loaded");
                this.manager.claimedChunks.put(chunk.pos, chunk);
            }
        }
    }

    public int getExtraClaimChunks() {
        return this.extraClaimChunks;
    }

    public int getExtraForceLoadChunks() {
        return this.extraForceLoadChunks;
    }

    public void setForceLoadMember(UUID id, boolean val) {
        if (val ? this.forceLoadMembers.add(id) : this.forceLoadMembers.remove(id)) {
            this.save();
            this.canForceLoadChunks = null;
            this.manager.updateForceLoadedChunks();
        }
    }

    public void saveNow() {
        if (this.shouldSave && SNBT.write((Path)this.file, (class_2487)this.serializeNBT())) {
            this.shouldSave = false;
        }
    }

    public boolean canForceLoadChunks() {
        if (this.canForceLoadChunks == null) {
            this.canForceLoadChunks = switch ((ForceLoadMode)((Object)FTBChunksWorldConfig.FORCE_LOAD_MODE.get())) {
                case ForceLoadMode.ALWAYS -> true;
                case ForceLoadMode.NEVER -> false;
                default -> this.hasForceLoadMembers();
            };
        }
        return this.canForceLoadChunks;
    }

    public boolean hasForceLoadMembers() {
        for (UUID uuid : this.team.getMembers()) {
            if (!this.forceLoadMembers.contains(uuid)) continue;
            return true;
        }
        return false;
    }

    public static class_3222 playerOrNull(class_2168 source) {
        class_3222 player;
        class_1297 entity = source.method_9228();
        return entity instanceof class_3222 ? (player = (class_3222)entity) : null;
    }
}

