/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.data.Protection;
import dev.ftb.mods.ftbchunks.data.ProtectionOverride;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ClaimedChunkManager {
    public static final class_5218 DATA_DIR = new class_5218("ftbchunks");
    public final TeamManager teamManager;
    public final Map<UUID, FTBChunksTeamData> teamData;
    public final Map<ChunkDimPos, ClaimedChunk> claimedChunks;
    public Path dataDirectory;
    public Path localDirectory;
    private Map<class_5321<class_1937>, LongOpenHashSet> forceLoadedChunks;

    public ClaimedChunkManager(TeamManager m) {
        this.teamManager = m;
        this.teamData = new HashMap<UUID, FTBChunksTeamData>();
        this.claimedChunks = new HashMap<ChunkDimPos, ClaimedChunk>();
        this.dataDirectory = this.getMinecraftServer().method_27050(DATA_DIR);
        this.localDirectory = Platform.getGameFolder().resolve("local/ftbchunks");
        try {
            if (Files.notExists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            if (Files.notExists(this.localDirectory, new LinkOption[0])) {
                Files.createDirectories(this.localDirectory, new FileAttribute[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initForceLoadedChunks(class_3218 level) {
        int forceLoaded = 0;
        LongOpenHashSet set = this.getForceLoadedChunks().get(level.method_27983());
        if (set == null || level.method_14178() == null) {
            return;
        }
        for (Long pos : set) {
            class_1923 chunkPos = new class_1923(pos.longValue());
            level.method_14178().method_17297(FTBChunksAPI.FORCE_LOADED_TICKET, chunkPos, 2, (Object)chunkPos);
        }
        FTBChunks.LOGGER.info("Force-loaded %d chunks in %s".formatted(forceLoaded, level.method_27983().method_29177()));
    }

    private FTBChunksTeamData loadTeamData(Team team) {
        Path path = this.dataDirectory.resolve(team.getId() + ".snbt");
        FTBChunksTeamData data = new FTBChunksTeamData(this, path, team);
        SNBTCompoundTag dataFile = SNBT.read((Path)path);
        if (dataFile != null) {
            data.deserializeNBT((class_2487)dataFile);
            this.teamData.put(team.getId(), data);
            return data;
        }
        return data;
    }

    public MinecraftServer getMinecraftServer() {
        return this.teamManager.server;
    }

    public FTBChunksTeamData getData(@Nullable Team team) {
        if (team == null) {
            throw new IllegalArgumentException("Team not found!");
        }
        FTBChunksTeamData data = this.teamData.get(team.getId());
        if (data == null) {
            data = this.loadTeamData(team);
            this.teamData.put(team.getId(), data);
        }
        return data;
    }

    public FTBChunksTeamData getData(class_3222 player) {
        return this.getData(FTBTeamsAPI.getPlayerTeam((class_3222)player));
    }

    public boolean hasData(class_3222 player) {
        Team team = FTBTeamsAPI.getManager().getPlayerTeam(player.method_5667());
        return team != null && this.teamData.containsKey(team.getId());
    }

    @Nullable
    public ClaimedChunk getChunk(ChunkDimPos pos) {
        return this.claimedChunks.get(pos);
    }

    public Collection<ClaimedChunk> getAllClaimedChunks() {
        return this.claimedChunks.values();
    }

    public boolean getBypassProtection(UUID player) {
        return this.teamManager.getInternalPlayerTeam(player).getExtraData().method_10577("BypassFTBChunksProtection");
    }

    public void setBypassProtection(UUID player, boolean bypass) {
        this.teamManager.getInternalPlayerTeam(player).getExtraData().method_10556("BypassFTBChunksProtection", bypass);
        this.teamManager.getInternalPlayerTeam(player).save();
    }

    public boolean protect(@Nullable class_1297 entity, class_1268 hand, class_2338 pos, Protection protection) {
        if (!(entity instanceof class_3222) || ((Boolean)FTBChunksWorldConfig.DISABLE_PROTECTION.get()).booleanValue()) {
            return false;
        }
        class_3222 player = (class_3222)entity;
        boolean isFake = PlayerHooks.isFake((class_1657)player);
        if (isFake && ((ProtectionOverride)((Object)FTBChunksWorldConfig.FAKE_PLAYERS.get())).isOverride()) {
            return ((ProtectionOverride)((Object)FTBChunksWorldConfig.FAKE_PLAYERS.get())).getProtect();
        }
        ClaimedChunk chunk = this.getChunk(new ChunkDimPos(player.field_6002, pos));
        if (chunk != null) {
            ProtectionOverride override = protection.override(player, pos, hand, chunk);
            if (override.isOverride()) {
                return override.getProtect();
            }
            return isFake || !this.getBypassProtection(player.method_5667());
        }
        if (FTBChunksWorldConfig.noWilderness(player)) {
            ProtectionOverride override = protection.override(player, pos, hand, null);
            if (override.isOverride()) {
                return override.getProtect();
            }
            if (!isFake && this.getBypassProtection(player.method_5667())) {
                return false;
            }
            player.method_7353((class_2561)new class_2585("You need to claim this chunk to interact with blocks here!"), true);
            return true;
        }
        return false;
    }

    public void updateForceLoadedChunks() {
        this.forceLoadedChunks = null;
    }

    public Map<class_5321<class_1937>, LongOpenHashSet> getForceLoadedChunks() {
        if (this.forceLoadedChunks == null) {
            this.forceLoadedChunks = new HashMap<class_5321<class_1937>, LongOpenHashSet>();
            for (ClaimedChunk chunk : this.claimedChunks.values()) {
                if (!chunk.isActuallyForceLoaded()) continue;
                this.forceLoadedChunks.computeIfAbsent((class_5321<class_1937>)chunk.pos.dimension, k -> new LongOpenHashSet()).add(class_1923.method_8331((int)chunk.pos.x, (int)chunk.pos.z));
            }
            this.forceLoadedChunks = this.forceLoadedChunks.isEmpty() ? Collections.emptyMap() : this.forceLoadedChunks;
        }
        return this.forceLoadedChunks;
    }

    public boolean isChunkForceLoaded(class_5321<class_1937> dimension, int x, int z) {
        LongOpenHashSet set = this.getForceLoadedChunks().get(dimension);
        return set != null && set.contains(class_1923.method_8331((int)x, (int)z));
    }
}

