/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.RegionSyncKey;
import dev.ftb.mods.ftbchunks.client.map.RenderMapImageTask;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import java.io.IOException;
import net.minecraft.class_1011;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class MapRegion
implements MapTask {
    public static final Color4I GRID_COLOR = Color4I.rgba((int)70, (int)70, (int)70, (int)50);
    public final MapDimension dimension;
    public final XZ pos;
    private MapRegionData data;
    private boolean isLoadingData;
    public boolean saveData;
    private class_1011 renderedMapImage;
    private boolean updateRenderedMapImage;
    public boolean updateRenderedMapTexture;
    private int renderedMapImageTextureId;
    public boolean mapImageLoaded;
    public boolean renderingMapImage;

    public MapRegion(MapDimension d, XZ p) {
        this.dimension = d;
        this.pos = p;
        this.data = null;
        this.isLoadingData = false;
        this.saveData = false;
        this.renderedMapImage = null;
        this.updateRenderedMapImage = true;
        this.updateRenderedMapTexture = true;
        this.renderedMapImageTextureId = -1;
        this.mapImageLoaded = false;
    }

    public void created() {
        this.dimension.saveData = true;
    }

    public boolean isDataLoaded() {
        return this.data != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRegionData getDataBlocking() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            return this.getDataBlockingNoSync();
        }
    }

    public MapRegionData getDataBlockingNoSync() {
        if (this.data != null) {
            return this.data;
        }
        this.data = new MapRegionData(this);
        try {
            this.data.read();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this.data;
    }

    @Nullable
    public MapRegionData getData() {
        if (this.data == null && !this.isLoadingData) {
            this.isLoadingData = true;
            FTBChunks.EXECUTOR.execute(this::getDataBlocking);
        }
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_1011 getRenderedMapImage() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            if (this.renderedMapImage == null) {
                this.renderedMapImage = new class_1011(class_1011.class_1012.field_4997, 512, 512, true);
                this.renderedMapImage.method_4326(0, 0, 512, 512, 0);
                this.update(false);
            }
        }
        if (this.updateRenderedMapImage && !this.renderingMapImage) {
            this.updateRenderedMapImage = false;
            this.mapImageLoaded = false;
            this.renderingMapImage = true;
            FTBChunks.EXECUTOR.execute(new RenderMapImageTask(this));
        }
        return this.renderedMapImage;
    }

    public int getRenderedMapImageTextureId() {
        if (this.renderedMapImageTextureId == -1) {
            this.renderedMapImageTextureId = FTBChunksClient.generateTextureId(512, 512);
        }
        this.getRenderedMapImage();
        if (this.updateRenderedMapTexture) {
            this.mapImageLoaded = false;
            class_310.method_1551().method_20493(() -> {
                RenderSystem.bindTexture((int)this.renderedMapImageTextureId);
                this.uploadRenderedMapImage();
                this.mapImageLoaded = true;
                FTBChunksClient.updateMinimap = true;
            });
            this.updateRenderedMapTexture = false;
        }
        return this.renderedMapImageTextureId;
    }

    public void release() {
        if (this.saveData && this.data != null) {
            try {
                this.data.write();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.data = null;
        this.isLoadingData = false;
        this.releaseMapImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMapImage() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            if (this.renderedMapImage != null) {
                this.renderedMapImage.close();
                this.renderedMapImage = null;
            }
        }
        if (this.renderedMapImageTextureId != -1) {
            GlStateManager._deleteTexture((int)this.renderedMapImageTextureId);
            this.renderedMapImageTextureId = -1;
        }
        this.mapImageLoaded = false;
    }

    @Override
    public void runMapTask() throws Exception {
        if (this.data != null) {
            this.data.write();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderedMapImageRGBA(int x, int z, int col) {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            this.renderedMapImage.method_4305(x, z, col);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadRenderedMapImage() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            this.renderedMapImage.method_4301(0, 0, 0, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterImageRenderTask() {
        Object object = this.dimension.manager.lock;
        synchronized (object) {
            this.updateRenderedMapTexture = true;
            FTBChunksClient.updateMinimap = true;
            this.renderingMapImage = false;
        }
    }

    public void update(boolean save) {
        if (save) {
            this.saveData = true;
            this.dimension.saveData = true;
        }
        this.updateRenderedMapImage = true;
        this.updateRenderedMapTexture = true;
        FTBChunksClient.updateMinimap = true;
    }

    public MapRegion offset(int x, int z) {
        return this.dimension.getRegion(this.pos.offset(x, z));
    }

    public RegionSyncKey getSyncKey() {
        RegionSyncKey key = new RegionSyncKey();
        key.dim = this.dimension.dimension;
        key.x = this.pos.x;
        key.z = this.pos.z;
        key.random = MathUtils.RAND.nextInt();
        return key;
    }

    public double distToPlayer() {
        return MathUtils.distSq((double)((double)this.pos.x * 512.0 + 256.0), (double)((double)this.pos.z * 512.0 + 256.0), (double)class_310.method_1551().field_1724.method_23317(), (double)class_310.method_1551().field_1724.method_23321());
    }

    public String toString() {
        return this.pos.toRegionString();
    }
}

