/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.net.RequestChunkChangePacket;
import dev.ftb.mods.ftbchunks.net.RequestMapDataPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class ChunkScreen
extends BaseScreen {
    public MapDimension dimension = MapDimension.getCurrent();
    public List<ChunkButton> chunkButtons;
    public Set<XZ> selectedChunks;

    public ChunkScreen() {
        FTBChunksClient.alwaysRenderChunksOnMap = true;
        if (MapManager.inst != null) {
            MapManager.inst.updateAllRegions(false);
        }
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void onClosed() {
        FTBChunksClient.alwaysRenderChunksOnMap = false;
        if (MapManager.inst != null) {
            MapManager.inst.updateAllRegions(false);
        }
        super.onClosed();
    }

    public void addWidgets() {
        int sx = this.getX() + (this.width - 240) / 2;
        int sy = this.getY() + (this.height - 240) / 2;
        class_746 player = class_310.method_1551().field_1724;
        class_1923 chunkPos = player.method_31476();
        int startX = chunkPos.field_9181 - 7;
        int startZ = chunkPos.field_9180 - 7;
        this.chunkButtons = new ArrayList<ChunkButton>();
        this.selectedChunks = new LinkedHashSet<XZ>();
        for (int z = 0; z < 15; ++z) {
            for (int x = 0; x < 15; ++x) {
                ChunkButton button = new ChunkButton((Panel)this, XZ.of((int)(startX + x), (int)(startZ + z)));
                button.chunk = this.dimension.getRegion(XZ.regionFromChunk((int)(startX + x), (int)(startZ + z))).getDataBlocking().getChunk(button.chunkPos);
                this.chunkButtons.add(button);
                button.setPos(sx + x * 16, sy + z * 16);
            }
        }
        this.addAll(this.chunkButtons);
        new RequestMapDataPacket(chunkPos.field_9181 - 7, chunkPos.field_9180 - 7, chunkPos.field_9181 + 7, chunkPos.field_9180 + 7).sendToServer();
        this.add(new SimpleButton((Panel)this, (class_2561)new class_2588("ftbchunks.gui.large_map"), Icons.MAP, (simpleButton, mouseButton) -> new LargeMapScreen().openGui()).setPosAndSize(1, 1, 16, 16));
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        if (!this.selectedChunks.isEmpty()) {
            new RequestChunkChangePacket(ChunkScreen.isShiftKeyDown() ? (button.isLeft() ? 2 : 3) : (button.isLeft() ? 0 : 1), this.selectedChunks).sendToServer();
            this.selectedChunks.clear();
            this.playClickSound();
        }
    }

    public boolean keyPressed(Key key) {
        if (key.is(70)) {
            new LargeMapScreen().openGui();
            return true;
        }
        return super.keyPressed(key);
    }

    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        class_746 player = class_310.method_1551().field_1724;
        int sx = x + (w - 240) / 2;
        int sy = y + (h - 240) / 2;
        int r = 70;
        int g = 70;
        int b = 70;
        int a = 100;
        RenderSystem.lineWidth((float)Math.max(2.5f, (float)class_310.method_1551().method_22683().method_4489() / 1920.0f * 2.5f));
        RenderSystem.enableTexture();
        RenderSystem.bindTextureForSetup((int)FTBChunksClient.minimapTextureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        RenderSystem.setShaderTexture((int)0, (int)FTBChunksClient.minimapTextureId);
        GuiHelper.drawTexturedRect((class_4587)matrixStack, (int)sx, (int)sy, (int)240, (int)240, (Color4I)Color4I.WHITE, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        if (!class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)258)) {
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableTexture();
            buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
            class_1159 m = matrixStack.method_23760().method_23761();
            for (int gy = 1; gy < 15; ++gy) {
                buffer.method_22918(m, (float)sx, (float)(sy + gy * 16), 0.0f).method_1336(r, g, b, a).method_1344();
                buffer.method_22918(m, (float)(sx + 240), (float)(sy + gy * 16), 0.0f).method_1336(r, g, b, a).method_1344();
            }
            for (int gx = 1; gx < 15; ++gx) {
                buffer.method_22918(m, (float)(sx + gx * 16), (float)sy, 0.0f).method_1336(r, g, b, a).method_1344();
                buffer.method_22918(m, (float)(sx + gx * 16), (float)(sy + 240), 0.0f).method_1336(r, g, b, a).method_1344();
            }
            for (ChunkButton button : this.chunkButtons) {
                MapChunk chunk = button.chunk;
                if (chunk.forceLoadedDate == null) continue;
                int cx = button.getX();
                int cy = button.getY();
                buffer.method_22918(m, (float)cx, (float)cy, 0.0f).method_1336(255, 0, 0, 100).method_1344();
                buffer.method_22918(m, (float)(cx + 16), (float)(cy + 16), 0.0f).method_1336(255, 0, 0, 100).method_1344();
                buffer.method_22918(m, (float)cx + 8.0f, (float)cy, 0.0f).method_1336(255, 0, 0, 100).method_1344();
                buffer.method_22918(m, (float)(cx + 16), (float)cy + 8.0f, 0.0f).method_1336(255, 0, 0, 100).method_1344();
                buffer.method_22918(m, (float)cx, (float)cy + 8.0f, 0.0f).method_1336(255, 0, 0, 100).method_1344();
                buffer.method_22918(m, (float)cx + 8.0f, (float)(cy + 16), 0.0f).method_1336(255, 0, 0, 100).method_1344();
            }
            tessellator.method_1350();
        }
        RenderSystem.enableTexture();
        RenderSystem.lineWidth((float)1.0f);
        double hx = (double)(sx + 112) + MathUtils.mod((double)player.method_23317(), (double)16.0);
        double hy = (double)(sy + 112) + MathUtils.mod((double)player.method_23321(), (double)16.0);
        FaceIcon.getFace((GameProfile)player.method_7334()).draw(matrixStack, (int)(hx - 4.0), (int)(hy - 4.0), 8, 8);
        SendGeneralDataPacket d = FTBChunksClient.generalData;
        if (d != null) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(new class_2588("ftbchunks.gui.claimed"));
            list.add(new class_2585(d.claimed + " / " + d.maxClaimChunks).method_27692(d.claimed > d.maxClaimChunks ? class_124.field_1061 : (d.claimed == d.maxClaimChunks ? class_124.field_1054 : class_124.field_1060)));
            list.add(new class_2588("ftbchunks.gui.force_loaded"));
            list.add(new class_2585(d.loaded + " / " + d.maxForceLoadChunks).method_27692(d.loaded > d.maxForceLoadChunks ? class_124.field_1061 : (d.loaded == d.maxForceLoadChunks ? class_124.field_1054 : class_124.field_1060)));
            for (int i = 0; i < list.size(); ++i) {
                theme.drawString(matrixStack, list.get(i), 3.0f, (float)(this.getScreen().method_4502() - 10 * (list.size() - i) - 1), Color4I.WHITE, 2);
            }
        }
    }

    public class ChunkButton
    extends Button {
        public final XZ chunkPos;
        public MapChunk chunk;

        public ChunkButton(Panel panel, XZ xz) {
            super(panel, class_2585.field_24366, (Icon)Icon.EMPTY);
            this.setSize(16, 16);
            this.chunkPos = xz;
        }

        public void onClicked(MouseButton mouseButton) {
            ChunkScreen.this.selectedChunks.add(this.chunkPos);
        }

        public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            if (this.isMouseOver() || ChunkScreen.this.selectedChunks.contains(this.chunkPos)) {
                Color4I.WHITE.withAlpha(100).draw(matrixStack, x, y, w, h);
                if (ChunkButton.isMouseButtonDown((MouseButton)MouseButton.LEFT) || ChunkButton.isMouseButtonDown((MouseButton)MouseButton.RIGHT)) {
                    ChunkScreen.this.selectedChunks.add(this.chunkPos);
                }
            }
        }

        public void addMouseOverText(TooltipList list) {
            if (this.chunk != null && this.chunk.getTeam() != null) {
                list.add(this.chunk.getTeam().getName());
                Date date = new Date();
                if (class_437.method_25443()) {
                    list.add((class_2561)new class_2585(this.chunk.claimedDate.toLocaleString()).method_27692(class_124.field_1080));
                } else {
                    list.add((class_2561)new class_2585(TimeUtils.prettyTimeString((long)((date.getTime() - this.chunk.claimedDate.getTime()) / 1000L)) + " ago").method_27692(class_124.field_1080));
                }
                if (this.chunk.forceLoadedDate != null) {
                    list.add((class_2561)new class_2588("ftbchunks.gui.force_loaded").method_27692(class_124.field_1061));
                    if (class_437.method_25443()) {
                        list.add((class_2561)new class_2585(this.chunk.forceLoadedDate.toLocaleString()).method_27692(class_124.field_1080));
                    } else {
                        list.add((class_2561)new class_2585(TimeUtils.prettyTimeString((long)((date.getTime() - this.chunk.forceLoadedDate.getTime()) / 1000L)) + " ago").method_27692(class_124.field_1080));
                    }
                }
            }
        }
    }
}

