/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.ExplosionEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.Registries;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftbchunks.FTBChunksCommands;
import dev.ftb.mods.ftbchunks.FTBChunksCommon;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.data.Protection;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.LoginDataPacket;
import dev.ftb.mods.ftbchunks.net.PlayerDeathPacket;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftbchunks.net.SendVisiblePlayerListPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerTransferredTeamOwnershipEvent;
import dev.ftb.mods.ftbteams.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1917;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FTBChunks {
    public static final String MOD_ID = "ftbchunks";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Chunks");
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().create();
    public static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    public static FTBChunks instance;
    public static FTBChunksCommon PROXY;
    public static final int TILES = 15;
    public static final int TILE_SIZE = 16;
    public static final int TILE_OFFSET = 7;
    public static final int MINIMAP_SIZE = 240;
    public static final XZ[] RELATIVE_SPIRAL_POSITIONS;
    public static final Registrar<class_2248> BLOCK_REGISTRY;
    public static boolean ranksMod;

    public FTBChunks() {
        PROXY = (FTBChunksCommon)EnvExecutor.getEnvSpecific(() -> FTBChunksClient::new, () -> FTBChunksCommon::new);
        ranksMod = Platform.isModLoaded((String)"ftbranks");
        FTBChunksNet.init();
        for (int i = 0; i < RELATIVE_SPIRAL_POSITIONS.length; ++i) {
            FTBChunks.RELATIVE_SPIRAL_POSITIONS[i] = MathUtils.getSpiralPoint((int)(i + 1));
        }
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverBeforeStart);
        LifecycleEvent.SERVER_LEVEL_LOAD.register(this::serverLevelLoad);
        TeamManagerEvent.CREATED.register(this::teamManagerCreated);
        TeamManagerEvent.DESTROYED.register(this::teamManagerDestroyed);
        TeamEvent.PLAYER_LOGGED_IN.register(this::loggedIn);
        TeamEvent.CREATED.register(this::teamCreated);
        TeamEvent.LOADED.register(this::teamLoaded);
        TeamEvent.SAVED.register(this::teamSaved);
        TeamEvent.DELETED.register(this::teamDeleted);
        PlayerEvent.PLAYER_QUIT.register(this::loggedOut);
        InteractionEvent.LEFT_CLICK_BLOCK.register(this::blockLeftClick);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        InteractionEvent.RIGHT_CLICK_ITEM.register(this::itemRightClick);
        BlockEvent.BREAK.register(this::blockBreak);
        BlockEvent.PLACE.register(this::blockPlace);
        PlayerEvent.FILL_BUCKET.register(this::fillBucket);
        InteractionEvent.FARMLAND_TRAMPLE.register(this::farmlandTrample);
        EntityEvent.ENTER_SECTION.register(this::enterSection);
        EntityEvent.LIVING_CHECK_SPAWN.register(this::checkSpawn);
        ExplosionEvent.DETONATE.register(this::explosionDetonate);
        EntityEvent.LIVING_DEATH.register(this::playerDeath);
        CommandRegistrationEvent.EVENT.register(FTBChunksCommands::registerCommands);
        TeamEvent.COLLECT_PROPERTIES.register(this::teamConfig);
        TeamEvent.PLAYER_JOINED_PARTY.register(this::playerJoinedParty);
        TeamEvent.OWNERSHIP_TRANSFERRED.register(this::teamOwnershipTransferred);
        PROXY.init();
    }

    private void serverBeforeStart(MinecraftServer server) {
        FTBChunksWorldConfig.CONFIG.load(server.method_27050(FTBChunksWorldConfig.CONFIG_FILE_PATH));
        FTBChunksWorldConfig.CLAIM_DIMENSION_BLACKLIST_SET.clear();
        for (String s : (List)FTBChunksWorldConfig.CLAIM_DIMENSION_BLACKLIST.get()) {
            FTBChunksWorldConfig.CLAIM_DIMENSION_BLACKLIST_SET.add((class_5321<class_1937>)class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(s)));
        }
    }

    private void serverLevelLoad(class_3218 level) {
        if (FTBChunksAPI.manager != null) {
            FTBChunksAPI.manager.initForceLoadedChunks(level);
        } else {
            LOGGER.warn("Level " + level.method_27983().method_29177() + " loaded before FTB Chunks manager was initialized! Unable to force-load chunks");
        }
    }

    private void teamManagerCreated(TeamManagerEvent event) {
        FTBChunksAPI.manager = new ClaimedChunkManager(event.getManager());
    }

    private void teamManagerDestroyed(TeamManagerEvent event) {
        FTBChunksAPI.manager = null;
    }

    private void loggedIn(PlayerLoggedInAfterTeamEvent event) {
        class_3222 player = event.getPlayer();
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.updateLimits(player);
        SNBTCompoundTag config = new SNBTCompoundTag();
        FTBChunksWorldConfig.CONFIG.write(config);
        new LoginDataPacket(event.getTeam().manager.getId(), config).sendTo(player);
        SendGeneralDataPacket.send(data, player);
        SendVisiblePlayerListPacket.sendAll();
        long now = System.currentTimeMillis();
        HashMap<Pair, List> chunksToSend = new HashMap<Pair, List>();
        for (ClaimedChunk claimedChunk : FTBChunksAPI.getManager().claimedChunks.values()) {
            chunksToSend.computeIfAbsent(Pair.of((Object)claimedChunk.pos.dimension, (Object)claimedChunk.teamData.getTeamId()), s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, claimedChunk.pos.x, claimedChunk.pos.z, claimedChunk));
        }
        for (Map.Entry entry : chunksToSend.entrySet()) {
            SendManyChunksPacket packet = new SendManyChunksPacket();
            packet.dimension = (class_5321)((Pair)entry.getKey()).getLeft();
            packet.teamId = (UUID)((Pair)entry.getKey()).getRight();
            packet.chunks = (List)entry.getValue();
            packet.sendTo(player);
        }
        data.setForceLoadMember(player.method_5667(), true);
    }

    private void teamCreated(TeamCreatedEvent teamEvent) {
        FTBChunksAPI.manager.getData(teamEvent.getTeam());
    }

    private void teamLoaded(TeamEvent teamEvent) {
        FTBChunksAPI.manager.getData(teamEvent.getTeam());
    }

    private void teamSaved(TeamEvent teamEvent) {
        FTBChunksAPI.manager.getData(teamEvent.getTeam()).saveNow();
    }

    private void teamDeleted(TeamEvent teamEvent) {
        if (!teamEvent.getTeam().getType().isPlayer()) {
            class_2168 sourceStack = teamEvent.getTeam().manager.server.method_3739();
            HashMap<class_5321, List> chunksToUnclaim = new HashMap<class_5321, List>();
            long now = System.currentTimeMillis();
            for (ClaimedChunk claimedChunk : FTBChunksAPI.manager.getData(teamEvent.getTeam()).getClaimedChunks()) {
                claimedChunk.unclaim(sourceStack, false);
                chunksToUnclaim.computeIfAbsent(claimedChunk.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, claimedChunk.pos.x, claimedChunk.pos.z, null));
            }
            for (Map.Entry entry : chunksToUnclaim.entrySet()) {
                SendManyChunksPacket packet = new SendManyChunksPacket();
                packet.dimension = (class_5321)entry.getKey();
                packet.teamId = class_156.field_25140;
                packet.chunks = (List)entry.getValue();
                packet.sendToAll(sourceStack.method_9211());
            }
        }
    }

    public void loggedOut(class_3222 player) {
        if (!(FTBTeamsAPI.isManagerLoaded() && FTBChunksAPI.isManagerLoaded() && FTBChunksAPI.getManager().hasData(player))) {
            return;
        }
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.setForceLoadMember(player.method_5667(), FTBChunksWorldConfig.getChunkLoadOffline(player));
        FTBChunksAPI.getManager().updateForceLoadedChunks();
    }

    public EventResult blockLeftClick(class_1657 player, class_1268 hand, class_2338 pos, class_2350 face) {
        if (player instanceof class_3222 && FTBChunksAPI.getManager().protect((class_1297)player, hand, pos, Protection.EDIT_BLOCK)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockRightClick(class_1657 player, class_1268 hand, class_2338 pos, class_2350 face) {
        if (player instanceof class_3222 && FTBChunksAPI.getManager().protect((class_1297)player, hand, pos, Protection.INTERACT_BLOCK)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public CompoundEventResult<class_1799> itemRightClick(class_1657 player, class_1268 hand) {
        if (player instanceof class_3222 && FTBChunksAPI.getManager().protect((class_1297)player, hand, new class_2338(player.method_5836(1.0f)), Protection.RIGHT_CLICK_ITEM)) {
            return CompoundEventResult.interruptFalse((Object)player.method_5998(hand));
        }
        return CompoundEventResult.pass();
    }

    public EventResult blockBreak(class_1937 level, class_2338 pos, class_2680 blockState, class_3222 player, @Nullable IntValue intValue) {
        if (FTBChunksAPI.getManager().protect((class_1297)player, class_1268.field_5808, pos, Protection.EDIT_BLOCK)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockPlace(class_1937 level, class_2338 pos, class_2680 blockState, @Nullable class_1297 entity) {
        if (entity instanceof class_3222 && FTBChunksAPI.getManager().protect(entity, class_1268.field_5808, pos, Protection.EDIT_BLOCK)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public CompoundEventResult<class_1799> fillBucket(class_1657 player, class_1937 level, class_1799 emptyBucket, @Nullable class_239 target) {
        if (player instanceof class_3222 && target instanceof class_3965 && FTBChunksAPI.getManager().protect((class_1297)player, class_1268.field_5808, ((class_3965)target).method_17777(), Protection.EDIT_FLUID)) {
            return CompoundEventResult.interrupt((Boolean)false, null);
        }
        return CompoundEventResult.pass();
    }

    public EventResult farmlandTrample(class_1937 world, class_2338 pos, class_2680 blockState, float distance, class_1297 entity) {
        if (entity instanceof class_3222 && FTBChunksAPI.getManager().protect(entity, class_1268.field_5808, pos, Protection.EDIT_BLOCK)) {
            return EventResult.interrupt((Boolean)false);
        }
        return EventResult.pass();
    }

    public void enterSection(class_1297 entity, int chunkX, int chunkY, int chunkZ, int prevX, int prevY, int prevZ) {
        class_3222 player;
        block11: {
            block10: {
                if (chunkX == prevX && chunkZ == prevZ && chunkY != prevY) {
                    return;
                }
                if (!(entity instanceof class_3222)) break block10;
                player = (class_3222)entity;
                if (!PlayerHooks.isFake((class_1657)((class_3222)entity))) break block11;
            }
            return;
        }
        if (!FTBTeamsAPI.isManagerLoaded() || !FTBChunksAPI.isManagerLoaded()) {
            return;
        }
        Team team = FTBTeamsAPI.getPlayerTeam((UUID)player.method_5667());
        if (team == null) {
            return;
        }
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(team);
        if (data.prevChunkX != chunkX || data.prevChunkZ != chunkZ) {
            String s;
            ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos((class_1297)player));
            String string = s = chunk == null ? "-" : chunk.getTeamData().getTeamId().toString();
            if (!data.lastChunkID.equals(s)) {
                data.lastChunkID = s;
                if (chunk != null) {
                    player.method_7353(chunk.getTeamData().getTeam().getColoredName(), true);
                } else {
                    player.method_7353((class_2561)new class_2588("wilderness").method_27692(class_124.field_1077), true);
                }
            }
            data.prevChunkX = chunkX;
            data.prevChunkZ = chunkZ;
        }
    }

    public EventResult checkSpawn(class_1309 entity, class_1936 level, double x, double y, double z, class_3730 type, @Nullable class_1917 spawner) {
        if (!level.method_8608() && !(entity instanceof class_1657) && level instanceof class_1937) {
            switch (type) {
                case field_16459: 
                case field_16472: 
                case field_16469: 
                case field_16474: 
                case field_16460: 
                case field_16527: {
                    ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos((class_1937)level, new class_2338(x, y, z)));
                    if (chunk == null || chunk.canEntitySpawn((class_1297)entity)) break;
                    return EventResult.interrupt((Boolean)false);
                }
            }
        }
        return EventResult.pass();
    }

    private boolean ignoreExplosion(class_1937 level, class_1927 explosion) {
        if (level.method_8608() || explosion.method_8346().isEmpty()) {
            return true;
        }
        return explosion.field_9185 == null;
    }

    public void explosionDetonate(class_1937 level, class_1927 explosion, List<class_1297> affectedEntities) {
        if (this.ignoreExplosion(level, explosion)) {
            return;
        }
        ArrayList list = new ArrayList(explosion.method_8346());
        explosion.method_8352();
        HashMap<ChunkDimPos, Boolean> map = new HashMap<ChunkDimPos, Boolean>();
        for (class_2338 pos : list) {
            if (!map.computeIfAbsent(new ChunkDimPos(level, pos), cpos -> {
                ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk((ChunkDimPos)cpos);
                return chunk == null || chunk.allowExplosions();
            }).booleanValue()) continue;
            explosion.method_8346().add(pos);
        }
    }

    public EventResult playerDeath(class_1309 entity, class_1282 source) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            class_5321 dim = player.field_6002.method_27983();
            int x = class_3532.method_15357((double)player.method_23317());
            int y = class_3532.method_15357((double)player.method_23318());
            int z = class_3532.method_15357((double)player.method_23321());
            int num = player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15421)) + 1;
            new PlayerDeathPacket((class_5321<class_1937>)dim, x, y, z, num).sendTo((class_3222)entity);
        }
        return EventResult.pass();
    }

    private void teamConfig(TeamCollectPropertiesEvent event) {
        event.add((TeamProperty)FTBChunksTeamData.ALLOW_FAKE_PLAYERS);
        event.add((TeamProperty)FTBChunksTeamData.BLOCK_EDIT_MODE);
        event.add((TeamProperty)FTBChunksTeamData.BLOCK_INTERACT_MODE);
    }

    private void playerJoinedParty(PlayerJoinedPartyTeamEvent event) {
        SendManyChunksPacket packet;
        class_2168 sourceStack = event.getTeam().manager.server.method_3739();
        FTBChunksTeamData oldData = FTBChunksAPI.getManager().getData((Team)event.getPreviousTeam());
        FTBChunksTeamData newData = FTBChunksAPI.getManager().getData(event.getTeam());
        newData.updateLimits(event.getPlayer());
        HashMap<class_5321, List> chunksToSend = new HashMap<class_5321, List>();
        HashMap<class_5321, List> chunksToUnclaim = new HashMap<class_5321, List>();
        int chunks = 0;
        long now = System.currentTimeMillis();
        int total = 0;
        for (ClaimedChunk claimedChunk : oldData.getClaimedChunks()) {
            if (total >= newData.maxClaimChunks) {
                claimedChunk.unclaim(sourceStack, false);
                chunksToUnclaim.computeIfAbsent(claimedChunk.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, claimedChunk.pos.x, claimedChunk.pos.z, null));
            } else {
                claimedChunk.teamData = newData;
                chunksToSend.computeIfAbsent(claimedChunk.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, claimedChunk.pos.x, claimedChunk.pos.z, claimedChunk));
                ++chunks;
            }
            ++total;
        }
        if (chunks == 0) {
            return;
        }
        for (Map.Entry entry : chunksToSend.entrySet()) {
            packet = new SendManyChunksPacket();
            packet.dimension = (class_5321)entry.getKey();
            packet.teamId = newData.getTeamId();
            packet.chunks = (List)entry.getValue();
            packet.sendToAll(sourceStack.method_9211());
        }
        for (Map.Entry entry : chunksToUnclaim.entrySet()) {
            packet = new SendManyChunksPacket();
            packet.dimension = (class_5321)entry.getKey();
            packet.teamId = class_156.field_25140;
            packet.chunks = (List)entry.getValue();
            packet.sendToAll(sourceStack.method_9211());
        }
        LOGGER.info("Transferred " + chunks + "/" + total + " chunks from " + oldData + " to " + newData);
    }

    private void teamOwnershipTransferred(PlayerTransferredTeamOwnershipEvent event) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(event.getTeam());
        data.updateLimits(event.getTo());
    }

    static {
        RELATIVE_SPIRAL_POSITIONS = new XZ[225];
        BLOCK_REGISTRY = Registries.get((String)MOD_ID).get(class_2378.field_25105);
        ranksMod = false;
    }
}

