/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.kibe.mixin;

import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.impl.PlayerAbilityView;
import io.github.lucaargolo.kibe.items.ItemCompendiumKt;
import io.github.lucaargolo.kibe.items.miscellaneous.AbilityRing;
import io.github.lucaargolo.kibe.items.miscellaneous.Glider;
import io.github.lucaargolo.kibe.items.miscellaneous.SleepingBag;
import io.github.lucaargolo.kibe.mixed.PlayerEntityMixed;
import io.github.lucaargolo.kibe.utils.GliderHelper;
import io.github.lucaargolo.kibe.utils.RingAbilitiesKt;
import io.github.lucaargolo.kibe.utils.SlimeBounceHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Pair;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements PlayerEntityMixed {
    private final List<Pair<class_1799, Long>> kibe_activeRingsList = new ArrayList<Pair<class_1799, Long>>();

    protected PlayerEntityMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Override
    public List<Pair<class_1799, Long>> getKibe_activeRingsList() {
        return this.kibe_activeRingsList;
    }

    @Inject(at={@At(value="TAIL")}, method={"eatFood"})
    public void eatFood(class_1937 world, class_1799 stack, CallbackInfoReturnable<class_1799> info) {
        int x;
        if (stack.method_7909().equals(ItemCompendiumKt.getCURSED_KIBE()) && !world.field_9236 && (x = this.field_5974.nextInt(64)) == 0) {
            this.method_5768();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"wakeUp()V"})
    private void wakeUpV(CallbackInfo info) {
        SleepingBag.Companion.getPlayersSleeping().remove(this);
    }

    @Inject(at={@At(value="TAIL")}, method={"wakeUp(ZZ)V"})
    private void wakeUpZ(CallbackInfo info) {
        SleepingBag.Companion.getPlayersSleeping().remove(this);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tick(CallbackInfo info) {
        class_1657 player = (class_1657)this;
        class_1799 cursorStack = player.field_7498.method_34255();
        if (cursorStack.method_7909() instanceof Glider && Glider.Companion.isEnabled(cursorStack)) {
            cursorStack.method_7948().method_10556("enabled", false);
        }
        if (!this.method_24828() && !this.method_5799() && !this.method_6128() && this.method_18798().field_1351 < 0.0) {
            boolean isGliding;
            class_1799 mainHandStack = player.method_6047();
            class_1799 offHandStack = player.method_6079();
            boolean bl = isGliding = mainHandStack.method_7909() instanceof Glider && Glider.Companion.isEnabled(mainHandStack) || offHandStack.method_7909() instanceof Glider && Glider.Companion.isEnabled(offHandStack);
            if (isGliding) {
                GliderHelper.INSTANCE.setPlayerGliding(player, true);
                float hSpeed = 0.05f;
                float vSpeed = 0.5f;
                if (this.method_5715()) {
                    hSpeed = (float)((double)hSpeed * 2.5);
                    vSpeed = (float)((double)vSpeed * 1.5);
                }
                class_243 v = this.method_18798();
                player.method_18800(v.field_1352, v.field_1351 * (double)vSpeed, v.field_1350);
                v = this.method_18798();
                double x = Math.cos(Math.toRadians(player.field_6241 + 90.0f)) * (double)hSpeed;
                double z = Math.sin(Math.toRadians(player.field_6241 + 90.0f)) * (double)hSpeed;
                player.method_18800(v.field_1352 + x, v.field_1351, v.field_1350 + z);
                this.field_6017 = 0.0f;
                this.field_6007 = true;
            } else {
                GliderHelper.INSTANCE.setPlayerGliding(player, false);
            }
        } else {
            GliderHelper.INSTANCE.setPlayerGliding(player, false);
        }
        Iterator<class_1297> keyIt = this.field_6002.field_9236 ? SlimeBounceHandler.Companion.getClientBouncingEntities().keySet().iterator() : SlimeBounceHandler.Companion.getServerBouncingEntities().keySet().iterator();
        while (keyIt.hasNext()) {
            class_1297 entity = keyIt.next();
            SlimeBounceHandler bounce = this.field_6002.field_9236 ? SlimeBounceHandler.Companion.getClientBouncingEntities().get(entity) : SlimeBounceHandler.Companion.getServerBouncingEntities().get(entity);
            if (!player.equals((Object)entity) || player.method_6128()) continue;
            if (player.field_6012 == bounce.getBounceTick()) {
                class_243 velocity = this.method_18798();
                this.method_18800(velocity.field_1352, bounce.getBounce(), velocity.field_1350);
                bounce.setBounceTick(0);
            }
            if (!(player.method_24828() || player.field_6012 == bounce.getBounceTick() || bounce.getLastMovX() == this.method_18798().field_1352 && bounce.getLastMovZ() == this.method_18798().field_1350)) {
                double f = 0.935;
                class_243 velocity = this.method_18798();
                this.method_18800(velocity.field_1352 / f, velocity.field_1351, velocity.field_1350 / f);
                this.field_6007 = true;
                bounce.setLastMovX(this.method_18798().field_1352);
                bounce.setLastMovZ(this.method_18798().field_1350);
            }
            if (bounce.getWasInAir() && player.method_24828() || player.method_5799()) {
                if (bounce.getTimer() == 0) {
                    bounce.setTimer(player.field_6012);
                    continue;
                }
                if (player.field_6012 - bounce.getTimer() <= 5) continue;
                keyIt.remove();
                SlimeBounceHandler.Companion.getServerBouncingEntities().remove(entity);
                continue;
            }
            bounce.setTimer(0);
            bounce.setWasInAir(true);
        }
        if (!this.field_6002.field_9236 && this instanceof PlayerAbilityView) {
            for (PlayerAbility pa : RingAbilitiesKt.getPotionToAbilityMap().keySet()) {
                if (!pa.isEnabledFor(player)) continue;
                class_1291 se = RingAbilitiesKt.getPotionToAbilityMap().get(pa);
                class_1293 sei = new class_1293(se, 100);
                player.method_6092(sei);
            }
            LinkedHashMap<AbilityRing, List> ringMap = new LinkedHashMap<AbilityRing, List>();
            for (Pair<class_1799, Long> pair : this.kibe_activeRingsList) {
                class_1799 ringStack = (class_1799)pair.getFirst();
                class_1792 ringItem = ringStack.method_7909();
                if (!(ringItem instanceof AbilityRing) || !ringStack.method_7948().method_10577("enabled")) continue;
                ringMap.computeIfAbsent((AbilityRing)ringItem, k -> new ArrayList());
                ((List)ringMap.get(ringItem)).add(ringStack);
            }
            AbilityRing.Companion.getRINGS().forEach(ring -> {
                if (ringMap.containsKey(ring)) {
                    if (ringMap.size() == 1 && ((List)ringMap.get(ring)).size() == 1) {
                        RingAbilitiesKt.getRingAbilitySource().grantTo(player, ring.getAbility());
                        class_1799 ringStack = (class_1799)((List)ringMap.get(ring)).get(0);
                        if (!ringStack.method_7948().method_10577("unique")) {
                            ringStack.method_7948().method_10556("unique", true);
                        }
                    } else {
                        if (RingAbilitiesKt.getRingAbilitySource().grants(player, ring.getAbility())) {
                            RingAbilitiesKt.getRingAbilitySource().revokeFrom(player, ring.getAbility());
                        }
                        for (class_1799 ringStack : (List)ringMap.get(ring)) {
                            if (!ringStack.method_7948().method_10577("unique")) continue;
                            ringStack.method_7948().method_10556("unique", false);
                        }
                    }
                } else if (RingAbilitiesKt.getRingAbilitySource().grants(player, ring.getAbility())) {
                    RingAbilitiesKt.getRingAbilitySource().revokeFrom(player, ring.getAbility());
                }
            });
        }
    }
}

