/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.wandering_trapper.server;

import java.util.Optional;
import java.util.Random;
import lilypuree.wandering_trapper.core.RegistryObjects;
import lilypuree.wandering_trapper.entity.TrapperDogEntity;
import lilypuree.wandering_trapper.entity.WanderingTrapperEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_4538;
import net.minecraft.class_5304;

public class WanderingTrapperSpawner
implements class_5304 {
    private static final int DEFAULT_TICK_DELAY = 1200;
    public static final int DEFAULT_SPAWN_DELAY = 2400;
    private static final int MIN_SPAWN_CHANCE = 25;
    private static final int MAX_SPAWN_CHANCE = 75;
    private static final int SPAWN_CHANCE_INCREASE = 25;
    private static final int SPAWN_ONE_IN_X_CHANCE = 10;
    private static final int NUMBER_OF_SPAWN_ATTEMPTS = 10;
    private final Random random = new Random();
    private int tickDelay = 1200;
    private int spawnDelay = 2400;
    private int spawnChance = 25;

    public int method_6445(class_3218 level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!level.method_8450().method_8355(class_1928.field_21832)) {
            return 0;
        }
        if (--this.tickDelay > 0) {
            return 0;
        }
        this.tickDelay = 1200;
        this.spawnDelay -= 1200;
        if (this.spawnDelay > 0) {
            return 0;
        }
        this.spawnDelay = 2400;
        if (!level.method_8450().method_8355(class_1928.field_19390)) {
            return 0;
        }
        int chance = this.spawnChance;
        this.spawnChance = class_3532.method_15340((int)(this.spawnChance + 25), (int)25, (int)75);
        if (this.random.nextInt(100) > chance) {
            return 0;
        }
        if (this.spawnTrapper(level)) {
            this.spawnChance = 25;
            return 1;
        }
        return 0;
    }

    private boolean spawnTrapper(class_3218 world) {
        class_3222 playerentity = world.method_18779();
        if (playerentity == null) {
            return true;
        }
        if (this.random.nextInt(10) != 0) {
            return false;
        }
        class_2338 playerPos = playerentity.method_24515();
        int range = 48;
        class_4153 poiManager = world.method_19494();
        Optional optional = poiManager.method_19127(class_4158.field_18518.method_19164(), k -> true, playerPos, range, class_4153.class_4155.field_18489);
        class_2338 targetPos = optional.orElse(playerPos);
        class_2338 spawnPos = this.findSpawnPositionNear((class_4538)world, targetPos, 48);
        if (spawnPos != null && this.hasEnoughSpace((class_1922)world, spawnPos)) {
            if (world.method_23753(spawnPos).method_8712() > 0.0f) {
                return false;
            }
            WanderingTrapperEntity trapper = (WanderingTrapperEntity)RegistryObjects.WANDERING_TRAPPER.method_5899(world, (class_2487)null, (class_2561)null, (class_1657)null, spawnPos, class_3730.field_16467, false, false);
            if (trapper != null) {
                this.spawnDogs(trapper, 4);
                trapper.setDespawnDelay(48000);
                trapper.setWanderTarget(targetPos);
                trapper.method_18408(targetPos, 16);
                return true;
            }
        }
        return false;
    }

    private void spawnDogs(WanderingTrapperEntity trapper, int radius) {
        TrapperDogEntity trapperDogEntity;
        class_2338 blockpos = this.findSpawnPositionNear((class_4538)trapper.method_37908(), new class_2338((class_2382)trapper.method_24515()), radius);
        if (blockpos != null && (trapperDogEntity = (TrapperDogEntity)RegistryObjects.TRAPPER_DOG.method_5899((class_3218)trapper.method_37908(), (class_2487)null, (class_2561)null, (class_1657)null, blockpos, class_3730.field_16467, false, false)) != null) {
            trapperDogEntity.method_5954((class_1297)trapper, true);
            trapperDogEntity.method_6174(trapper.method_5667());
        }
    }

    private class_2338 findSpawnPositionNear(class_4538 world, class_2338 pos, int radius) {
        class_2338 blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pos.method_10263() + this.random.nextInt(radius * 2) - radius;
            class_2338 temp = new class_2338(j, l = world.method_8624(class_2902.class_2903.field_13202, j, k = pos.method_10260() + this.random.nextInt(radius * 2) - radius), k);
            if (!class_1948.method_8660((class_1317.class_1319)class_1317.class_1319.field_19350, (class_4538)world, (class_2338)temp, RegistryObjects.WANDERING_TRAPPER)) continue;
            blockpos = temp;
            break;
        }
        return blockpos;
    }

    private boolean hasEnoughSpace(class_1922 world, class_2338 pos) {
        for (class_2338 temp : class_2338.method_10097((class_2338)pos, (class_2338)pos.method_10069(1, 2, 1))) {
            if (world.method_8320(temp).method_26220(world, temp).method_1110()) continue;
            return false;
        }
        return true;
    }
}

