/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.wandering_trapper.entity.ai;

import java.util.EnumSet;
import lilypuree.wandering_trapper.compat.IWeaponSelector;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1603;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class CustomRangedAttackGoal<T extends class_1308>
extends class_1352 {
    private final T entity;
    private final double moveSpeedAmp;
    private int attackCooldown;
    private final float maxAttackDistance;
    private final float minAttackDistance = 4.0f;
    private int attackTime = -1;
    private int seeTime;
    private int closeTime = -1;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private IWeaponSelector weaponSelector;

    public CustomRangedAttackGoal(T mob, IWeaponSelector selector) {
        this.weaponSelector = selector;
        this.entity = mob;
        this.moveSpeedAmp = selector.getMoveSpeedAmp();
        this.attackCooldown = selector.getAttackCooldown();
        this.maxAttackDistance = selector.getMaxAttackDistance() * selector.getMaxAttackDistance();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    public boolean method_6264() {
        return this.entity.method_5968() == null ? false : this.isWeaponInMainhand();
    }

    public boolean method_6266() {
        if (this.closeTime > 40) {
            return false;
        }
        return (this.method_6264() || !this.entity.method_5942().method_6357()) && this.isWeaponInMainhand();
    }

    public void method_6269() {
        super.method_6269();
        this.entity.method_19540(true);
    }

    public void method_6270() {
        super.method_6270();
        this.entity.method_19540(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.closeTime = 0;
        this.entity.method_6021();
    }

    protected boolean isWeaponInMainhand() {
        class_1799 main = this.entity.method_6047();
        class_1799 off = this.entity.method_6079();
        return main.method_7909() == this.weaponSelector.getWeapon() || off.method_7909() == this.weaponSelector.getWeapon();
    }

    public void method_6268() {
        class_1309 target = this.entity.method_5968();
        if (target != null) {
            boolean seeing;
            double d0 = this.entity.method_5649(target.method_23317(), target.method_5829().field_1322, target.method_23321());
            boolean canSeeEntity = this.entity.method_5985().method_6369((class_1297)target);
            boolean bl = seeing = this.seeTime > 0;
            if (canSeeEntity != seeing) {
                this.seeTime = 0;
                this.closeTime = 0;
            }
            this.seeTime = canSeeEntity ? ++this.seeTime : --this.seeTime;
            this.closeTime = d0 < 4.0 ? ++this.closeTime : 0;
            if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                this.entity.method_5942().method_6340();
                ++this.strafingTime;
            } else {
                this.entity.method_5942().method_6335((class_1297)target, this.moveSpeedAmp);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.entity.method_6051().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.method_6051().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.method_5962().method_6243(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.method_5951((class_1297)target, 30.0f, 30.0f);
            } else {
                this.entity.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            }
            if (this.entity.method_6115()) {
                int i;
                if (!canSeeEntity && this.seeTime < -60) {
                    this.entity.method_6021();
                } else if (canSeeEntity && (i = this.entity.method_6048()) >= this.weaponSelector.getWeaponLoadTime()) {
                    this.entity.method_6021();
                    ((class_1603)this.entity).method_7105(target, this.weaponSelector.getProjectileSpeed(i));
                    this.attackTime = this.attackCooldown;
                    this.closeTime = 0;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.entity.method_6019(class_1675.method_18812(this.entity, (class_1792)this.weaponSelector.getWeapon()));
            }
        }
    }
}

