/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.mixin.bannerpattern;

import io.github.fablabsmc.fablabs.api.bannerpattern.v1.LoomPattern;
import io.github.fablabsmc.fablabs.api.bannerpattern.v1.LoomPatternProvider;
import io.github.fablabsmc.fablabs.api.bannerpattern.v1.LoomPatterns;
import io.github.fablabsmc.fablabs.api.bannerpattern.v1.PatternLimitModifier;
import io.github.fablabsmc.fablabs.impl.bannerpattern.LoomPatternsInternal;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1726;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2573;
import net.minecraft.class_2582;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1726.class})
public abstract class LoomContainerMixin
extends class_1703 {
    @Shadow
    @Final
    class_3915 field_17317;
    @Shadow
    @Final
    class_1735 field_17319;
    @Shadow
    @Final
    class_1735 field_17320;
    @Shadow
    @Final
    private class_1735 field_17321;
    @Shadow
    @Final
    private class_1735 field_17322;
    @Unique
    private class_1657 player;
    @Unique
    private int patternLimit;

    private LoomContainerMixin() {
        super(null, 0);
    }

    @Shadow
    private native void method_7648();

    @Inject(method={"<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/screen/ScreenHandlerContext;)V"}, at={@At(value="RETURN")})
    private void bppSavePlayer(int capacity, class_1661 playerInventory, class_3914 ctx, CallbackInfo info) {
        this.player = playerInventory.field_7546;
    }

    @Inject(method={"onButtonClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void selectBppLoomPatternOnClick(class_1657 entity, int clicked, CallbackInfoReturnable<Boolean> info) {
        int vanillaCount = class_2582.field_18283;
        if (clicked > vanillaCount && clicked - (1 + vanillaCount) < LoomPatternsInternal.dyeLoomPatternCount()) {
            this.field_17317.method_17404(-clicked);
            this.method_7648();
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onContentChanged"}, at={@At(value="HEAD")})
    private void invokePatternLimitEvent(CallbackInfo info) {
        this.patternLimit = ((PatternLimitModifier)PatternLimitModifier.EVENT.invoker()).computePatternLimit(6, this.player);
    }

    @Redirect(method={"onContentChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/screen/Property;get()I"))
    private int addBppLoomPatternCondition(class_3915 self) {
        int res = self.method_17407();
        if (res < 0) {
            res = 1;
        }
        return res;
    }

    @ModifyConstant(method={"onContentChanged"}, constant={@Constant(intValue=6)})
    private int disarmVanillaPatternLimitCheck(int limit) {
        return Integer.MAX_VALUE;
    }

    @ModifyVariable(method={"onContentChanged"}, at=@At(value="LOAD", ordinal=0), ordinal=0)
    private boolean addBppLoomPatternsToFullCond(boolean original) {
        class_1799 banner = this.field_17319.method_7677();
        return original || class_2573.method_10910((class_1799)banner) >= this.patternLimit;
    }

    @Inject(method={"onContentChanged"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal=4)})
    private void updateBppContentChanged(CallbackInfo info) {
        class_1792 class_17922;
        class_1799 banner = this.field_17319.method_7677();
        class_1799 patternStack = this.field_17321.method_7677();
        if (!patternStack.method_7960() && (class_17922 = patternStack.method_7909()) instanceof LoomPatternProvider) {
            boolean overfull;
            LoomPatternProvider provider = (LoomPatternProvider)class_17922;
            boolean bl = overfull = class_2573.method_10910((class_1799)banner) >= this.patternLimit;
            if (!overfull) {
                LoomPattern pattern = provider.getPattern();
                this.field_17317.method_17404(-LoomPatternsInternal.getLoomIndex(pattern) - (1 + class_2582.field_18283));
            } else {
                this.field_17317.method_17404(0);
            }
        } else if (-this.field_17317.method_17407() - (1 + class_2582.field_18283) >= LoomPatternsInternal.dyeLoomPatternCount()) {
            this.field_17317.method_17404(0);
            this.field_17322.method_7673(class_1799.field_8037);
        }
    }

    @Inject(method={"updateOutputSlot"}, at={@At(value="HEAD")})
    private void addBppLoomPatternToOutput(CallbackInfo info) {
        int rawId;
        class_1799 bannerStack = this.field_17319.method_7677();
        class_1799 dyeStack = this.field_17320.method_7677();
        if (this.field_17317.method_17407() < 0 && !bannerStack.method_7960() && !dyeStack.method_7960() && (rawId = -this.field_17317.method_17407() - (1 + class_2582.field_18283)) < LoomPatternsInternal.totalLoomPatternCount()) {
            class_2499 loomPatterns;
            LoomPattern pattern = LoomPatternsInternal.byLoomIndex(rawId);
            class_1767 color = ((class_1769)dyeStack.method_7909()).method_7802();
            class_1799 output = bannerStack.method_7972();
            output.method_7939(1);
            class_2487 beTag = output.method_7911("BlockEntityTag");
            if (beTag.method_10573("Bannerpp_LoomPatterns", 9)) {
                loomPatterns = beTag.method_10554("Bannerpp_LoomPatterns", 10);
            } else {
                loomPatterns = new class_2499();
                beTag.method_10566("Bannerpp_LoomPatterns", (class_2520)loomPatterns);
            }
            int vanillaPatternCount = beTag.method_10554("Patterns", 10).size();
            class_2487 patternTag = new class_2487();
            patternTag.method_10582("Pattern", LoomPatterns.REGISTRY.method_10221((Object)pattern).toString());
            patternTag.method_10569("Color", color.method_7789());
            patternTag.method_10569("Index", vanillaPatternCount);
            loomPatterns.add((Object)patternTag);
            if (!class_1799.method_7973((class_1799)output, (class_1799)this.field_17322.method_7677())) {
                this.field_17322.method_7673(output);
            }
        }
    }

    @Inject(method={"transferSlot"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getItem()Lnet/minecraft/item/Item;", ordinal=0, shift=At.Shift.BEFORE)}, cancellable=true)
    private void attemptBppPatternItemTransfer(class_1657 player, int slotIdx, CallbackInfoReturnable<class_1799> info) {
        class_1799 stack = ((class_1735)this.field_7761.get(slotIdx)).method_7677();
        if (stack.method_7909() instanceof LoomPatternProvider && !this.method_7616(stack, this.field_17321.field_7874, this.field_17321.field_7874 + 1, false)) {
            info.setReturnValue((Object)class_1799.field_8037);
        }
    }
}

