/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.impl.bannerpattern;

import io.github.fablabsmc.fablabs.api.bannerpattern.v1.LoomPattern;
import io.github.fablabsmc.fablabs.api.bannerpattern.v1.LoomPatterns;
import java.util.ArrayList;
import java.util.List;

public final class LoomPatternsInternal {
    private static final List<LoomPattern> nonSpecialPatterns = new ArrayList<LoomPattern>();
    private static final List<LoomPattern> specialPatterns = new ArrayList<LoomPattern>();

    private LoomPatternsInternal() {
    }

    public static int getLoomIndex(LoomPattern pattern) {
        if (pattern.isSpecial()) {
            return specialPatterns.indexOf(pattern) + nonSpecialPatterns.size();
        }
        return nonSpecialPatterns.indexOf(pattern);
    }

    public static LoomPattern byLoomIndex(int loomIndex) {
        if (loomIndex < nonSpecialPatterns.size()) {
            return nonSpecialPatterns.get(loomIndex);
        }
        return specialPatterns.get(loomIndex - nonSpecialPatterns.size());
    }

    public static int dyeLoomPatternCount() {
        return nonSpecialPatterns.size();
    }

    public static int totalLoomPatternCount() {
        return nonSpecialPatterns.size() + specialPatterns.size();
    }

    public static void remapLoomIndices() {
        nonSpecialPatterns.clear();
        specialPatterns.clear();
        for (LoomPattern p : LoomPatterns.REGISTRY) {
            LoomPatternsInternal.addPattern(p);
        }
    }

    static void addPattern(LoomPattern pattern) {
        if (!pattern.isSpecial()) {
            nonSpecialPatterns.add(pattern);
        } else {
            specialPatterns.add(pattern);
        }
    }
}

