/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.advancementsenlarger.gui;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import me.shedaniel.advancementsenlarger.gui.BiggerAdvancementTab;
import me.shedaniel.advancementsenlarger.gui.BiggerAdvancementWidget;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2859;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_333;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_632;
import net.minecraft.class_634;
import net.minecraft.class_757;

public class BiggerAdvancementsScreen
extends class_437
implements class_632.class_633 {
    private static final class_2960 WINDOW_TEXTURE = new class_2960("advancements-enlarger:textures/gui/advancements/recipecontainer.png");
    private static final class_2960 WINDOW_DARK_TEXTURE = new class_2960("advancements-enlarger:textures/gui/advancements/recipecontainer_dark.png");
    private static final class_2960 TABS_TEXTURE = new class_2960("textures/gui/advancements/tabs.png");
    private static final class_2960 TABS_DARK_TEXTURE = new class_2960("advancements-enlarger:textures/gui/advancements/tabs_dark.png");
    private final class_632 advancementHandler;
    private final Map<class_161, BiggerAdvancementTab> tabs = Maps.newLinkedHashMap();
    private BiggerAdvancementTab selectedTab;
    private boolean movingTab;
    private Supplier<Boolean> reiExists = Suppliers.memoize(() -> FabricLoader.getInstance().isModLoaded("roughlyenoughitems"));
    private BooleanSupplier darkMode = () -> {
        if (!this.reiExists.get().booleanValue()) {
            return false;
        }
        try {
            Object reiHelper = Class.forName("me.shedaniel.rei.api.REIHelper").getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            return (Boolean)Class.forName("me.shedaniel.rei.api.REIHelper").getDeclaredMethod("isDarkThemeEnabled", new Class[0]).invoke(reiHelper, new Object[0]);
        }
        catch (Throwable throwable) {
            return false;
        }
    };

    public BiggerAdvancementsScreen(class_632 clientAdvancementManager) {
        super(class_333.field_18967);
        this.advancementHandler = clientAdvancementManager;
    }

    private boolean isDarkMode() {
        try {
            return this.darkMode.getAsBoolean();
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected void method_25426() {
        this.tabs.clear();
        this.selectedTab = null;
        this.advancementHandler.method_2862((class_632.class_633)this);
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            this.advancementHandler.method_2864(this.tabs.values().iterator().next().getRoot(), true);
        } else {
            this.advancementHandler.method_2864(this.selectedTab == null ? null : this.selectedTab.getRoot(), true);
        }
    }

    public void method_25432() {
        this.advancementHandler.method_2862(null);
        class_634 clientPlayNetworkHandler = this.field_22787.method_1562();
        if (clientPlayNetworkHandler != null) {
            clientPlayNetworkHandler.method_2883((class_2596)class_2859.method_12414());
        }
    }

    public boolean method_25401(double d, double e, double amount) {
        if (this.selectedTab == null) {
            return false;
        }
        this.selectedTab.scroll(amount);
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int i = 8;
            int j = 33;
            for (BiggerAdvancementTab advancementTab : this.tabs.values()) {
                if (!advancementTab.isClickOnTab(i, j, mouseX, mouseY)) continue;
                this.advancementHandler.method_2864(advancementTab.getRoot(), true);
                break;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787.field_1690.field_1844.method_1417(keyCode, scanCode)) {
            this.field_22787.method_1507(null);
            this.field_22787.field_1729.method_1612();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int i = 8;
        int j = 33;
        this.method_25420(matrices);
        this.drawAdvancementTree(matrices, mouseX, mouseY, i, j);
        this.drawWidgets(matrices, i, j);
        this.drawWidgetTooltip(matrices, mouseX, mouseY, i, j);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button != 0) {
            this.movingTab = false;
            return false;
        }
        if (!this.movingTab) {
            this.movingTab = true;
        } else if (this.selectedTab != null) {
            this.selectedTab.move(deltaX, deltaY);
        }
        return true;
    }

    private void drawAdvancementTree(class_4587 matrices, int mouseX, int mouseY, int x, int i) {
        BiggerAdvancementTab advancementTab = this.selectedTab;
        if (advancementTab == null) {
            BiggerAdvancementsScreen.method_25294((class_4587)matrices, (int)(x + 9), (int)(i + 18), (int)(this.field_22789 - 9), (int)(this.field_22790 - 17), (int)-16777216);
            String string = class_1074.method_4662((String)"advancements.empty", (Object[])new Object[0]);
            int j = this.field_22793.method_1727(string);
            this.field_22793.method_1729(matrices, string, (float)((this.field_22789 - j) / 2), (float)((this.field_22790 - 33) / 2 + 33 - 4), -1);
            this.field_22793.method_1729(matrices, ":(", (float)((this.field_22789 - this.field_22793.method_1727(":(")) / 2), (float)((this.field_22790 - 33) / 2 + 33 + 9 + 4), -1);
        } else {
            matrices.method_22903();
            matrices.method_22904((double)(x + 9), (double)(i + 18), 0.0);
            advancementTab.render(matrices);
            matrices.method_22909();
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
        }
    }

    public void drawWidgets(class_4587 matrices, int x, int i) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        this.drawWindow(matrices, x, i);
        if (this.tabs.size() > 1) {
            RenderSystem.setShaderTexture((int)0, (class_2960)(this.isDarkMode() ? TABS_DARK_TEXTURE : TABS_TEXTURE));
            for (BiggerAdvancementTab advancementTab2 : this.tabs.values()) {
                advancementTab2.drawBackground(matrices, x, i, advancementTab2 == this.selectedTab);
            }
            RenderSystem.defaultBlendFunc();
            for (BiggerAdvancementTab advancementTab2 : this.tabs.values()) {
                advancementTab2.drawIcon(matrices, x, i, this.field_22788);
            }
            RenderSystem.disableBlend();
        }
        this.field_22793.method_30883(matrices, (class_2561)new class_2588("gui.advancements"), (float)(x + 8), (float)(i + 6), this.isDarkMode() ? -1 : 0x404040);
    }

    private void drawWindow(class_4587 matrices, int x, int y) {
        boolean darkMode = this.isDarkMode();
        RenderSystem.setShaderTexture((int)0, (class_2960)(!darkMode ? WINDOW_TEXTURE : WINDOW_DARK_TEXTURE));
        int width = this.field_22789 - 16;
        int height = this.field_22790 - 41;
        this.method_25302(matrices, x, y, 106, 190, 4, 4);
        this.method_25302(matrices, x + width - 4, y, 252, 190, 4, 4);
        this.method_25302(matrices, x, y + height - 4, 106, 252, 4, 4);
        this.method_25302(matrices, x + width - 4, y + height - 4, 252, 252, 4, 4);
        for (int xx = 4; xx < width - 4; xx += 128) {
            int thisWidth = Math.min(128, width - 4 - xx);
            this.method_25302(matrices, x + xx, y, 110, 190, thisWidth, 4);
            this.method_25302(matrices, x + xx, y + height - 4, 110, 252, thisWidth, 4);
        }
        for (int yy = 4; yy < height - 4; yy += 50) {
            int thisHeight = Math.min(50, height - 4 - yy);
            this.method_25302(matrices, x, y + yy, 106, 194, 4, thisHeight);
            this.method_25302(matrices, x + width - 4, y + yy, 252, 194, 4, thisHeight);
        }
        int color = darkMode ? -13750738 : -3750202;
        this.method_25296(matrices, x + 4, y + 4, x + width - 4, y + 18, color, color);
        this.method_25296(matrices, x + 4, y + 4, x + 9, y + height - 4, color, color);
        this.method_25296(matrices, x + width - 9, y + 4, x + width - 4, y + height - 4, color, color);
        this.method_25296(matrices, x + 4, y + height - 9, x + width - 4, y + height - 4, color, color);
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_289 tessellator = class_289.method_1348();
        RenderSystem.setShader(class_757::method_34540);
        class_287 bufferBuilder = tessellator.method_1349();
        int zOffset = this.method_25305();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22912((double)(x + width - 9), (double)(y + 18), (double)zOffset).method_1336(0, 0, 0, 150).method_1344();
        bufferBuilder.method_22912((double)(x + 9), (double)(y + 18), (double)zOffset).method_1336(0, 0, 0, 150).method_1344();
        bufferBuilder.method_22912((double)(x + 9), (double)(y + 24), (double)zOffset).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)(x + width - 9), (double)(y + 24), (double)zOffset).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)(x + width - 9), (double)(y + height - 9 - 9), (double)zOffset).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)(x + 9), (double)(y + height - 9 - 9), (double)zOffset).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)(x + 9), (double)(y + height - 9), (double)zOffset).method_1336(0, 0, 0, 150).method_1344();
        bufferBuilder.method_22912((double)(x + width - 9), (double)(y + height - 9), (double)zOffset).method_1336(0, 0, 0, 150).method_1344();
        bufferBuilder.method_22912((double)(x + 15), (double)(y + 18), (double)zOffset).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)(x + 9), (double)(y + 18), (double)zOffset).method_1336(0, 0, 0, 150).method_1344();
        bufferBuilder.method_22912((double)(x + 9), (double)(y + height - 9), (double)zOffset).method_1336(0, 0, 0, 150).method_1344();
        bufferBuilder.method_22912((double)(x + 15), (double)(y + height - 9), (double)zOffset).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)(x + width - 9), (double)(y + 18), (double)zOffset).method_1336(0, 0, 0, 150).method_1344();
        bufferBuilder.method_22912((double)(x + width - 9 - 9), (double)(y + 18), (double)zOffset).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)(x + width - 9 - 9), (double)(y + height - 9), (double)zOffset).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)(x + width - 9), (double)(y + height - 9), (double)zOffset).method_1336(0, 0, 0, 150).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    private void drawWidgetTooltip(class_4587 matrices, int mouseX, int mouseY, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            matrices.method_22903();
            RenderSystem.enableDepthTest();
            matrices.method_22904((double)(x + 9), (double)(y + 18), 400.0);
            this.selectedTab.drawWidgetTooltip(matrices, mouseX - x - 9, mouseY - y - 18, x, y);
            RenderSystem.disableDepthTest();
            matrices.method_22909();
        }
        if (this.tabs.size() > 1) {
            for (BiggerAdvancementTab advancementTab : this.tabs.values()) {
                if (!advancementTab.isClickOnTab(x, y, mouseX, mouseY)) continue;
                this.method_25424(matrices, advancementTab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void method_723(class_161 root) {
        try {
            BiggerAdvancementTab advancementTab = BiggerAdvancementTab.create(this.field_22787, this, this.tabs.size(), root);
            if (advancementTab != null) {
                this.tabs.put(root, advancementTab);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void method_720(class_161 root) {
    }

    public void method_721(class_161 dependent) {
        BiggerAdvancementTab advancementTab = this.getTab(dependent);
        if (advancementTab != null) {
            advancementTab.addAdvancement(dependent);
        }
    }

    public void method_719(class_161 dependent) {
    }

    public void method_2865(class_161 advancement, class_167 advancementProgress) {
        BiggerAdvancementWidget advancementWidget = this.getAdvancementWidget(advancement);
        if (advancementWidget != null) {
            advancementWidget.setProgress(advancementProgress);
        }
    }

    public void method_2866(class_161 advancement) {
        this.selectedTab = this.tabs.get(advancement);
    }

    public void method_722() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    public BiggerAdvancementWidget getAdvancementWidget(class_161 advancement) {
        BiggerAdvancementTab advancementTab = this.getTab(advancement);
        return advancementTab == null ? null : advancementTab.getWidget(advancement);
    }

    private BiggerAdvancementTab getTab(class_161 advancement) {
        while (advancement.method_687() != null) {
            advancement = advancement.method_687();
        }
        return this.tabs.get(advancement);
    }
}

