/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.advancementsenlarger.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import me.shedaniel.advancementsenlarger.gui.BiggerAdvancementWidget;
import me.shedaniel.advancementsenlarger.gui.BiggerAdvancementsScreen;
import me.shedaniel.advancementsenlarger.hooks.AdvancementTabTypeHooks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1060;
import net.minecraft.class_161;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class BiggerAdvancementTab
extends class_332 {
    private final class_310 client;
    private final BiggerAdvancementsScreen screen;
    private final AdvancementTabTypeHooks type;
    private final int index;
    private final class_161 root;
    private final class_185 display;
    private final class_1799 icon;
    private final class_2561 title;
    private final BiggerAdvancementWidget rootWidget;
    private final Map<class_161, BiggerAdvancementWidget> widgets = Maps.newLinkedHashMap();
    private double originX;
    private double originY;
    private int minPanX = Integer.MAX_VALUE;
    private int minPanY = Integer.MAX_VALUE;
    private int maxPanX = Integer.MIN_VALUE;
    private int maxPanY = Integer.MIN_VALUE;
    private float alpha;
    private boolean initialized;

    public BiggerAdvancementTab(class_310 client, BiggerAdvancementsScreen screen, AdvancementTabTypeHooks type, int index, class_161 root, class_185 display) {
        this.client = client;
        this.screen = screen;
        this.type = type;
        this.index = index;
        this.root = root;
        this.display = display;
        this.icon = display.method_821();
        this.title = display.method_811();
        this.rootWidget = new BiggerAdvancementWidget(this, client, root, display);
        this.addWidget(this.rootWidget, root);
    }

    public static BiggerAdvancementTab create(class_310 minecraft, BiggerAdvancementsScreen screen, int index, class_161 root) throws ClassNotFoundException {
        if (root.method_686() != null) {
            ?[] var4 = Class.forName(FabricLoader.getInstance().getMappingResolver().mapClassName("intermediary", "net.minecraft.class_453")).getEnumConstants();
            int var5 = var4.length;
            int n = 0;
            ?[] objArray = var4;
            int n2 = objArray.length;
            if (n < n2) {
                Object o = objArray[n];
                AdvancementTabTypeHooks advancementTabType = (AdvancementTabTypeHooks)o;
                return new BiggerAdvancementTab(minecraft, screen, advancementTabType, index, root, root.method_686());
            }
        }
        return null;
    }

    public class_161 getRoot() {
        return this.root;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public void drawBackground(class_4587 matrices, int x, int y, boolean selected) {
        this.type.ae_drawBackground(matrices, this, x, y, selected, this.index);
    }

    public void drawIcon(class_4587 matrices, int x, int y, class_918 itemRenderer) {
        this.type.ae_drawIcon(matrices, x, y, this.index, itemRenderer, this.icon);
    }

    public void render(class_4587 matrices) {
        int width = this.screen.field_22789 - 34;
        int height = this.screen.field_22790 - 68;
        if (!this.initialized) {
            this.originX = width / 2 - (this.maxPanX + this.minPanX) / 2;
            this.originY = height / 2 - (this.maxPanY + this.minPanY) / 2;
            this.initialized = true;
        }
        matrices.method_22903();
        RenderSystem.enableDepthTest();
        matrices.method_22904(0.0, 0.0, 950.0);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        BiggerAdvancementTab.method_25294((class_4587)matrices, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        matrices.method_22904(0.0, 0.0, -950.0);
        RenderSystem.depthFunc((int)518);
        BiggerAdvancementTab.method_25294((class_4587)matrices, (int)width, (int)height, (int)0, (int)0, (int)-16777216);
        RenderSystem.depthFunc((int)515);
        class_2960 identifier = this.display.method_812();
        RenderSystem.setShader(class_757::method_34542);
        if (identifier != null) {
            RenderSystem.setShaderTexture((int)0, (class_2960)identifier);
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1060.field_5285);
        }
        int i = class_3532.method_15357((double)this.originX);
        int j = class_3532.method_15357((double)this.originY);
        int k = i % 16;
        int l = j % 16;
        for (int m = -1; m <= class_3532.method_15386((float)((float)width / 16.0f)) + 1; ++m) {
            for (int n = -1; n <= class_3532.method_15386((float)((float)height / 16.0f)) + 1; ++n) {
                BiggerAdvancementTab.method_25290((class_4587)matrices, (int)(k + 16 * m), (int)(l + 16 * n), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
        }
        this.rootWidget.renderLines(matrices, i, j, true);
        this.rootWidget.renderLines(matrices, i, j, false);
        this.rootWidget.renderWidgets(matrices, i, j);
        RenderSystem.depthFunc((int)518);
        matrices.method_22904(0.0, 0.0, -950.0);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        BiggerAdvancementTab.method_25294((class_4587)matrices, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        matrices.method_22904(0.0, 0.0, 950.0);
        RenderSystem.depthFunc((int)515);
        matrices.method_22909();
    }

    public void drawWidgetTooltip(class_4587 matrices, int mouseX, int mouseY, int x, int y) {
        int width = this.screen.field_22789 - 34;
        int height = this.screen.field_22790 - 68;
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 200.0);
        BiggerAdvancementTab.method_25294((class_4587)matrices, (int)0, (int)0, (int)width, (int)height, (int)(class_3532.method_15375((float)(this.alpha * 255.0f)) << 24));
        boolean bl = false;
        int i = class_3532.method_15357((double)this.originX);
        int j = class_3532.method_15357((double)this.originY);
        if (mouseX > 0 && mouseX < width && mouseY > 0 && mouseY < height) {
            for (BiggerAdvancementWidget advancementWidget : this.widgets.values()) {
                if (!advancementWidget.shouldRender(i, j, mouseX, mouseY)) continue;
                bl = true;
                advancementWidget.drawTooltip(matrices, i, j, this.alpha, x, y);
                break;
            }
        }
        matrices.method_22909();
        this.alpha = bl ? class_3532.method_15363((float)(this.alpha + 0.02f), (float)0.0f, (float)0.3f) : class_3532.method_15363((float)(this.alpha - 0.04f), (float)0.0f, (float)1.0f);
    }

    public boolean isClickOnTab(int screenX, int screenY, double mouseX, double mouseY) {
        return this.type.ae_isClickOnTab(screenX, screenY, this.index, mouseX, mouseY);
    }

    public void scroll(double amount) {
        int width = this.screen.field_22789 - 34;
        int height = this.screen.field_22790 - 68;
        if (this.maxPanX - this.minPanX > width) {
            this.move(amount * 10.0, 0.0);
            return;
        }
        if (this.maxPanY - this.minPanY > height) {
            this.move(0.0, amount * 10.0);
        }
    }

    public void move(double offsetX, double offsetY) {
        int width = this.screen.field_22789 - 34;
        int height = this.screen.field_22790 - 68;
        if (this.maxPanX - this.minPanX > width) {
            this.originX = class_3532.method_15350((double)(this.originX + offsetX), (double)(-(this.maxPanX - width)), (double)0.0);
        }
        if (this.maxPanY - this.minPanY > height) {
            this.originY = class_3532.method_15350((double)(this.originY + offsetY), (double)(-(this.maxPanY - height)), (double)0.0);
        }
    }

    public void addAdvancement(class_161 advancement) {
        if (advancement.method_686() != null) {
            BiggerAdvancementWidget advancementWidget = new BiggerAdvancementWidget(this, this.client, advancement, advancement.method_686());
            this.addWidget(advancementWidget, advancement);
        }
    }

    private void addWidget(BiggerAdvancementWidget widget, class_161 advancement) {
        this.widgets.put(advancement, widget);
        int i = widget.getX();
        int j = i + 28;
        int k = widget.getY();
        int l = k + 27;
        this.minPanX = Math.min(this.minPanX, i);
        this.maxPanX = Math.max(this.maxPanX, j);
        this.minPanY = Math.min(this.minPanY, k);
        this.maxPanY = Math.max(this.maxPanY, l);
        for (BiggerAdvancementWidget advancementWidget : this.widgets.values()) {
            advancementWidget.addToTree();
        }
    }

    public BiggerAdvancementWidget getWidget(class_161 advancement) {
        return this.widgets.get(advancement);
    }

    public BiggerAdvancementsScreen getScreen() {
        return this.screen;
    }
}

